/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.node;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.GeneratorWhiteSpaceConfig;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IndentNode;
import org.eclipse.xtext.generator.trace.node.NewLineNode;
import org.eclipse.xtext.generator.trace.node.TemplateNode;
import org.eclipse.xtext.generator.trace.node.TextNode;
import org.eclipse.xtext.generator.trace.node.TraceNode;

public class GeneratorNodeExtensions {
    @Inject
    private GeneratorWhiteSpaceConfig wsConfig = new GeneratorWhiteSpaceConfig();

    public CompositeGeneratorNode trace(ILocationData data) {
        TraceNode result = new TraceNode(data);
        return result;
    }

    public CompositeGeneratorNode trace(ILocationData data, boolean useForDebugging) {
        TraceNode result = new TraceNode(data);
        result.setUseForDebugging(useForDebugging);
        return result;
    }

    public CompositeGeneratorNode trace(CompositeGeneratorNode parent, ILocationData data) {
        TraceNode result = new TraceNode(data);
        List<IGeneratorNode> _children = parent.getChildren();
        _children.add(result);
        return result;
    }

    public CompositeGeneratorNode trace(CompositeGeneratorNode parent, ILocationData data, boolean useForDebugging) {
        TraceNode result = new TraceNode(data);
        result.setUseForDebugging(useForDebugging);
        List<IGeneratorNode> _children = parent.getChildren();
        _children.add(result);
        return result;
    }

    public CompositeGeneratorNode indent(CompositeGeneratorNode parent) {
        return this.indent(parent, this.wsConfig.getIndentationString());
    }

    public CompositeGeneratorNode indent(CompositeGeneratorNode parent, String indentString) {
        IndentNode indent = new IndentNode(indentString);
        List<IGeneratorNode> _children = parent.getChildren();
        _children.add(indent);
        return indent;
    }

    public CompositeGeneratorNode appendNewLine(CompositeGeneratorNode parent) {
        List<IGeneratorNode> _children = parent.getChildren();
        String _lineDelimiter = this.wsConfig.getLineDelimiter();
        NewLineNode _newLineNode = new NewLineNode(_lineDelimiter, false);
        _children.add(_newLineNode);
        return parent;
    }

    public CompositeGeneratorNode appendNewLine(CompositeGeneratorNode parent, String lineSeparator) {
        List<IGeneratorNode> _children = parent.getChildren();
        NewLineNode _newLineNode = new NewLineNode(lineSeparator, false);
        _children.add(_newLineNode);
        return parent;
    }

    public CompositeGeneratorNode appendNewLineIfNotEmpty(CompositeGeneratorNode parent) {
        List<IGeneratorNode> _children = parent.getChildren();
        String _lineDelimiter = this.wsConfig.getLineDelimiter();
        NewLineNode _newLineNode = new NewLineNode(_lineDelimiter, true);
        _children.add(_newLineNode);
        return parent;
    }

    public CompositeGeneratorNode append(CompositeGeneratorNode parent, Object object) {
        if (object instanceof StringConcatenationClient) {
            this.appendTemplate(parent, (StringConcatenationClient)object);
        } else if (object instanceof IGeneratorNode) {
            List<IGeneratorNode> _children = parent.getChildren();
            _children.add((IGeneratorNode)object);
        } else if (object != null) {
            List<IGeneratorNode> _children_1 = parent.getChildren();
            String _string = object.toString();
            TextNode _textNode = new TextNode(_string);
            _children_1.add(_textNode);
        }
        return parent;
    }

    public CompositeGeneratorNode appendTemplate(CompositeGeneratorNode parent, StringConcatenationClient templateString) {
        TemplateNode proc = new TemplateNode(templateString, this);
        List<IGeneratorNode> _children = parent.getChildren();
        _children.add(proc);
        return parent;
    }
}

