/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.fx.code.editor.services.ContextInformation;
import org.eclipse.fx.code.editor.services.EditingContext;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.text.TextEditAction;
import org.eclipse.jface.text.IRegion;

public class DelegatingEditingContext
implements EditingContext {
    private EditingContext delegate;
    private List<Consumer<Integer>> todoCaretListeners = new ArrayList<Consumer<Integer>>();
    private Map<Consumer<Integer>, DelegateSubscription> todoCaretSubscriptions = new HashMap<Consumer<Integer>, DelegateSubscription>();
    private List<Consumer<IRegion>> todoSelectionListeners = new ArrayList<Consumer<IRegion>>();
    private Map<Consumer<IRegion>, DelegateSubscription> todoSelectionSubscriptions = new HashMap<Consumer<IRegion>, DelegateSubscription>();

    public void dispose() {
        Subscription s;
        this.delegate = null;
        for (Consumer<Integer> consumer : this.todoCaretListeners) {
            s = this.todoCaretSubscriptions.remove(consumer);
            if (s == null) continue;
            s.dispose();
        }
        for (Consumer<Integer> consumer : this.todoSelectionListeners) {
            s = this.todoSelectionSubscriptions.remove(consumer);
            if (s == null) continue;
            s.dispose();
        }
    }

    public void setDelegate(EditingContext delegate) {
        this.delegate = delegate;
        if (this.delegate != null) {
            Subscription s;
            for (Consumer<Integer> consumer : this.todoCaretListeners) {
                s = this.delegate.registerOnCaretOffsetChanged(consumer);
                this.todoCaretSubscriptions.get(consumer).setDelegate(() -> s.dispose());
            }
            for (Consumer<Integer> consumer : this.todoSelectionListeners) {
                s = this.delegate.registerOnSelectionChanged(consumer);
                this.todoSelectionSubscriptions.get(consumer).setDelegate(() -> s.dispose());
            }
        }
    }

    @Override
    public int getCaretOffset() {
        return this.delegate.getCaretOffset();
    }

    @Override
    public void setCaretOffset(int offset) {
        this.delegate.setCaretOffset(offset);
    }

    @Override
    public void setCaretOffset(int offset, boolean keepSelection) {
        this.delegate.setCaretOffset(offset, keepSelection);
    }

    @Override
    public void revealCaret() {
        this.delegate.revealCaret();
    }

    @Override
    public IRegion getSelection() {
        return this.delegate.getSelection();
    }

    @Override
    public void setSelection(IRegion selection) {
        this.delegate.setSelection(selection);
    }

    @Override
    public void showContextInformation(ContextInformation info) {
        this.delegate.showContextInformation(info);
    }

    @Override
    public void triggerAction(TextEditAction action) {
        this.delegate.triggerAction(action);
    }

    @Override
    public Subscription registerOnCaretOffsetChanged(Consumer<Integer> listener) {
        if (this.delegate == null) {
            this.todoCaretListeners.add(listener);
            DelegateSubscription s = new DelegateSubscription();
            this.todoCaretSubscriptions.put(listener, s);
            return s;
        }
        return this.delegate.registerOnCaretOffsetChanged(listener);
    }

    @Override
    public Subscription registerOnSelectionChanged(Consumer<IRegion> listener) {
        if (this.delegate == null) {
            this.todoSelectionListeners.add(listener);
            DelegateSubscription s = new DelegateSubscription();
            this.todoSelectionSubscriptions.put(listener, s);
            return s;
        }
        return this.delegate.registerOnSelectionChanged(listener);
    }

    private class DelegateSubscription
    implements Subscription {
        private Runnable delegate;

        private DelegateSubscription() {
        }

        public void setDelegate(Runnable delegate) {
            this.delegate = delegate;
        }

        public void dispose() {
            if (this.delegate != null) {
                this.delegate.run();
            }
        }
    }
}

