/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.event;

import com.google.common.eventbus.Subscribe;
import java.util.function.Consumer;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.event.Event;
import org.eclipse.fx.core.event.EventBus;
import org.eclipse.jdt.annotation.Nullable;

public class SimpleEventBus
implements EventBus {
    private com.google.common.eventbus.EventBus bus = new com.google.common.eventbus.EventBus();

    @Override
    public <T> void publish(Event<T> event, boolean synchronous) {
        this.bus.post(event);
    }

    @Override
    public void publish(String topic, Object data, boolean synchronous) {
        this.bus.post(new Event<Object>(topic, data));
    }

    @Override
    public <T> Subscription subscribe(String topic, Consumer<Event<T>> consumer) {
        SubscribeWrapper wrapper = new SubscribeWrapper(topic, consumer);
        this.bus.register(wrapper);
        return () -> this.bus.unregister((Object)wrapper);
    }

    static class SubscribeWrapper<@Nullable T> {
        private final String topic;
        private final boolean allSubTopics;
        private Consumer<Event<T>> consumer;

        public SubscribeWrapper(String topic, Consumer<Event<T>> consumer) {
            String t = topic;
            if (t.endsWith("*")) {
                t = t.substring(0, topic.length() - 1);
                this.allSubTopics = true;
            } else {
                this.allSubTopics = false;
            }
            this.topic = t;
            this.consumer = consumer;
        }

        @Subscribe
        public void record(Event<T> event) {
            if (event.getTopic().equals(this.topic) || this.allSubTopics && event.getTopic().startsWith(this.topic)) {
                this.consumer.accept(event);
            }
        }
    }
}

