/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.IFilePostProcessor;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

public class URIBasedFileSystemAccess
extends AbstractFileSystemAccess2 {
    @Accessors
    private URIConverter converter;
    @Accessors
    private URI baseDir;
    @Accessors
    private boolean generateTraces = false;
    @Accessors
    private IEncodingProvider encodingProvider = new IEncodingProvider.Runtime();
    @Accessors
    private TraceRegionSerializer traceRegionSerializer;
    @Accessors
    private TraceFileNameProvider traceFileNameProvider;
    @Accessors
    private BeforeDelete beforeDelete = it -> true;
    @Accessors
    private BeforeWrite beforeWrite = ($0, $1, $2) -> $2;
    @Accessors
    private BeforeRead beforeRead = ($0, $1) -> $1;

    @Override
    public void setPostProcessor(IFilePostProcessor filePostProcessor) {
        super.setPostProcessor(filePostProcessor);
    }

    @Override
    public URI getURI(String path, String outputConfiguration) {
        String outlet = this.getPathes().get(outputConfiguration);
        if (outlet == null) {
            throw new IllegalArgumentException("A slot with name '" + outputConfiguration + "' has not been configured.");
        }
        URI uri = URI.createFileURI((String)(outlet + File.separator + path));
        if (this.baseDir != null) {
            URI resolved = uri.resolve(this.baseDir);
            return resolved;
        }
        return uri;
    }

    public String getEncoding(URI uri) {
        return this.encodingProvider.getEncoding(uri);
    }

    @Override
    public void generateFile(String fileName, String outputCfgName, CharSequence contents) {
        try {
            URI uri = this.getURI(fileName, outputCfgName);
            if (!this.getOutputConfig(outputCfgName).isOverrideExistingResources() && this.converter.exists(uri, CollectionLiterals.emptyMap())) {
                return;
            }
            String encoding = this.getEncoding(uri);
            CharSequence postProcessed = this.postProcess(fileName, outputCfgName, contents, encoding);
            this.generateTrace(fileName, outputCfgName, postProcessed);
            byte[] _bytes = postProcessed.toString().getBytes(encoding);
            ByteArrayInputStream inStream = new ByteArrayInputStream(_bytes);
            this.generateFile(fileName, outputCfgName, inStream);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void generateTrace(String generatedFile, String outputConfigName, CharSequence contents) {
        try {
            if (this.isGenerateTraces() && contents instanceof ITraceRegionProvider) {
                String traceFileName = this.traceFileNameProvider.getTraceFromJava(generatedFile);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                AbstractTraceRegion traceRegion = ((ITraceRegionProvider)((Object)contents)).getTraceRegion();
                this.traceRegionSerializer.writeTraceRegionTo(traceRegion, out);
                byte[] _byteArray = out.toByteArray();
                ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_byteArray);
                this.generateFile(traceFileName, outputConfigName, _byteArrayInputStream);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateFile(String fileName, String outputCfgName, InputStream content) throws RuntimeIOException {
        try {
            URI uri = this.getURI(fileName, outputCfgName);
            try (OutputStream out = this.converter.createOutputStream(uri);){
                InputStream processedContent = this.beforeWrite.beforeWrite(uri, outputCfgName, content);
                ByteStreams.copy((InputStream)processedContent, (OutputStream)out);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public InputStream readBinaryFile(String fileName, String outputCfgName) throws RuntimeIOException {
        try {
            URI uri = this.getURI(fileName, outputCfgName);
            InputStream input = this.converter.createInputStream(uri);
            return this.beforeRead.beforeRead(uri, input);
        }
        catch (Throwable _t) {
            try {
                if (_t instanceof FileNotFoundException) {
                    FileNotFoundException e = (FileNotFoundException)_t;
                    throw new RuntimeIOException((Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    @Override
    public CharSequence readTextFile(String fileName, String outputCfgName) throws RuntimeIOException {
        try {
            URI uri = this.getURI(fileName, outputCfgName);
            InputStream inputstream = this.readBinaryFile(fileName, outputCfgName);
            String _encoding = this.getEncoding(uri);
            InputStreamReader _inputStreamReader = new InputStreamReader(inputstream, _encoding);
            return CharStreams.toString((Readable)_inputStreamReader);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Pure
    public URIConverter getConverter() {
        return this.converter;
    }

    public void setConverter(URIConverter converter) {
        this.converter = converter;
    }

    @Pure
    public URI getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(URI baseDir) {
        this.baseDir = baseDir;
    }

    @Pure
    public boolean isGenerateTraces() {
        return this.generateTraces;
    }

    public void setGenerateTraces(boolean generateTraces) {
        this.generateTraces = generateTraces;
    }

    @Pure
    public IEncodingProvider getEncodingProvider() {
        return this.encodingProvider;
    }

    public void setEncodingProvider(IEncodingProvider encodingProvider) {
        this.encodingProvider = encodingProvider;
    }

    @Pure
    public TraceRegionSerializer getTraceRegionSerializer() {
        return this.traceRegionSerializer;
    }

    public void setTraceRegionSerializer(TraceRegionSerializer traceRegionSerializer) {
        this.traceRegionSerializer = traceRegionSerializer;
    }

    @Pure
    public TraceFileNameProvider getTraceFileNameProvider() {
        return this.traceFileNameProvider;
    }

    public void setTraceFileNameProvider(TraceFileNameProvider traceFileNameProvider) {
        this.traceFileNameProvider = traceFileNameProvider;
    }

    @Pure
    public BeforeDelete getBeforeDelete() {
        return this.beforeDelete;
    }

    public void setBeforeDelete(BeforeDelete beforeDelete) {
        this.beforeDelete = beforeDelete;
    }

    @Pure
    public BeforeWrite getBeforeWrite() {
        return this.beforeWrite;
    }

    public void setBeforeWrite(BeforeWrite beforeWrite) {
        this.beforeWrite = beforeWrite;
    }

    @Pure
    public BeforeRead getBeforeRead() {
        return this.beforeRead;
    }

    public void setBeforeRead(BeforeRead beforeRead) {
        this.beforeRead = beforeRead;
    }

    public static interface BeforeRead {
        public InputStream beforeRead(URI var1, InputStream var2);
    }

    public static interface BeforeWrite {
        public InputStream beforeWrite(URI var1, String var2, InputStream var3);
    }

    public static interface BeforeDelete {
        public boolean beforeDelete(URI var1);
    }
}

