/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public class JavaClasspathVariablesInitializer
extends ClasspathVariableInitializer {
    private IProgressMonitor fMonitor;

    public void initialize(String variable) {
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        if (vmInstall != null) {
            IPath newPath = null;
            LibraryLocation[] locations = JavaRuntime.getLibraryLocations(vmInstall);
            LibraryLocation rtjar = null;
            LibraryLocation classeszip = null;
            int i = 0;
            while (i < locations.length) {
                LibraryLocation location = locations[i];
                String name = location.getSystemLibraryPath().lastSegment();
                if (name.equalsIgnoreCase("rt.jar")) {
                    rtjar = location;
                } else if (name.equalsIgnoreCase("classes.zip")) {
                    classeszip = location;
                }
                ++i;
            }
            LibraryLocation systemLib = rtjar;
            if (systemLib == null) {
                systemLib = classeszip;
            }
            if (systemLib == null && locations.length > 0) {
                systemLib = locations[0];
            }
            if (systemLib != null) {
                if (variable.equals("JRE_LIB")) {
                    newPath = systemLib.getSystemLibraryPath();
                } else if (variable.equals("JRE_SRC")) {
                    newPath = systemLib.getSystemLibrarySourcePath();
                } else if (variable.equals("JRE_SRCROOT")) {
                    newPath = systemLib.getPackageRootPath();
                }
                if (newPath == null) {
                    return;
                }
                try {
                    this.setJREVariable(newPath, variable);
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
            }
        }
    }

    private void setJREVariable(IPath newPath, String var) throws CoreException {
        JavaCore.setClasspathVariable((String)var, (IPath)newPath, (IProgressMonitor)this.getMonitor());
    }

    protected IProgressMonitor getMonitor() {
        if (this.fMonitor == null) {
            return new NullProgressMonitor();
        }
        return this.fMonitor;
    }
}

