/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.TerminalRule;

@Singleton
public class RuleNames {
    private final Grammar contextGrammar;
    private final ListMultimap<String, AbstractRule> simpleNameToRules;
    private final Map<String, AbstractRule> qualifiedNameToRule;
    private final BiMap<String, AbstractRule> nameToRule;
    private final BiMap<String, AbstractRule> uniqueNameToRule;
    private final BiMap<String, AbstractRule> antlrNameToRule;
    private final List<AbstractRule> allRules;

    public static RuleNames getRuleNames(Grammar grammar, boolean cache) {
        if (cache) {
            Adapter adapter = (Adapter)EcoreUtil.getAdapter((List)grammar.eAdapters(), RuleNames.class);
            if (adapter == null) {
                return new RuleNames(grammar, true);
            }
            return adapter.getRuleNames();
        }
        return new RuleNames(grammar, false);
    }

    public static RuleNames getRuleNames(AbstractRule rule) {
        Adapter adapter = (Adapter)EcoreUtil.getAdapter((List)rule.eAdapters(), RuleNames.class);
        if (adapter == null) {
            throw new IllegalStateException("Cannot find adapter");
        }
        return adapter.getRuleNames();
    }

    public static RuleNames tryGetRuleNames(AbstractRule rule) {
        Adapter adapter = (Adapter)EcoreUtil.getAdapter((List)rule.eAdapters(), RuleNames.class);
        if (adapter == null) {
            return null;
        }
        return adapter.getRuleNames();
    }

    public static void ensureAdapterInstalled(Grammar grammar) {
        RuleNames.getRuleNames(grammar, true);
    }

    @Inject
    public RuleNames(IGrammarAccess grammarAccess) {
        this(grammarAccess.getGrammar(), false);
    }

    public RuleNames(Grammar grammar, boolean installAdapter) {
        this.contextGrammar = grammar;
        Adapter adapter = new Adapter(this);
        if (installAdapter) {
            this.installAdapterIfMissing(adapter, grammar);
        }
        List<AbstractRule> allRules = GrammarUtil.allRules(grammar);
        ImmutableListMultimap.Builder simpleNameToRulesBuilder = ImmutableListMultimap.builder();
        ImmutableMap.Builder qualifiedNameToRuleBuilder = ImmutableMap.builder();
        ImmutableBiMap.Builder uniqueNameToRuleBuilder = ImmutableBiMap.builder();
        ImmutableBiMap.Builder antlrNameToRuleBuilder = ImmutableBiMap.builder();
        HashMap names = Maps.newHashMap();
        HashSet usedAntlrNames = Sets.newHashSet();
        HashSet usedUniqueNames = Sets.newHashSet();
        for (AbstractRule rule : allRules) {
            String antlrRuleName;
            String name = rule.getName();
            simpleNameToRulesBuilder.put((Object)name, (Object)rule);
            String qualifiedName = this.getQualifiedName(rule);
            qualifiedNameToRuleBuilder.put((Object)qualifiedName, (Object)rule);
            String uniqueName = name;
            if (names.containsKey(name)) {
                name = qualifiedName;
                uniqueName = this.getInheritedUniqueName(rule, usedUniqueNames);
                antlrRuleName = this.getInheritedAntlrRuleName(rule, usedAntlrNames);
            } else {
                antlrRuleName = this.getDefaultAntlrRuleName(rule);
            }
            names.put(name, rule);
            if (!usedUniqueNames.add(uniqueName)) {
                throw new IllegalStateException(uniqueName);
            }
            uniqueNameToRuleBuilder.put((Object)uniqueName, (Object)rule);
            if (!usedAntlrNames.add(antlrRuleName)) {
                throw new IllegalStateException(antlrRuleName);
            }
            antlrNameToRuleBuilder.put((Object)antlrRuleName, (Object)rule);
            if (!installAdapter) continue;
            this.installAdapterIfMissing(adapter, rule);
        }
        this.simpleNameToRules = simpleNameToRulesBuilder.build();
        this.qualifiedNameToRule = qualifiedNameToRuleBuilder.build();
        this.nameToRule = ImmutableBiMap.copyOf((Map)names);
        this.uniqueNameToRule = uniqueNameToRuleBuilder.build();
        this.antlrNameToRule = antlrNameToRuleBuilder.build();
        this.allRules = ImmutableList.copyOf(allRules);
    }

    private void installAdapterIfMissing(Adapter adapter, EObject context) {
        if (EcoreUtil.getAdapter((List)context.eAdapters(), RuleNames.class) != null) {
            throw new IllegalStateException("Duplicate adapter");
        }
        context.eAdapters().add((Object)adapter);
    }

    public List<AbstractRule> getRulesBySimpleName(String name) {
        return this.simpleNameToRules.get((Object)name);
    }

    public AbstractRule getRuleByQualifiedName(String name) {
        return this.qualifiedNameToRule.get(name);
    }

    public String getQualifiedName(AbstractRule rule) {
        return GrammarUtil.getGrammar(rule).getName() + "." + rule.getName();
    }

    public String getUniqueRuleName(AbstractRule rule) {
        return (String)this.uniqueNameToRule.inverse().get((Object)rule);
    }

    public AbstractRule getRuleByUniqueName(String uniqueName) {
        return (AbstractRule)this.uniqueNameToRule.get((Object)uniqueName);
    }

    public String getAntlrRuleName(AbstractRule rule) {
        return (String)this.antlrNameToRule.inverse().get((Object)rule);
    }

    public String getAntlrRuleName(AbstractRule rule, int paramConfig) {
        int idx;
        String result = (String)this.antlrNameToRule.inverse().get((Object)rule);
        if (result.startsWith("super")) {
            idx = 5;
        } else if (result.startsWith("rule")) {
            idx = 4;
        } else {
            throw new IllegalArgumentException(result);
        }
        if (paramConfig != 0) {
            result = (idx == 4 ? "norm" : "normSuper") + paramConfig + "_" + result.substring(idx);
        }
        return result;
    }

    public AbstractRule getRuleByAntlrName(String name) {
        return (AbstractRule)this.antlrNameToRule.get((Object)name);
    }

    public String getBestRuleName(AbstractRule rule) {
        return (String)this.nameToRule.inverse().get((Object)rule);
    }

    public Grammar getContextGrammar() {
        return this.contextGrammar;
    }

    public List<AbstractRule> getAllRules() {
        return this.allRules;
    }

    public Iterable<ParserRule> getAllParserRules() {
        return Iterables.filter(this.allRules, ParserRule.class);
    }

    private String getInheritedAntlrRuleName(AbstractRule rule, Set<String> usedNames) {
        if (rule instanceof ParserRule || rule instanceof EnumRule) {
            String candidate = "super" + rule.getName();
            int i = 1;
            while (usedNames.contains(candidate)) {
                candidate = "super" + i + rule.getName();
                ++i;
            }
            return candidate;
        }
        if (rule instanceof TerminalRule) {
            String candidate = "SUPER_" + rule.getName();
            int i = 1;
            while (usedNames.contains(candidate)) {
                candidate = "SUPER_" + i + "_" + rule.getName();
                ++i;
            }
            return candidate;
        }
        throw new IllegalArgumentException(rule.eClass().getName());
    }

    private String getInheritedUniqueName(AbstractRule rule, Set<String> usedNames) {
        String grammarName = GrammarUtil.getSimpleName(GrammarUtil.getGrammar(rule));
        String candidate = grammarName + rule.getName();
        int i = 1;
        while (usedNames.contains(candidate)) {
            candidate = grammarName + i + rule.getName();
            ++i;
        }
        return candidate;
    }

    private String getDefaultAntlrRuleName(AbstractRule rule) {
        if (rule instanceof ParserRule || rule instanceof EnumRule) {
            return "rule" + rule.getName();
        }
        if (rule instanceof TerminalRule) {
            return "RULE_" + rule.getName().toUpperCase();
        }
        throw new IllegalArgumentException(rule.eClass().getName());
    }

    static class Adapter
    extends AdapterImpl {
        private RuleNames ruleNames;

        Adapter(RuleNames ruleNames) {
            this.ruleNames = ruleNames;
        }

        public boolean isAdapterForType(Object type) {
            return RuleNames.class.equals(type);
        }

        public RuleNames getRuleNames() {
            return this.ruleNames;
        }
    }
}

