/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.internal.reader;

import org.eclipse.core.resources.IFile;
import org.eclipse.egf.core.extensionpoint.IContractConstants;
import org.eclipse.egf.core.reader.descriptor.AbstractDescriptor;
import org.eclipse.egf.core.reader.descriptor.ContractDescriptor;
import org.eclipse.egf.core.reader.descriptor.ContractElementDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IContractElementDescriptor;
import org.eclipse.egf.pde.reader.CreateDescriptorOperation;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;

public class CreateContractDescriptorOperation
extends CreateDescriptorOperation {
    public CreateContractDescriptorOperation(IFile modelFile_p, String readExtensionId_p) {
        super(modelFile_p, readExtensionId_p);
    }

    protected AbstractDescriptor createDescriptor(IPluginModelBase model_p) {
        String contractId;
        ContractDescriptor descriptor = null;
        IPluginElement pluginElement = this.getExtensionWithId(model_p, IContractConstants.FULLY_QUALIFIED_EXTENSION_POINT_ID, this.getReadExtensionId());
        if (pluginElement != null && (contractId = this.getPluginAttributeValue(pluginElement, "id")) != null) {
            IPluginElement[] children;
            descriptor = new ContractDescriptor();
            descriptor.setId(contractId);
            IPluginElement[] iPluginElementArray = children = this.getChildren(pluginElement, "contractElement");
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginElement child = iPluginElementArray[n2];
                ContractElementDescriptor contractElementDescriptor = this.readContractElementDescriptor(child);
                if (contractElementDescriptor != null) {
                    descriptor.addContractElementDescriptor((IContractElementDescriptor)contractElementDescriptor);
                }
                ++n2;
            }
        }
        return descriptor;
    }

    private ContractElementDescriptor readContractElementDescriptor(IPluginElement child_p) {
        IPluginElement[] contractElementReferences;
        ContractElementDescriptor descriptor = new ContractElementDescriptor();
        String contractElementId = this.getPluginAttributeValue(child_p, "id");
        descriptor.setId(contractElementId);
        String contractElementName = this.getPluginAttributeValue(child_p, "name");
        descriptor.setContractElementName(contractElementName);
        String typeClass = this.getPluginAttributeValue(child_p, "type");
        descriptor.setTypeHolderClassName(typeClass);
        String mandatory = this.getPluginAttributeValue(child_p, "mandatory");
        boolean isMandatory = mandatory != null ? Boolean.parseBoolean(mandatory) : true;
        descriptor.setMandatory(isMandatory);
        String description = this.readDescription(child_p);
        if (description == null) {
            String childText = child_p.getText();
            description = "".equals(childText) ? null : childText;
        }
        descriptor.setDescription(description);
        IPluginElement[] iPluginElementArray = contractElementReferences = this.getChildren(child_p, "contractElementRef");
        int n = contractElementReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginElement contractElementRef = iPluginElementArray[n2];
            String contractReferenceId = this.getPluginAttributeValue(contractElementRef, "contractElementReferenceId");
            if (contractReferenceId != null) {
                descriptor.addContractReferenceId(contractReferenceId);
            }
            ++n2;
        }
        return descriptor;
    }
}

