/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.core.helper.EclipseBuilderHelper;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.internal.FactoryComponentGeneratorHelper;
import org.eclipse.egf.pde.internal.ui.IHelpContextIds;
import org.eclipse.egf.pde.internal.ui.wizard.page.FactoryComponentContentPage;
import org.eclipse.egf.pde.internal.ui.wizard.page.FactoryComponentTemplateListSelectionPage;
import org.eclipse.egf.pde.ui.wizard.Messages;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.build.IBuildModelFactory;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.elements.IPDEElement;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class NewFactoryComponentProjectWizard
extends NewWizard {
    public static final String IMG_WIZARD_FACTORY_COMPONENT = "wizban/fc.gif";
    public static final String FACTORY_COMPONENT_CONTENT_EXTENSION_POINT_ID = "factoryComponentContent";
    public static final String TAG_WIZARD = "wizard";
    private static final String DEFAULT_FACTORY_COMPONENT_TEMPLATE_ID = "org.eclipse.egf.pde.emptyFactoryComponent";
    private static final Logger __logger = Logger.getLogger((String)NewFactoryComponentProjectWizard.class.getPackage().getName());
    private PluginFieldData _pluginData;
    protected NewProjectCreationPage _mainPage;
    protected FactoryComponentContentPage _pluginContentPage;
    protected FactoryComponentTemplateListSelectionPage _wizardListPage;
    private IProjectProvider _projectProvider;
    private ElementList _availableContributedTemplateBasedWizards;

    public NewFactoryComponentProjectWizard() {
        this.setDefaultPageImageDescriptor(EgfPdeActivator.getDefault().getImageDescriptor(IMG_WIZARD_FACTORY_COMPONENT));
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(Messages.NewFactoryComponentProjectWizard_Title);
        this.setNeedsProgressMonitor(true);
        this._pluginData = new PluginFieldData();
    }

    public void addPages() {
        this.createMainPage();
        this.createPluginContentPage();
        this.createTemplatePage();
    }

    protected void createTemplatePage() {
        this._availableContributedTemplateBasedWizards = this.getAvailableCodegenWizards();
        this._wizardListPage = new FactoryComponentTemplateListSelectionPage(this._availableContributedTemplateBasedWizards, this._pluginContentPage, PDEUIMessages.WizardListSelectionPage_templates);
        this._wizardListPage.setInitialTemplateId(DEFAULT_FACTORY_COMPONENT_TEMPLATE_ID);
        this.addPage((IWizardPage)this._wizardListPage);
    }

    private ElementList getAvailableCodegenWizards() {
        ElementList wizards = new ElementList("AssetCodegenWizards");
        IConfigurationElement[] elements = ExtensionPointHelper.getConfigurationElements((String)EgfPdeActivator.getDefault().getPluginID(), (String)FACTORY_COMPONENT_CONTENT_EXTENSION_POINT_ID);
        int j = 0;
        while (j < elements.length) {
            WizardElement element;
            if (elements[j].getName().equals(TAG_WIZARD) && (element = this.createWizardElement(elements[j])) != null) {
                wizards.add((IPDEElement)element);
            }
            ++j;
        }
        return wizards;
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String name = config.getAttribute("name");
        String id = config.getAttribute("id");
        String className = config.getAttribute("class");
        if (name == null || id == null || className == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute("icon");
        if (imageName != null) {
            String pluginID = config.getNamespaceIdentifier();
            Image image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pluginID, imageName);
            element.setImage(image);
        }
        return element;
    }

    protected void createPluginContentPage() {
        this._pluginContentPage = new FactoryComponentContentPage("FactoryComponentContentPage", this._projectProvider, this._mainPage, (AbstractFieldData)this._pluginData);
        this.addPage((IWizardPage)this._pluginContentPage);
    }

    protected void createMainPage() {
        this._mainPage = new NewProjectCreationPage("NewProjectCreationPage", (AbstractFieldData)this._pluginData, false, this.getSelection()){

            public void createControl(Composite parent_p) {
                super.createControl(parent_p);
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IHelpContextIds.NEW_FACTORY_COMPONENT_PROJECT_STRUCTURE_WIZARD_PAGE);
            }
        };
        this._mainPage.setTitle(Messages.NewFactoryComponentProjectWizardMainPage_Title);
        this._mainPage.setDescription(Messages.NewFactoryComponentProjectWizardMainPage_Description);
        this.addPage((IWizardPage)this._mainPage);
        this._projectProvider = new IProjectProvider(){

            public String getProjectName() {
                return NewFactoryComponentProjectWizard.this._mainPage.getProjectName();
            }

            public IProject getProject() {
                return NewFactoryComponentProjectWizard.this._mainPage.getProjectHandle();
            }

            public IPath getLocationPath() {
                return NewFactoryComponentProjectWizard.this._mainPage.getLocationPath();
            }
        };
    }

    public boolean canFinish() {
        return super.canFinish() && this.getContainer().getCurrentPage() != this._mainPage;
    }

    public boolean performFinish() {
        boolean result = false;
        try {
            this._mainPage.updateData();
            this._pluginContentPage.updateData();
            IPluginContentWizard contentWizard = this._wizardListPage.getSelectedWizard();
            if (contentWizard == null) {
                WizardElement defaultWizardElement = NewFactoryComponentProjectWizard.getWizardElement(this._availableContributedTemplateBasedWizards, DEFAULT_FACTORY_COMPONENT_TEMPLATE_ID);
                contentWizard = (IPluginContentWizard)defaultWizardElement.createExecutableExtension();
                contentWizard.init(this._pluginContentPage.getData());
            }
            this.getContainer().run(false, false, (IRunnableWithProgress)new NewProjectCreationOperation((IFieldData)this._pluginData, this._projectProvider, contentWizard){

                protected void createSourceOutputBuildEntries(WorkspaceBuildModel model_p, IBuildModelFactory factory_p) throws CoreException {
                    super.createSourceOutputBuildEntries(model_p, factory_p);
                    String libraryName = NewFactoryComponentProjectWizard.this._pluginData.getLibraryName();
                    if (libraryName == null) {
                        libraryName = String.valueOf('.');
                    }
                    FactoryComponentGeneratorHelper.addGeneratedSourceFolderInLibrarySources((IBuildModel)model_p, libraryName);
                }

                protected void createContents(IProgressMonitor monitor_p, IProject project_p) throws CoreException, JavaModelException, InvocationTargetException, InterruptedException {
                    super.createContents(monitor_p, project_p);
                    if (!project_p.hasNature("org.eclipse.egf.core.FactoryComponentNature")) {
                        EclipseBuilderHelper.addNatureToProject((IProject)project_p, (String)"org.eclipse.egf.core.FactoryComponentNature", null);
                    }
                }
            });
            result = true;
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("NewFactoryComponentProjectWizard.performFinish(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return result;
    }

    public static WizardElement getWizardElement(ElementList elementList_p, String wizardElementId_p) {
        WizardElement result = null;
        Object[] children = elementList_p.getChildren();
        int i = 0;
        while (i < children.length && result == null) {
            WizardElement currentWizardElement = (WizardElement)children[i];
            if (currentWizardElement.getID().equals(wizardElementId_p)) {
                result = currentWizardElement;
            }
            ++i;
        }
        return result;
    }

    public void init(IWorkbench workbench_p, IStructuredSelection selection_p) {
    }
}

