/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.util;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IExtensionsModelFactory;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;

public class ExtensionHelper {
    private static final Logger __logger = Logger.getLogger((String)ExtensionHelper.class.getPackage().getName());

    public static IPluginExtension createExtension(String extensionPointId_p, IPluginModelBase pluginModelBase_p) {
        IPluginExtension extension = null;
        IPluginModelFactory pluginModelFactory = pluginModelBase_p.getPluginFactory();
        if (pluginModelFactory != null) {
            extension = pluginModelFactory.createExtension();
            try {
                extension.setPoint(extensionPointId_p);
                pluginModelBase_p.getExtensions().add(extension);
            }
            catch (CoreException exception_p) {
                StringBuffer loggerMessage = new StringBuffer("ExtensionHelper.createExtension(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                extension = null;
            }
        }
        return extension;
    }

    public static IPluginElement createPluginElement(IPluginParent parent_p, String name_p) {
        IPluginElement element = null;
        IExtensionsModelFactory factory = parent_p.getModel().getFactory();
        if (factory != null) {
            element = factory.createElement((IPluginObject)parent_p);
            try {
                element.setName(name_p);
                parent_p.add((IPluginObject)element);
            }
            catch (CoreException exception_p) {
                StringBuffer loggerMessage = new StringBuffer("ExtensionHelper.createPluginElement(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                element = null;
            }
        }
        return element;
    }

    public static IPluginExtension[] getPluginExtension(IExtensions extensionPart_p, String fullyQualifiedExtensionPointId_p) {
        ArrayList<IPluginExtension> result = new ArrayList<IPluginExtension>(0);
        if (fullyQualifiedExtensionPointId_p == null || extensionPart_p == null) {
            return result.toArray(new IPluginExtension[0]);
        }
        IPluginExtension[] extensions = extensionPart_p.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IPluginExtension currentExtension = extensions[i];
            if (fullyQualifiedExtensionPointId_p.equals(currentExtension.getPoint())) {
                result.add(currentExtension);
            }
            ++i;
        }
        return result.toArray(new IPluginExtension[result.size()]);
    }

    public static boolean removePluginExtension(IExtensions extensionPart_p, String extensionPointId_p, String elementId_p, String elementIdValue_p) {
        IPluginExtension[] matchingExtensions;
        boolean result = false;
        IPluginExtension[] iPluginExtensionArray = matchingExtensions = ExtensionHelper.getPluginExtension(extensionPart_p, extensionPointId_p);
        int n = matchingExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension currentExtension = iPluginExtensionArray[n2];
            result = ExtensionHelper.removePluginElement((IPluginParent)currentExtension, elementId_p, elementIdValue_p);
            if (result) {
                int childCount = currentExtension.getChildCount();
                try {
                    if (childCount != 0) break;
                    extensionPart_p.remove(currentExtension);
                }
                catch (CoreException exception_p) {
                    StringBuffer loggerMessage = new StringBuffer("ExtensionHelper.removePluginExtension(..) _ ");
                    __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                }
                break;
            }
            ++n2;
        }
        return result;
    }

    public static IPluginElement getPluginElement(IPluginParent parent_p, String attributeId_p, String attributeIdValue_p) {
        IPluginElement result = null;
        if (attributeIdValue_p == null || attributeIdValue_p.length() == 0 || parent_p == null) {
            return result;
        }
        IPluginObject[] children = parent_p.getChildren();
        int i = 0;
        while (i < children.length && result == null) {
            IPluginObject object = children[i];
            if (object instanceof IPluginElement) {
                IPluginElement child = (IPluginElement)object;
                if (attributeId_p == null) {
                    if (attributeIdValue_p.equals(child.getName())) {
                        result = child;
                    }
                } else {
                    IPluginAttribute attribute = child.getAttribute(attributeId_p);
                    if (attribute != null && attributeIdValue_p.equals(attribute.getValue())) {
                        result = child;
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static IPluginElement[] getPluginElement(IPluginParent parent_p, String nodeName_p) {
        ArrayList<IPluginElement> result = new ArrayList<IPluginElement>(0);
        if (nodeName_p == null || parent_p == null) {
            return result.toArray(new IPluginElement[0]);
        }
        IPluginObject[] children = parent_p.getChildren();
        int i = 0;
        while (i < children.length) {
            IPluginElement element;
            IPluginObject object = children[i];
            if (object instanceof IPluginElement && nodeName_p.equals((element = (IPluginElement)object).getName())) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new IPluginElement[result.size()]);
    }

    public static boolean removePluginElement(IPluginParent parent_p, String elementId_p, String elementIdValue_p) {
        boolean result = false;
        if (elementIdValue_p == null || elementIdValue_p.length() == 0 || parent_p == null) {
            return result;
        }
        IPluginElement pluginElement = ExtensionHelper.getPluginElement(parent_p, elementId_p, elementIdValue_p);
        try {
            if (pluginElement != null) {
                parent_p.remove((IPluginObject)pluginElement);
                result = true;
            }
        }
        catch (CoreException exception_p) {
            StringBuffer loggerMessage = new StringBuffer("ExtensionHelper.removePluginElement(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return result;
    }
}

