/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core;

import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.core.log4j.ILog4jConfigurer;
import org.osgi.framework.Bundle;

public class Log4JConfigurator {
    private static final String EXTENSION_POINT_SHORT_ID_LOG4J_CONFIGURER = "log4jConfigurer";
    private static final String LOG4J_APPENDER_FILE_APPEND = "log4j.appender.FILE.Append";
    private static final String LOG4J_APPENDER_FILE_MAX_BACKUP_INDEX = "log4j.appender.FILE.MaxBackupIndex";
    private static final String LOG4J_APPENDER_FILE_MAX_FILE_SIZE = "log4j.appender.FILE.MaxFileSize";
    private static final String LOG4J_APPENDER_FILE_LAYOUT_CONVERSION_PATTERN = "log4j.appender.FILE.layout.ConversionPattern";
    private static final String LOG4J_APPENDER_FILE_LAYOUT = "log4j.appender.FILE.layout";
    private static final String LOG4J_APPENDER_FILE_FILE = "log4j.appender.FILE.File";
    private static final String LOG4J_APPENDER_FILE = "log4j.appender.FILE";
    public static final String LOG4J_ROOT_LOGGER = "log4j.rootLogger";
    private static final Logger __logger = Logger.getLogger((String)Log4JConfigurator.class.getPackage().getName());

    public static void configure(Bundle bundle_p) throws Exception {
        URL log4jConfigurationURL = bundle_p.getEntry("/log4j.properties");
        URL resolvedURL = FileLocator.resolve((URL)log4jConfigurationURL);
        Properties log4jProperties = new Properties();
        log4jProperties.load(resolvedURL.openStream());
        Log4JConfigurator.addFileAppender(log4jProperties);
        ILog4jConfigurer log4jConfigurer = Log4JConfigurator.handleContributedLog4jConfigurer(log4jProperties);
        Thread currentThread = Thread.currentThread();
        ClassLoader initialContextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(log4jConfigurer.getClass().getClassLoader());
        try {
            PropertyConfigurator.configure((Properties)log4jProperties);
        }
        finally {
            currentThread.setContextClassLoader(initialContextClassLoader);
        }
        if (__logger.isDebugEnabled()) {
            StringBuffer loggerMessage = new StringBuffer("CoreActivator.start(..) _ LOG4J is correctly configured!");
            __logger.debug((Object)loggerMessage.toString());
        }
    }

    private static void addFileAppender(Properties properties_p) {
        properties_p.put(LOG4J_APPENDER_FILE, "org.apache.log4j.RollingFileAppender");
        URL workspaceURL = Platform.getInstanceLocation().getURL();
        String logFilePath = workspaceURL.getPath() + ".metadata/egf.log";
        properties_p.put(LOG4J_APPENDER_FILE_FILE, logFilePath);
        properties_p.put(LOG4J_APPENDER_FILE_LAYOUT, "org.apache.log4j.PatternLayout");
        properties_p.put(LOG4J_APPENDER_FILE_LAYOUT_CONVERSION_PATTERN, "%d %5p [%t] - %m%n");
        properties_p.put(LOG4J_APPENDER_FILE_MAX_FILE_SIZE, "1024KB");
        properties_p.put(LOG4J_APPENDER_FILE_MAX_BACKUP_INDEX, "1");
        properties_p.put(LOG4J_APPENDER_FILE_APPEND, "false");
        StringBuilder rootLogger = new StringBuilder((String)properties_p.get(LOG4J_ROOT_LOGGER));
        rootLogger.append(',').append(' ').append("FILE");
        properties_p.put(LOG4J_ROOT_LOGGER, rootLogger.toString());
    }

    private static ILog4jConfigurer handleContributedLog4jConfigurer(Properties properties_p) {
        Object instantiatedClass;
        ILog4jConfigurer log4jConfigurer = null;
        IConfigurationElement[] configurationElements = ExtensionPointHelper.getConfigurationElements((String)CoreActivator.getDefault().getPluginID(), (String)EXTENSION_POINT_SHORT_ID_LOG4J_CONFIGURER);
        if (configurationElements != null && configurationElements.length > 0 && (instantiatedClass = ExtensionPointHelper.createInstance((IConfigurationElement)configurationElements[0], (String)"class")) instanceof ILog4jConfigurer) {
            log4jConfigurer = (ILog4jConfigurer)instantiatedClass;
            log4jConfigurer.handleConfiguration(properties_p);
        }
        return log4jConfigurer;
    }
}

