/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.runner.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.egf.common.descriptor.GenericDescriptor;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.descriptor.pattern.helper.IPatternDescriptorHandler;
import org.eclipse.egf.common.descriptor.pattern.helper.PatternDescriptorStrategy;
import org.eclipse.egf.core.ui.viewers.PatternStructureLabelProviderWithTooltip;
import org.eclipse.egf.pattern.runner.ui.Messages;
import org.eclipse.egf.pattern.runner.ui.PatternIdContentProvider;
import org.eclipse.egf.pde.pattern.reader.PlatformPatternExtensionReader;
import org.eclipse.egf.pde.pattern.reader.WorkspacePatternExtensionReader;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class PatternSelectionDialog
extends ElementTreeSelectionDialog {
    private Object[] _initialSelection;
    private GenericDescriptor _rootDescriptor;

    public PatternSelectionDialog(Shell parent_p) {
        super(parent_p, (ILabelProvider)new PatternStructureLabelProviderWithTooltip(), (ITreeContentProvider)new PatternIdContentProvider());
        this.setTitle(Messages.PatternSelectionDialog_Title);
        this.setMessage(Messages.PatternSelectionDialog_Message);
        this.setAllowMultiple(false);
    }

    protected TreeViewer createTreeViewer(Composite parent_p) {
        TreeViewer result = super.createTreeViewer(parent_p);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)result);
        return result;
    }

    public int open() {
        this.populateDialogContent();
        return super.open();
    }

    protected void populateDialogContent() {
        this._rootDescriptor = new GenericDescriptor();
        PatternDescriptorStrategy.retainRootOnly((GenericDescriptor)this._rootDescriptor, (IDescriptor)new WorkspacePatternExtensionReader().getPatternLibraries());
        PatternDescriptorStrategy.retainRootOnly((GenericDescriptor)this._rootDescriptor, (IDescriptor)new PlatformPatternExtensionReader().getPatternLibraries());
        this.setInput(this._rootDescriptor);
    }

    public void setInitialSelections(Object[] selectedElements_p) {
        this._initialSelection = selectedElements_p;
    }

    protected List getInitialElementSelections() {
        IDescriptor retrievedPattern;
        List<Object> result = Collections.emptyList();
        if (this._initialSelection != null && this._initialSelection.length > 0 && (retrievedPattern = this.findPattern((String)this._initialSelection[0])) != null) {
            result = Collections.singletonList(retrievedPattern);
        }
        return result;
    }

    protected IDescriptor findPattern(final String fullId_p) {
        final IDescriptor[] initialSelection = new IDescriptor[1];
        new PatternDescriptorStrategy(){

            protected boolean stopSearch(IDescriptor parentDescriptor_p) {
                return initialSelection[0] != null;
            }
        }.iterateThroughPatternExtensionDescriptor(new IPatternDescriptorHandler(){

            public void handleDescriptor(IDescriptor descriptor_p) {
            }

            public void handleLibraryDescriptor(IDescriptor descriptor_p, String parentLibraryId_p) {
                if (fullId_p.equals(parentLibraryId_p)) {
                    initialSelection[0] = descriptor_p;
                }
            }

            public void handlePatternDescriptor(IDescriptor descriptor_p, String patternFullId_p) {
                if (fullId_p.equals(patternFullId_p)) {
                    initialSelection[0] = descriptor_p;
                }
            }
        }, (IDescriptor)this._rootDescriptor);
        return initialSelection[0];
    }
}

