/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.ecore.ui;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.pattern.ecore.AbstractPatternGenerator;
import org.eclipse.egf.pattern.ui.PatternUiActivator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public abstract class AbstractPatternGeneratorHandler
extends AbstractHandler {
    protected static final Logger __logger = Logger.getLogger((String)AbstractPatternGeneratorHandler.class.getPackage().getName());
    protected static final String PATTERN_GENERATOR_EXTENSION_POINT_ID = "patternGenerator";

    public Object execute(ExecutionEvent executionEvent_p) throws ExecutionException {
        EvaluationContext applicationContext = (EvaluationContext)executionEvent_p.getApplicationContext();
        if (applicationContext == null) {
            return null;
        }
        CoreActivator.getDefault();
        Collection defaultVariable = (Collection)applicationContext.getDefaultVariable();
        for (Object currentVariable : defaultVariable) {
            IConfigurationElement[] generators;
            IProject project;
            IPluginModelBase pluginModel;
            if (!(currentVariable instanceof IJavaProject) || (pluginModel = PluginRegistry.findModel((IProject)(project = ((IJavaProject)currentVariable).getProject()))) == null) continue;
            String pluginId = pluginModel.getPluginBase().getId();
            IConfigurationElement root = ExtensionPointHelper.getConfigurationElement((String)PatternUiActivator.getDefault().getPluginID(), (String)PATTERN_GENERATOR_EXTENSION_POINT_ID, (String)pluginId);
            if (root == null) continue;
            IConfigurationElement[] iConfigurationElementArray = generators = root.getChildren();
            int n = generators.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement generator = iConfigurationElementArray[n2];
                AbstractPatternGenerator patternGenerator = (AbstractPatternGenerator)ExtensionPointHelper.createInstance((IConfigurationElement)generator, (String)"class");
                if (patternGenerator != null) {
                    this.doExecute(patternGenerator);
                    try {
                        project.refreshLocal(2, null);
                    }
                    catch (CoreException exception_p) {
                        StringBuilder loggerMessage = new StringBuilder("AbstractPatternGeneratorHandler.execute(..) _ ");
                        loggerMessage.append("Could not refresh project ").append(project.getName());
                        __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                    }
                } else {
                    StringBuilder loggerMessage = new StringBuilder("AbstractPatternGeneratorHandler.execute(..) _ ");
                    loggerMessage.append("no pattern generator declared for ");
                    loggerMessage.append(pluginId);
                    __logger.warn((Object)loggerMessage.toString());
                }
                ++n2;
            }
        }
        return null;
    }

    protected abstract void doExecute(AbstractPatternGenerator var1);
}

