/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.ecore.ui;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.descriptor.pattern.helper.IPatternDescriptorHandler;
import org.eclipse.egf.common.descriptor.pattern.helper.PatternDescriptorStrategy;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.model.ModelFactory;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.pattern.ui.editor.PatternEditor;
import org.eclipse.egf.pattern.ui.editor.PatternEditorInput;
import org.eclipse.egf.pde.pattern.reader.WorkspacePatternExtensionReader;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenPatternEditorHandler
extends AbstractHandler {
    static final Logger __logger = Logger.getLogger((String)OpenPatternEditorHandler.class.getPackage().getName());

    public Object execute(ExecutionEvent executionEvent_p) throws ExecutionException {
        EvaluationContext applicationContext = (EvaluationContext)executionEvent_p.getApplicationContext();
        if (applicationContext == null) {
            return null;
        }
        CoreActivator.getDefault();
        final IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        final String editorId = PatternEditor.ID;
        Collection defaultVariable = (Collection)applicationContext.getDefaultVariable();
        for (Object currentVariable : defaultVariable) {
            if (!(currentVariable instanceof IJavaProject)) continue;
            IProject project = ((IJavaProject)currentVariable).getProject();
            IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)project);
            final String[] pluginId = new String[1];
            if (pluginModel != null) {
                pluginId[0] = pluginModel.getPluginBase().getId();
            }
            WorkspacePatternExtensionReader reader = new WorkspacePatternExtensionReader();
            IDescriptor patternsDescriptor = reader.getPatternLibraries(project);
            PatternDescriptorStrategy strategy = new PatternDescriptorStrategy();
            strategy.iterateThroughPatternExtensionDescriptor(new IPatternDescriptorHandler(){

                public void handleDescriptor(IDescriptor descriptor_p) {
                }

                public void handleLibraryDescriptor(IDescriptor descriptor_p, String parentLibraryId_p) {
                }

                public void handlePatternDescriptor(IDescriptor descriptor_p, String patternFullId_p) {
                    PatternModel patternModel = ModelFactory.eINSTANCE.createPatternModel();
                    patternModel.setPath((String)descriptor_p.getValue("model"));
                    patternModel.setName((String)descriptor_p.getValue("name"));
                    patternModel.setId(patternFullId_p);
                    try {
                        page.openEditor((IEditorInput)new PatternEditorInput(pluginId[0], patternModel, true), editorId);
                    }
                    catch (PartInitException exception_p) {
                        StringBuilder loggerMessage = new StringBuilder(".handlePatternDescriptor(..) _ ");
                        __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                    }
                }
            }, patternsDescriptor);
        }
        return null;
    }
}

