/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editor.page;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.common.descriptor.GenericDescriptor;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.descriptor.pattern.helper.IPatternDescriptorHandler;
import org.eclipse.egf.common.descriptor.pattern.helper.PatternDescriptorStrategy;
import org.eclipse.egf.common.ui.helper.FormHelper;
import org.eclipse.egf.common.ui.toolkit.viewers.TransferTreeViewer;
import org.eclipse.egf.common.ui.toolkit.widgets.handler.SelectionChangedHandler;
import org.eclipse.egf.core.ui.viewers.PatternStructureLabelProviderWithTooltip;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.ecore.AbstractPatternGenerator;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.production.template.TemplateHelper;
import org.eclipse.egf.pattern.ui.PatternUiActivator;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternBlock;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternPage;
import org.eclipse.egf.pattern.ui.editor.page.Messages;
import org.eclipse.egf.pattern.ui.internal.editor.page.AbstractPatternPageContentProvider;
import org.eclipse.egf.pattern.ui.internal.editor.page.DefaultContentHandler;
import org.eclipse.egf.pde.pattern.reader.PlatformPatternExtensionReader;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PatternInheritancePage
extends AbstractPatternPage {
    protected static final String ID = "egf_pattern_inheritance_page";
    protected static final String HELP_CONTEXT_ID = String.valueOf(PatternUiActivator.getDefault().getPluginID()) + '.' + "egf_pattern_inheritance_page";

    public PatternInheritancePage(FormEditor editor_p) {
        super(editor_p, ID, Messages.PatternInheritancePage_Title);
    }

    protected void doCreateFormContent(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p, IManagedForm managedForm_p) {
        FormHelper.updateCompositeLayoutWithLayoutType((Composite)parent_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
        toolkit_p.createLabel(parent_p, Messages.PatternInheritancePage_Description_Label, 64);
        new ParentsViewer().createViewer(toolkit_p, parent_p, patternData_p);
    }

    protected AbstractPatternBlock createPatternBlock() {
        return null;
    }

    public String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    private class InheritanceHandler
    extends DefaultContentHandler {
        protected InheritanceHandler(PatternHandler.PatternData patternData_p) {
            super(patternData_p, PatternInheritancePage.this);
        }

        public void setParentDescriptor(IDescriptor descriptor_p) {
            String patternName = null;
            String ecoreUri = null;
            if (descriptor_p != null) {
                patternName = (String)descriptor_p.getValue("name");
                ecoreUri = (String)descriptor_p.getValue("model");
            }
            ecoreUri = TemplateHelper.getPhysicalRelativePath(ecoreUri);
            AbstractPatternGenerator.setPatternParent((Pattern)this.getPattern(), (String)patternName, (String)ecoreUri, null);
            this.notifyModification();
        }
    }

    protected class ParentsButtonHandler
    extends SelectionChangedHandler {
        protected ParentsButtonHandler() {
        }

        protected boolean doHandleSelection(ISelection selection_p) {
            StructuredSelection selection;
            Object selectedElement;
            boolean result = false;
            if (selection_p instanceof StructuredSelection && (selectedElement = (selection = (StructuredSelection)selection_p).getFirstElement()) instanceof IDescriptor) {
                IDescriptor selectedDescriptor = (IDescriptor)selectedElement;
                result = "pattern".equals(selectedDescriptor.getValue("patternExtType"));
            }
            return result & this.postCondition();
        }

        protected boolean postCondition() {
            return true;
        }
    }

    protected class ParentsContentProvider
    extends AbstractPatternPageContentProvider
    implements ITreeContentProvider {
        private boolean _leftViewer;
        private IDescriptor _currentParent;
        private IDescriptor _currentPattern;
        private InheritanceHandler _handler;

        protected ParentsContentProvider(boolean leftViewer_p, IDescriptor currentParent_p, IDescriptor currentPattern_p, InheritanceHandler handler_p) {
            this._leftViewer = leftViewer_p;
            this._currentParent = currentParent_p;
            this._currentPattern = currentPattern_p;
            this._handler = handler_p;
        }

        protected GenericDescriptor getInitialInput() {
            return (GenericDescriptor)super.getInitialInput();
        }

        protected TreeViewer getViewer() {
            return (TreeViewer)super.getViewer();
        }

        private void setCurrentParent(IDescriptor descriptor_p) {
            this._currentParent = descriptor_p;
            if (this._handler != null) {
                this._handler.setParentDescriptor(this._currentParent);
            }
        }

        protected IDescriptor getDescriptor(Object elements_p) {
            return (IDescriptor)this.getElement(elements_p, IDescriptor.class);
        }

        protected void doHandleElementsAdded(Object addedElements_p) {
            IDescriptor addedElement = this.getDescriptor(addedElements_p);
            if (addedElement == null) {
                return;
            }
            IDescriptor parent = addedElement.getParent();
            if (this._leftViewer) {
                this.setCurrentParent(null);
                IDescriptor treePath = parent == null ? this.getInitialInput() : parent;
                this.getViewer().add((Object)treePath, (Object)addedElement);
            } else {
                this.setCurrentParent(addedElement);
                IDescriptor parentDescriptor = this._currentParent.getParent();
                this.getInitialInput().addChild(parentDescriptor);
                this.getViewer().add((Object)this.getInitialInput(), (Object)parentDescriptor);
            }
        }

        protected void doHandleElementsRemoved(Object removedElements_p) {
            IDescriptor removedElement = this.getDescriptor(removedElements_p);
            if (removedElement == null) {
                return;
            }
            IDescriptor parent = removedElement.getParent();
            if (this._leftViewer) {
                this.setCurrentParent(removedElement);
                this.getViewer().remove((Object)parent, new Object[]{removedElement});
            } else {
                this.setCurrentParent(null);
                this.getInitialInput().getChildren().remove(parent);
                this.getViewer().remove((Object)this.getInitialInput(), new Object[]{parent});
            }
        }

        protected void doHandleElementUpdated(Object oldInput_p, Object newInput_p) {
        }

        public Object[] getChildren(Object parentElement_p) {
            Object[] result = null;
            IDescriptor desciptor = (IDescriptor)parentElement_p;
            List children = desciptor.getChildren();
            if (children != null) {
                List<IDescriptor> resultingChildren = null;
                if (this._leftViewer) {
                    resultingChildren = new ArrayList(children.size());
                    resultingChildren.addAll(children);
                    resultingChildren.remove(this._currentParent);
                    resultingChildren.remove(this._currentPattern);
                } else if (parentElement_p != this.getInitialInput()) {
                    resultingChildren = new ArrayList(1);
                    resultingChildren.add(this._currentParent);
                    resultingChildren.retainAll(children);
                } else {
                    resultingChildren = children;
                }
                result = resultingChildren.toArray();
            }
            return result;
        }

        public Object getParent(Object element_p) {
            IDescriptor descriptor = (IDescriptor)element_p;
            return descriptor.getParent();
        }

        public boolean hasChildren(Object element_p) {
            Object[] children = this.getChildren(element_p);
            return children != null && children.length > 0;
        }

        public Object[] getElements(Object inputElement_p) {
            return this.getChildren(inputElement_p);
        }

        public void doDispose() {
            this._currentParent = null;
            this._currentPattern = null;
            this._handler = null;
        }
    }

    protected class ParentsViewer {
        private TransferTreeViewer _viewer;
        private IDescriptor _currentPattern;
        private IDescriptor _currentParent;
        private String _currentParentFullId;
        private IDescriptor _rootDescriptor;

        protected ParentsViewer() {
        }

        protected void createViewer(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p) {
            int style = 88;
            this._viewer = new TransferTreeViewer(parent_p, style, 2820, 2820);
            Composite buttonsComposite = this._viewer.getButtonsContainer();
            this.initializeContent(patternData_p);
            this.initializeListeners(patternData_p);
            this.initializeLeftViewer((AbstractTreeViewer)this._viewer.getLeftViewer());
            this.initializeRightViewer((AbstractTreeViewer)this._viewer.getRightViewer(), patternData_p);
            toolkit_p.adapt(this._viewer.getControl(), true, true);
            buttonsComposite.setEnabled(PatternInheritancePage.this.isEditable());
            toolkit_p.adapt((Control)buttonsComposite, true, true);
        }

        protected void initializeContent(PatternHandler.PatternData patternData_p) {
            GenericDescriptor rootDescriptor = new GenericDescriptor();
            PatternDescriptorStrategy.retainRootOnly((GenericDescriptor)rootDescriptor, (IDescriptor)new PlatformPatternExtensionReader().getPatternLibraries());
            this._rootDescriptor = rootDescriptor;
            Pattern parentPattern = patternData_p.getParentPattern();
            final String patternfullId = patternData_p.getPattern().getId();
            final IDescriptor[] currentPattern = new IDescriptor[1];
            if (parentPattern != null) {
                this._currentParentFullId = parentPattern.getId();
            }
            PatternDescriptorStrategy strategy = new PatternDescriptorStrategy();
            strategy.iterateThroughPatternExtensionDescriptor(new IPatternDescriptorHandler(){

                public void handleDescriptor(IDescriptor descriptor_p) {
                }

                public void handleLibraryDescriptor(IDescriptor descriptor_p, String parentLibraryId_p) {
                }

                public void handlePatternDescriptor(IDescriptor descriptor_p, String patternFullId_p) {
                    if (patternFullId_p.equals(ParentsViewer.this._currentParentFullId)) {
                        ParentsViewer.this._currentParent = descriptor_p;
                    } else if (patternFullId_p.equals(patternfullId)) {
                        currentPattern[0] = descriptor_p;
                    }
                }
            }, (IDescriptor)rootDescriptor);
            this._currentPattern = currentPattern[0];
        }

        protected IDescriptor getRootDescriptorFor(IDescriptor descriptor_p) {
            GenericDescriptor result = new GenericDescriptor();
            if (descriptor_p != null) {
                IDescriptor parentDescriptor = descriptor_p.getParent();
                result.addChild(parentDescriptor);
            }
            return result;
        }

        protected void initializeLeftViewer(AbstractTreeViewer leftViewer_p) {
            leftViewer_p.setAutoExpandLevel(2);
            leftViewer_p.setComparator(new ViewerComparator());
            this._viewer.setLeftContentProvider((IContentProvider)new ParentsContentProvider(true, this._currentParent, this._currentPattern, null));
            this._viewer.setLeftLabelProvider((ILabelProvider)new PatternStructureLabelProviderWithTooltip());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)leftViewer_p);
            this._viewer.setLeftInput((Object)this._rootDescriptor);
        }

        protected void initializeRightViewer(AbstractTreeViewer rightViewer_p, PatternHandler.PatternData patternData_p) {
            rightViewer_p.setAutoExpandLevel(2);
            this._viewer.setRightContentProvider((IContentProvider)new ParentsContentProvider(false, this._currentParent, null, new InheritanceHandler(patternData_p)));
            this._viewer.setRightLabelProvider((ILabelProvider)new PatternStructureLabelProviderWithTooltip());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)rightViewer_p);
            this._viewer.setRightInput((Object)this.getRootDescriptorFor(this._currentParent));
        }

        protected void initializeListeners(final PatternHandler.PatternData patternData_p) {
            ParentsButtonHandler addButtonHandler = new ParentsButtonHandler(PatternInheritancePage.this){

                protected boolean postCondition() {
                    boolean result = true;
                    EList parents = patternData_p.getPattern().getESuperTypes();
                    if (parents.size() > 0) {
                        EClass parent = (EClass)parents.get(0);
                        result = !(parent instanceof Pattern);
                    }
                    return result;
                }
            };
            this._viewer.setSelectionChangedHandler((SelectionChangedHandler)addButtonHandler, 8);
            this._viewer.setSelectionChangedHandler((SelectionChangedHandler)new ParentsButtonHandler(), 16);
        }
    }
}

