/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action.explorer.delete;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.ui.workbench.Messages;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeleteModelElementAction;
import org.eclipse.egf.model.Domain;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.edit.command.SetModelElementCommand;
import org.eclipse.egf.model.edit.command.plugin.PluginChangeWrapperCommand;
import org.eclipse.egf.model.edit.command.plugin.domain.RemoveDomainWrapperCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDomainAction
extends DeleteModelElementAction {
    public DeleteDomainAction(Shell shell_p, ISelectionProvider selectionProvider_p, boolean readOnlyMode_p) {
        super(shell_p, selectionProvider_p, readOnlyMode_p);
    }

    @Override
    protected String[] getConfirmDeleteMessage() {
        Domain domain = (Domain)this.getModelElement();
        String[] message = new String[]{Messages.DeleteDomainAction_Message, domain.getPath()};
        return message;
    }

    @Override
    protected Class<?> getModelElementClass() {
        return Domain.class;
    }

    public boolean isEnabled() {
        boolean isEnabled = super.isEnabled();
        if (isEnabled) {
            Domain domain = (Domain)this.getModelElement();
            isEnabled = ModelHelper.isDomainDefined((Domain)domain);
        }
        return isEnabled;
    }

    @Override
    protected boolean closeEditor(NamedModelElementWithId modelElement_p) {
        IProject hostingProject = ModelHelper.getProject((NamedModelElementWithId)modelElement_p);
        String domainAsEcore = ((Domain)modelElement_p).getPath();
        IFile domainFile = hostingProject.getFile(domainAsEcore);
        boolean result = this.closeFileEditor(domainFile, "org.eclipse.emf.ecore.presentation.EcoreEditorID");
        IPath domainDiagramPath = new Path(domainAsEcore).removeFileExtension().addFileExtension("ecorediag");
        IFile domainDiagramFile = hostingProject.getFile(domainDiagramPath.toString());
        return result |= this.closeFileEditor(domainDiagramFile, "org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorID");
    }

    @Override
    protected void doDeleteModelElement() {
        this.closeEditor(this.getModelElement());
        AdapterFactoryEditingDomain editingDomain = this.getEditingDomain();
        Domain domain = (Domain)this.getModelElement();
        EAttribute feature = ModelPackage.Literals.DOMAIN__PATH;
        SetModelElementCommand deleteCommand = new SetModelElementCommand((EditingDomain)editingDomain, (EObject)domain, (EStructuralFeature)feature, null);
        deleteCommand.setPluginChangeCommand((PluginChangeWrapperCommand)new RemoveDomainWrapperCommand((EditingDomain)editingDomain, (EObject)domain, (EStructuralFeature)feature, (Object)domain.getPath()));
        this.executeCommand(editingDomain, (Command)deleteCommand);
    }
}

