/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action.explorer.delete;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.core.ui.workbench.Messages;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeleteModelElementAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeletePatternAction;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletePatternLibraryAction
extends DeleteModelElementAction {
    public DeletePatternLibraryAction(Shell shell_p, ISelectionProvider selectionProvider_p, boolean readOnlyMode_p) {
        super(shell_p, selectionProvider_p, readOnlyMode_p);
    }

    @Override
    protected String[] getConfirmDeleteMessage() {
        String[] message = new String[]{Messages.DeletePatternLibraryAction_Message, this.getModelElement().getName()};
        return message;
    }

    @Override
    protected Class<?> getModelElementClass() {
        return PatternLibrary.class;
    }

    @Override
    protected void doDeleteModelElement() {
        PatternLibrary patternLibrary = this.getPatternLibrary();
        IProject project = ModelHelper.getProject((NamedModelElementWithId)patternLibrary);
        this.deleteSubLibraries(patternLibrary);
        super.doDeleteModelElement();
        ProjectHelper.refreshProject((IProject)project, (int)2, (IProgressMonitor)new NullProgressMonitor());
    }

    private void deleteSubLibraries(PatternLibrary library_p) {
        ArrayList patternElementList = new ArrayList(library_p.getPatternElements());
        for (AbstractPatternElement currentPatternElement : patternElementList) {
            if (currentPatternElement instanceof PatternLibrary) {
                this.deleteSubLibraries((PatternLibrary)currentPatternElement);
                continue;
            }
            if (!(currentPatternElement instanceof PatternModel)) continue;
            this.deletePattern((PatternModel)currentPatternElement);
        }
    }

    private void deletePattern(PatternModel pattern_p) {
        DeletePatternAction deletePatternAction = new DeletePatternAction(this.getShell(), this.getSelectionProvider(), this.isReadOnly());
        deletePatternAction.setSelectedElement(pattern_p);
        deletePatternAction.setUserConfirmationRequested(false);
        deletePatternAction.setRefreshProject(false);
        deletePatternAction.run();
    }

    private PatternLibrary getPatternLibrary() {
        return (PatternLibrary)this.getModelElement();
    }
}

