/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.views.explorer;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egf.common.helper.MiscHelper;
import org.eclipse.egf.common.ui.helper.ViewerHelper;
import org.eclipse.egf.common.ui.helper.WorkbenchHelper;
import org.eclipse.egf.core.ui.EgfUiActivator;
import org.eclipse.egf.core.ui.data.explorer.FactoryComponentWorkingSet;
import org.eclipse.egf.core.ui.data.explorer.FactoryComponentWorkingSetManager;
import org.eclipse.egf.core.ui.data.listener.IWorkingSetListener;
import org.eclipse.egf.core.ui.workbench.internal.drop.DelegatingCommonDropAdapter;
import org.eclipse.egf.core.ui.workbench.views.fc.AbstractFactoryComponentView;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.internal.data.ModelElement;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.navigator.CommonDragAdapter;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryComponentProjectExplorer
extends AbstractFactoryComponentView {
    private static final String TAG_ROOT_MODE = "rootMode";
    public static final String VIEW_ID = "org.eclipse.egf.core.ui.workbench.views.explorer.assetProjectExplorer";
    private static final String CONTENT_PROVIDER_ID = "org.eclipse.egf.core.ui.workbench.views.explorer.assetProjectExplorerContent";
    private IWorkingSetListener _workingSetListener;
    private FactoryComponentWorkingSetManager _fcWorkingSetManager;
    private ISelectionChangedListener _selectionChangedListener;

    protected IAdaptable getInitialInput() {
        return this.computeInput(this.isProjectModeSelected());
    }

    protected IAdaptable computeInput(boolean isProjectModeSelected_p) {
        IAdaptable input = null;
        if (isProjectModeSelected_p) {
            input = EgfUiActivator.getDefault().getFactoryComponentInWorkspaceInput();
        } else {
            if (this._fcWorkingSetManager == null) {
                this._fcWorkingSetManager = (FactoryComponentWorkingSetManager)EgfUiActivator.getDefault().getWorkingSetsInput();
            }
            this.initializeWorkingSetListener();
            input = this._fcWorkingSetManager;
            this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    FactoryComponentProjectExplorer.this._workingSetListener.workingSetModelChanged(null);
                }
            });
        }
        return input;
    }

    private boolean isProjectModeSelected() {
        IDialogSettings dialogSettingsSection = JavaPlugin.getDefault().getDialogSettingsSection(PackageExplorerPart.class.getName());
        return 1 == dialogSettingsSection.getInt(TAG_ROOT_MODE);
    }

    @Override
    protected String getContentProviderId() {
        return CONTENT_PROVIDER_ID;
    }

    @Override
    protected AdapterFactoryEditingDomain getEditingDomain() {
        return EgfUiActivator.getDefault().getEditingDomain();
    }

    @Override
    protected void handleAffectedObjects(Collection<?> affectedObjects_p) {
        super.handleAffectedObjects(affectedObjects_p);
        boolean forceRefresh = false;
        Iterator<?> iterator = affectedObjects_p.iterator();
        while (iterator.hasNext() && !forceRefresh) {
            Object affectedObject = iterator.next();
            if (!(affectedObject instanceof ContractElement) && !(affectedObject instanceof FactoryComponent)) continue;
            forceRefresh = true;
        }
        if (forceRefresh) {
            ViewerHelper.refresh((StructuredViewer)this.getCommonViewer());
        }
        this.getNavigatorActionService().updateActionBars();
    }

    protected CommonViewer createCommonViewer(Composite parent_p) {
        CommonViewer viewer = new CommonViewer(this.getViewSite().getId(), parent_p, 770){

            protected void initDragAndDrop() {
                int operations = 3;
                INavigatorContentService contentService = this.getNavigatorContentService();
                CommonDragAdapter dragAdapter = new CommonDragAdapter(contentService, (ISelectionProvider)this);
                this.addDragSupport(operations, dragAdapter.getSupportedDragTransfers(), (DragSourceListener)dragAdapter);
                DelegatingCommonDropAdapter dropAdapter = new DelegatingCommonDropAdapter(contentService, (StructuredViewer)this);
                this.addDropSupport(operations, dropAdapter.getSupportedDropTransfers(), (DropTargetListener)dropAdapter);
            }
        };
        this.initListeners((TreeViewer)viewer);
        viewer.getNavigatorContentService().restoreState(this.getMemento());
        return viewer;
    }

    protected void initListeners(TreeViewer viewer_p) {
        super.initListeners(viewer_p);
        this._selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                PackageExplorerPart packageExplorerView;
                NamedModelElementWithId namedModelElement;
                FactoryComponent fcContainer;
                IProject hostingProject;
                IStructuredSelection structuredSelection;
                Object element;
                if (event_p == null || !FactoryComponentProjectExplorer.this.isLinkingEnabled()) {
                    return;
                }
                ISelection selection = event_p.getSelection();
                if (!selection.isEmpty() && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof NamedModelElementWithId && (hostingProject = (IProject)((ModelElement)(fcContainer = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)(namedModelElement = (NamedModelElementWithId)element)))).getAdapter(IProject.class)) != null && (packageExplorerView = WorkbenchHelper.getPackageExplorerView()) != null) {
                    packageExplorerView.selectAndReveal((Object)hostingProject);
                }
            }
        };
        viewer_p.addPostSelectionChangedListener(this._selectionChangedListener);
        this.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source_p, int propId_p) {
                switch (propId_p) {
                    case 65536: {
                        Control tree;
                        CommonViewer commonViewer = FactoryComponentProjectExplorer.this.getCommonViewer();
                        if (commonViewer == null || (tree = commonViewer.getControl()) == null || tree.isDisposed()) break;
                        FactoryComponentProjectExplorer.this._selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)commonViewer, commonViewer.getSelection()));
                    }
                }
            }
        });
    }

    protected void initializeWorkingSetListener() {
        if (this._workingSetListener == null) {
            this._workingSetListener = new IWorkingSetListener(){

                public void workingSetAdded(FactoryComponentWorkingSet workingSet_p, PropertyChangeEvent event_p) {
                    if (workingSet_p != null) {
                        FactoryComponentProjectExplorer.this.getCommonViewer().add(null, (Object)workingSet_p);
                    }
                }

                public void workingSetContentChanged(FactoryComponentWorkingSet workingSet_p, PropertyChangeEvent event_p) {
                    if (workingSet_p != null) {
                        ViewerHelper.refresh((StructuredViewer)FactoryComponentProjectExplorer.this.getCommonViewer());
                    }
                }

                public void workingSetLabelChanged(FactoryComponentWorkingSet workingSet_p, PropertyChangeEvent event_p) {
                    if (workingSet_p != null) {
                        FactoryComponentProjectExplorer.this.getCommonViewer().update((Object)workingSet_p, null);
                    }
                }

                public void workingSetNameChanged(FactoryComponentWorkingSet workingSet_p, PropertyChangeEvent event_p) {
                    this.workingSetLabelChanged(workingSet_p, event_p);
                }

                public void workingSetRemoved(FactoryComponentWorkingSet workingSet_p, PropertyChangeEvent event_p) {
                    ViewerHelper.refresh((StructuredViewer)FactoryComponentProjectExplorer.this.getCommonViewer());
                }

                public void workingSetModelChanged(PropertyChangeEvent event_p) {
                    List<IWorkingSet> packageExplorerWorkingSets = FactoryComponentProjectExplorer.this.getPackageExplorerWorkingSets();
                    if (!packageExplorerWorkingSets.isEmpty()) {
                        FactoryComponentProjectExplorer.this._fcWorkingSetManager.updatePublicWorkingSetsOrder(packageExplorerWorkingSets);
                        ViewerHelper.refresh((StructuredViewer)FactoryComponentProjectExplorer.this.getCommonViewer());
                    }
                }
            };
            this.getFactoryComponentWorkingSetManager().addWorkingSetListener(this._workingSetListener);
        }
    }

    protected List<IWorkingSet> getPackageExplorerWorkingSets() {
        List activeWorkingSets = Collections.emptyList();
        PackageExplorerPart packageExplorerView = WorkbenchHelper.getPackageExplorerView();
        if (packageExplorerView != null) {
            Object[] activeWorkingSetArray = packageExplorerView.getWorkingSetModel().getActiveWorkingSets();
            activeWorkingSets = MiscHelper.asList((Object[])activeWorkingSetArray);
        }
        return activeWorkingSets;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._workingSetListener != null) {
            this._fcWorkingSetManager.removeWorkingSetListener(this._workingSetListener);
            this._workingSetListener = null;
            this._fcWorkingSetManager = null;
        }
    }

    protected FactoryComponentWorkingSetManager getFactoryComponentWorkingSetManager() {
        return this._fcWorkingSetManager;
    }

    public void updateInput(boolean isProjectModeSelected_p) {
        IAdaptable newInput = this.computeInput(isProjectModeSelected_p);
        this.getCommonViewer().setInput((Object)newInput);
    }
}

