/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.listener;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;

public abstract class DefaultResourceListener
implements IResourceChangeListener {
    private IResource _resourceToWatch;
    private volatile boolean _alreadyRegistered;

    public void setResourceToWatch(IResource resource_p) {
        this._resourceToWatch = resource_p;
        if (!this._alreadyRegistered) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            this._alreadyRegistered = true;
        }
    }

    public void dispose() {
        this._resourceToWatch = null;
        if (this._alreadyRegistered) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this._alreadyRegistered = false;
        }
    }

    public void resourceChanged(IResourceChangeEvent event_p) {
        if (this.refersToResource(this._resourceToWatch, event_p)) {
            this.handleResourceChanged(event_p, this._resourceToWatch);
        }
    }

    protected abstract void handleResourceChanged(IResourceChangeEvent var1, IResource var2);

    protected boolean refersToResource(IResource lookedForResource_p, IResourceChangeEvent event_p) {
        if (lookedForResource_p == null || event_p == null) {
            return false;
        }
        return this.refersToResource(lookedForResource_p, event_p.getDelta());
    }

    private boolean refersToResource(IResource lookedForResource_p, IResourceDelta resourceDelta_p) {
        IResource resource = resourceDelta_p.getResource();
        boolean result = lookedForResource_p.equals((Object)resource);
        if (!result) {
            IResourceDelta[] children = resourceDelta_p.getAffectedChildren();
            int i = 0;
            while (i < children.length && !result) {
                result = this.refersToResource(lookedForResource_p, children[i]);
                ++i;
            }
        }
        return result;
    }
}

