/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class BasicImageRegistry {
    private static BasicImageRegistry __instance = new BasicImageRegistry();
    private Map<ImageDescriptor, Image> _registry = new HashMap<ImageDescriptor, Image>(0);

    private BasicImageRegistry() {
        this(PlatformUI.getWorkbench().getDisplay());
    }

    public BasicImageRegistry(Display display_p) {
        this.hookDisplayDispose(display_p);
    }

    public static BasicImageRegistry getInstance() {
        return __instance;
    }

    public Image getImage(ImageDescriptor imageDescriptor_p) {
        Image result = null;
        result = this._registry.get(imageDescriptor_p);
        if (result == null) {
            result = imageDescriptor_p.createImage();
            this._registry.put(imageDescriptor_p, result);
        }
        return result;
    }

    public Image remove(ImageDescriptor imageDescriptor_p) {
        return this._registry.remove(imageDescriptor_p);
    }

    protected void hookDisplayDispose(Display display) {
        display.disposeExec(new Runnable(){

            public void run() {
                BasicImageRegistry.this.handleDisplayDisposedEvent();
            }
        });
    }

    protected void handleDisplayDisposedEvent() {
        for (Image currentImage : this._registry.values()) {
            if (currentImage == null || currentImage.isDisposed()) continue;
            currentImage.dispose();
        }
        this._registry.clear();
        this._registry = null;
    }
}

