/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.viewers;

import org.eclipse.egf.common.ui.toolkit.widgets.handler.SelectionChangedHandler;
import org.eclipse.egf.common.ui.viewers.IButtonClickedListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractViewerWithButtons {
    private Button[] _buttons;
    protected ButtonData[] _buttonData;
    private Composite _composite;
    protected StructuredViewer _decoratedViewer;
    private IButtonClickedListener _buttonClickedListener;
    private ISelectionChangedListener _viewerSelectionChangedListener;

    protected AbstractViewerWithButtons() {
    }

    protected AbstractViewerWithButtons(Composite parent_p) {
        this.init(parent_p);
    }

    protected void init(Composite parent_p) {
        this._composite = this.createInternalComposite(parent_p);
        this._decoratedViewer = this.createViewer(this._composite);
        this._viewerSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection selection = event_p.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                AbstractViewerWithButtons.this.updateButtons(selection);
            }
        };
        this._decoratedViewer.addSelectionChangedListener(this._viewerSelectionChangedListener);
        this.createButtons(this._composite, this.createButtonData());
    }

    protected boolean isEditable() {
        return true;
    }

    protected void updateButtons(ISelection selection_p) {
        ButtonData[] buttonDataArray = this._buttonData;
        int n = this._buttonData.length;
        int n2 = 0;
        while (n2 < n) {
            ButtonData buttonData = buttonDataArray[n2];
            SelectionChangedHandler selectionChangedHandler = buttonData.getSelectionChangedHandler();
            if (selectionChangedHandler != null) {
                selectionChangedHandler.handleSelection(selection_p);
            }
            ++n2;
        }
    }

    protected abstract ButtonData[] createButtonData();

    protected abstract StructuredViewer createViewer(Composite var1);

    private Composite createInternalComposite(Composite parent_p) {
        Composite composite = new Composite(parent_p, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    private void createButtons(Composite parent_p, ButtonData[] buttonData_p) {
        if (buttonData_p == null || buttonData_p.length == 0) {
            return;
        }
        Composite buttonContainer = new Composite(parent_p, 0);
        buttonContainer.setEnabled(this.isEditable());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        GridData gridData = new GridData(131072, 0x1000000, false, true);
        buttonContainer.setLayoutData((Object)gridData);
        this._buttonData = buttonData_p;
        this._buttons = new Button[buttonData_p.length];
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e_p) {
                this.buttonSelected(e_p);
            }

            public void widgetSelected(SelectionEvent e_p) {
                this.buttonSelected(e_p);
            }

            private void buttonSelected(SelectionEvent e) {
                AbstractViewerWithButtons.this.buttonSelected((Button)e.widget, e.widget.getData());
            }
        };
        int i = 0;
        while (i < buttonData_p.length) {
            ButtonData buttonData = buttonData_p[i];
            String label = buttonData.getLabel();
            int style = buttonData.getStyle();
            if (label != null) {
                Button button = this.createButton(buttonContainer, label, style);
                button.addSelectionListener((SelectionListener)listener);
                button.setData(buttonData.getData());
                SelectionChangedHandler handler = buttonData.getSelectionChangedHandler();
                if (handler != null) {
                    handler.addControl((Control)button);
                }
                this._buttons[i] = button;
            } else {
                this.createEmptySpace(buttonContainer, 1);
            }
            ++i;
        }
    }

    protected void buttonSelected(Button selectedButton_p, Object data_p) {
        if (this._buttonClickedListener != null) {
            this._buttonClickedListener.buttonClicked(selectedButton_p, data_p);
        }
        ISelection selection = this._decoratedViewer.getSelection();
        this.updateButtons(selection);
    }

    protected Button createButton(Composite parent_p, String label_p, int style_p) {
        Button button = new Button(parent_p, 8 | style_p);
        button.setText(label_p);
        GridData gridData = new GridData(4, 1, true, false);
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected Label createEmptySpace(Composite parent_p, int span_p) {
        Label label = new Label(parent_p, 0);
        GridData gridData = new GridData(4, 1, true, true);
        gridData.horizontalSpan = span_p;
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public StructuredViewer getDecoratedViewer() {
        return this._decoratedViewer;
    }

    public void setButtonClickedListener(IButtonClickedListener buttonClickedListener_p) {
        this._buttonClickedListener = buttonClickedListener_p;
    }

    public class ButtonData {
        private String _label;
        private int _style;
        private Object _data;
        private SelectionChangedHandler _selectionChangedHandler;

        public ButtonData(String label_p, int style_p, Object data_p, SelectionChangedHandler selectionChangedHandler_p) {
            this._label = label_p;
            this._style = style_p;
            this._data = data_p;
            this._selectionChangedHandler = selectionChangedHandler_p;
        }

        protected String getLabel() {
            return this._label;
        }

        protected int getStyle() {
            return this._style;
        }

        protected Object getData() {
            return this._data;
        }

        protected SelectionChangedHandler getSelectionChangedHandler() {
            return this._selectionChangedHandler;
        }
    }
}

