/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.internal.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.egf.common.ui.toolkit.viewers.AbstractStructuredContentProvider;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.core.data.helper.DataHelper;
import org.eclipse.egf.model.AbstractFactoryComponentFactory;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.Contract;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.ProductionPlan;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PossibleContractElementReferenceTreeContentProvider
extends AbstractStructuredContentProvider
implements ITreeContentProvider {
    private Object _initialInput;
    private Set<ContractElement> _removedContractElements;

    public PossibleContractElementReferenceTreeContentProvider(Collection<ContractElement> removedContractElements_p) {
        this._removedContractElements = new HashSet<ContractElement>(removedContractElements_p);
    }

    private Collection<ContractElement> getPossibleReferencedContractElements(FactoryComponent fc_p, Set<ContractElement> filteredContractElements_p) {
        Collection possibleReferencedContractElements = DataHelper.getPossibleReferencedContractElement((FactoryComponent)fc_p);
        possibleReferencedContractElements.removeAll(this._removedContractElements);
        return possibleReferencedContractElements;
    }

    public Object[] getChildren(Object parentElement_p) {
        Object[] result = null;
        if (parentElement_p instanceof FactoryComponent) {
            Collection<ContractElement> possibleReferencedContractElements = this.getPossibleReferencedContractElements((FactoryComponent)parentElement_p, this._removedContractElements);
            result = possibleReferencedContractElements.toArray(new ContractElement[possibleReferencedContractElements.size()]);
        } else if (parentElement_p instanceof Contract) {
            result = this.handleContractAsInitialInput((Contract)parentElement_p);
        } else if (parentElement_p instanceof Context) {
            result = this.handleContextAsInitialInput((Context)parentElement_p);
        }
        return result;
    }

    private Object[] handleContextAsInitialInput(Context context_p) {
        Object[] result = null;
        FactoryComponent fcContainer = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)context_p);
        AbstractFactoryComponentFactory contextContainer = (AbstractFactoryComponentFactory)context_p.eContainer();
        ArrayList<FactoryComponent> referencedFcs = null;
        if (contextContainer instanceof FactoryComponentInvocation) {
            referencedFcs = DataHelper.getReferencedFactoryComponentsBy((FactoryComponent)fcContainer);
            FactoryComponentInvocation fcInvocation = (FactoryComponentInvocation)contextContainer;
            FactoryComponent referencedFc = CoreActivator.getDefault().getFactoryComponent(fcInvocation.getFactoryComponentId());
            referencedFcs.retainAll(Collections.singletonList(referencedFc));
        } else if (contextContainer instanceof ProductionPlan) {
            referencedFcs = new ArrayList<FactoryComponent>(0);
            referencedFcs.add(fcContainer);
        }
        this.filterReferencedFcs((Collection<FactoryComponent>)referencedFcs);
        result = referencedFcs.toArray(new FactoryComponent[referencedFcs.size()]);
        return result;
    }

    private Object[] handleContractAsInitialInput(Contract contract_p) {
        Collection referencedFcs = DataHelper.getReferencedFactoryComponentsBy((FactoryComponent)ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)contract_p));
        this.filterReferencedFcs(referencedFcs);
        Object[] result = referencedFcs.toArray(new FactoryComponent[referencedFcs.size()]);
        return result;
    }

    private void filterReferencedFcs(Collection<FactoryComponent> referencedFcs_p) {
        Iterator<FactoryComponent> filteredFcs = referencedFcs_p.iterator();
        while (filteredFcs.hasNext()) {
            FactoryComponent currentFc = filteredFcs.next();
            Collection<ContractElement> possibleReferencedContractElements = this.getPossibleReferencedContractElements(currentFc, this._removedContractElements);
            if (!possibleReferencedContractElements.isEmpty()) continue;
            filteredFcs.remove();
        }
    }

    public Object getParent(Object element_p) {
        Object result = null;
        if (element_p instanceof ContractElement) {
            result = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)((ContractElement)element_p));
        } else if (element_p instanceof FactoryComponent) {
            result = this._initialInput;
        }
        return result;
    }

    public boolean hasChildren(Object element_p) {
        Object[] children = this.getChildren(element_p);
        boolean result = children != null;
        return result;
    }

    public Object[] getElements(Object inputElement_p) {
        return this.getChildren(inputElement_p);
    }

    public void dispose() {
    }

    protected void handleElementUpdated(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
    }

    protected void handleElementAdded(Viewer viewer_p, Object addedElements_p) {
        if (addedElements_p instanceof Object[]) {
            Object[] objectArray = (Object[])addedElements_p;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object contractElement = objectArray[n2];
                if (contractElement instanceof ContractElement) {
                    AbstractTreeViewer abstractTreeViewer = (AbstractTreeViewer)viewer_p;
                    Object fcParent = this.getParent(contractElement);
                    abstractTreeViewer.add(this._initialInput, fcParent);
                    abstractTreeViewer.add(fcParent, contractElement);
                    this._removedContractElements.remove(contractElement);
                }
                ++n2;
            }
        } else if (addedElements_p instanceof Contract || addedElements_p instanceof Context) {
            this._initialInput = addedElements_p;
        }
    }

    protected void handleElementRemoved(Viewer viewer_p, Object removedElements_p) {
        if (removedElements_p instanceof Object[]) {
            Object[] removedElements = (Object[])removedElements_p;
            AbstractTreeViewer abstractTreeViewer = (AbstractTreeViewer)viewer_p;
            Object[] objectArray = removedElements;
            int n = removedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object removedElement = objectArray[n2];
                if (removedElement instanceof ContractElement) {
                    ContractElement removedContractElement = (ContractElement)removedElement;
                    abstractTreeViewer.remove(removedElement);
                    this._removedContractElements.add(removedContractElement);
                    FactoryComponent fcParent = (FactoryComponent)this.getParent(removedContractElement);
                    Collection<ContractElement> possibleReferencedContractElements = this.getPossibleReferencedContractElements(fcParent, this._removedContractElements);
                    if (possibleReferencedContractElements.isEmpty()) {
                        abstractTreeViewer.remove((Object)fcParent);
                    }
                }
                ++n2;
            }
        }
    }

    protected void handleViewer(Viewer viewer_p) {
        if (!(viewer_p instanceof AbstractTreeViewer)) {
            throw new IllegalArgumentException("Viewer must be an instanceof AbstractTreeViewer");
        }
    }
}

