/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import org.eclipse.egf.common.ui.helper.FieldEditorHelper;
import org.eclipse.egf.common.ui.toolkit.fields.CRadioGroupFieldEditor;
import org.eclipse.egf.core.ui.internal.help.IHelpContextIds;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractModelElementWizardPage;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.ContractElementReference;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class ContextElementWizardPage
extends AbstractModelElementWizardPage {
    private static final String CONTEXT_ELEMENT_KEY = String.valueOf(0);
    private static final String CONTEXT_ELEMENT_REFERENCE = String.valueOf(1);
    private CRadioGroupFieldEditor _typeGroup;

    public ContextElementWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public ContextElementWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected void createPageArea(Composite parent_p) {
        this.createTypeGroup(parent_p);
        this.handlePageLayout(parent_p);
    }

    protected void handlePageLayout(Composite parent_p) {
        FieldEditorHelper.layoutFieldEditor((Composite)parent_p, (FieldEditor)this._typeGroup, (int)1);
    }

    private void createTypeGroup(Composite parent_p) {
        ContextElement contextElement = (ContextElement)this.getModelElement();
        String[][] labelAndValues = new String[][]{{Messages.ContextElementWizardPage_Group_Key, CONTEXT_ELEMENT_KEY}, {Messages.ContextElementWizardPage_Group_Reference, CONTEXT_ELEMENT_REFERENCE}};
        this._typeGroup = FieldEditorHelper.createRadioGroupFieldEditor((Composite)parent_p, (String)Messages.ContractElementWizardPage_TypeGroup_Title, (int)1, (String[][])labelAndValues, (boolean)this.isReadOnly());
        ContractElementReference contractElementReference = contextElement.getContractElementReference();
        boolean hasReferencedContractElement = contractElementReference != null;
        String typeGroupSelection = null;
        typeGroupSelection = hasReferencedContractElement ? CONTEXT_ELEMENT_REFERENCE : (contextElement.getKey() == null ? CONTEXT_ELEMENT_REFERENCE : CONTEXT_ELEMENT_KEY);
        this._typeGroup.selectRadioButtonFor((Object)typeGroupSelection);
    }

    protected boolean getCompleteStatus() {
        return false;
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public IWizardPage getNextPage() {
        IWizardPage result = null;
        Object radioButtonValue = this._typeGroup.getSelectedRadioButton();
        IWizard wizard = this.getWizard();
        if (CONTEXT_ELEMENT_KEY.equals(radioButtonValue)) {
            result = wizard.getPage("contextElementKeyPage");
        } else if (CONTEXT_ELEMENT_REFERENCE.equals(radioButtonValue)) {
            result = wizard.getPage("contextElementReferencePage");
        }
        return result;
    }

    public boolean isReferencingContractElement() {
        Object radioButtonValue = this._typeGroup.getSelectedRadioButton();
        return CONTEXT_ELEMENT_REFERENCE.equals(radioButtonValue);
    }

    protected String getPageTitle() {
        return Messages.ContextElementWizardPage_Title;
    }

    protected String getHelpContextId() {
        return IHelpContextIds.NEW_CONTEXT_ELEMENT_WIZARD_PAGE;
    }
}

