/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet.editor.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.jet.editor.codeassist.JETTemplateCompletionProcessor;
import org.eclipse.emf.codegen.jet.editor.codeassist.JETTemplateDirectiveCompletionProcessor;
import org.eclipse.emf.codegen.jet.editor.presentation.JETReconcilingStrategy;
import org.eclipse.emf.codegen.jet.editor.presentation.JETTextEditor;
import org.eclipse.emf.codegen.jet.editor.scanners.JETTemplateDirectiveScanner;
import org.eclipse.emf.codegen.jet.editor.scanners.JETTemplateExpressionScanner;
import org.eclipse.emf.codegen.jet.editor.scanners.JETTemplateJavaDocScanner;
import org.eclipse.emf.codegen.jet.editor.scanners.JETTemplateJavaMultiLineCommentScanner;
import org.eclipse.emf.codegen.jet.editor.scanners.JETTemplateJavaSingleLineCommentScanner;
import org.eclipse.emf.codegen.jet.editor.scanners.JETTemplateJavaStringScanner;
import org.eclipse.emf.codegen.jet.editor.scanners.JETTemplatePartitionScanner;
import org.eclipse.emf.codegen.jet.editor.scanners.JETTemplateScriptletScanner;
import org.eclipse.emf.codegen.jet.editor.util.JETTemplateAutoEditStrategy;
import org.eclipse.emf.codegen.jet.editor.util.hovers.JETTemplateScriptletHover;
import org.eclipse.jdt.internal.ui.text.ContentAssistPreference;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaInformationProvider;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JETTemplateSourceViewerConfiguration
extends JavaSourceViewerConfiguration {
    private RuleBasedScanner jetScriptletScanner;
    private RuleBasedScanner jetDirectiveScanner;
    private RuleBasedScanner jetExpressionScanner;
    private RuleBasedScanner javaStringScanner;
    private RuleBasedScanner javaMultiLineCommentScanner;
    private RuleBasedScanner javaSingleLineCommentScanner;
    private RuleBasedScanner javaDocScanner;
    private IPreferenceStore store;
    private JETTextEditor jetEditor;

    public JETTemplateSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore store, JETTextEditor editor, String partitioning) {
        super(colorManager, store, (ITextEditor)editor, partitioning);
        this.store = store;
        this.jetEditor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return JETTemplatePartitionScanner.getLegalContentTypes();
    }

    protected RuleBasedScanner getJSPExpressionScanner() {
        if (this.jetExpressionScanner == null) {
            this.jetExpressionScanner = new JETTemplateExpressionScanner(this.getColorManager(), this.store);
        }
        return this.jetExpressionScanner;
    }

    protected RuleBasedScanner getJSPScriptletScanner() {
        if (this.jetScriptletScanner == null) {
            this.jetScriptletScanner = new JETTemplateScriptletScanner(this.getColorManager(), this.store);
        }
        return this.jetScriptletScanner;
    }

    protected RuleBasedScanner getJSPDirectiveScanner() {
        if (this.jetDirectiveScanner == null) {
            this.jetDirectiveScanner = new JETTemplateDirectiveScanner(this.getColorManager(), this.store);
        }
        return this.jetDirectiveScanner;
    }

    protected RuleBasedScanner getJavaStringDirectiveScanner() {
        if (this.javaStringScanner == null) {
            this.javaStringScanner = new JETTemplateJavaStringScanner(this.getColorManager(), this.store);
        }
        return this.javaStringScanner;
    }

    protected RuleBasedScanner getJavaMultiLineCommentDirectiveScanner() {
        if (this.javaMultiLineCommentScanner == null) {
            this.javaMultiLineCommentScanner = new JETTemplateJavaMultiLineCommentScanner(this.getColorManager(), this.store);
        }
        return this.javaMultiLineCommentScanner;
    }

    protected RuleBasedScanner getJavaSingleLineCommentDirectiveScanner() {
        if (this.javaSingleLineCommentScanner == null) {
            this.javaSingleLineCommentScanner = new JETTemplateJavaSingleLineCommentScanner(this.getColorManager(), this.store);
        }
        return this.javaSingleLineCommentScanner;
    }

    protected RuleBasedScanner getJavaDocDirectiveScanner() {
        if (this.javaDocScanner == null) {
            this.javaDocScanner = new JETTemplateJavaDocScanner(this.getColorManager(), this.store);
        }
        return this.javaDocScanner;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.jetEditor != null && this.jetEditor.isEditable()) {
            JETReconcilingStrategy strategy = new JETReconcilingStrategy(sourceViewer, this.jetEditor);
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = (PresentationReconciler)super.getPresentationReconciler(sourceViewer);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getJSPScriptletScanner());
        reconciler.setDamager((IPresentationDamager)dr, "jet_scriptlet");
        reconciler.setRepairer((IPresentationRepairer)dr, "jet_scriptlet");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getJSPExpressionScanner());
        reconciler.setDamager((IPresentationDamager)dr, "jet_expression");
        reconciler.setRepairer((IPresentationRepairer)dr, "jet_expression");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getJSPDirectiveScanner());
        reconciler.setDamager((IPresentationDamager)dr, "jet_directive");
        reconciler.setRepairer((IPresentationRepairer)dr, "jet_directive");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getJavaStringDirectiveScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getJavaStringDirectiveScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_character");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_character");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getJavaMultiLineCommentDirectiveScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getJavaSingleLineCommentDirectiveScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getJavaDocDirectiveScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_javadoc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_javadoc");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        char[] scriptletChars = this.store.getString("content_assist_autoactivation_triggers_java").toCharArray();
        if (this.getEditor() != null) {
            ContentAssistant assistant = new ContentAssistant();
            assistant.setContentAssistProcessor((IContentAssistProcessor)new JETTemplateDirectiveCompletionProcessor(), "jet_directive");
            JETTemplateCompletionProcessor jetProcessor = new JETTemplateCompletionProcessor(this.jetEditor);
            jetProcessor.setCompletionProposalAutoActivationCharacters(scriptletChars);
            assistant.setContentAssistProcessor((IContentAssistProcessor)jetProcessor, "jet_scriptlet");
            assistant.setContentAssistProcessor((IContentAssistProcessor)jetProcessor, "jet_expression");
            assistant.setContentAssistProcessor((IContentAssistProcessor)jetProcessor, "__java_javadoc");
            assistant.setContentAssistProcessor((IContentAssistProcessor)jetProcessor, "__java_string");
            assistant.setContentAssistProcessor((IContentAssistProcessor)jetProcessor, "__java_multiline_comment");
            assistant.setContentAssistProcessor((IContentAssistProcessor)jetProcessor, "__java_singleline_comment");
            assistant.setContentAssistProcessor((IContentAssistProcessor)jetProcessor, "__java_character");
            ContentAssistPreference.configure((ContentAssistant)assistant, (IPreferenceStore)this.store);
            assistant.setContextInformationPopupOrientation(20);
            assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            assistant.enableAutoInsert(false);
            assistant.enableAutoActivation(true);
            return assistant;
        }
        return null;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("jet_directive".equals(contentType) || "jet_expression".equals(contentType) || "jet_scriptlet".equals(contentType)) {
            return new IAutoEditStrategy[]{new JETTemplateAutoEditStrategy()};
        }
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = (InformationPresenter)super.getInformationPresenter(sourceViewer);
        JavaInformationProvider provider = new JavaInformationProvider((IEditorPart)this.jetEditor);
        presenter.setInformationProvider((IInformationProvider)provider, "jet_scriptlet");
        return presenter;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return super.getTextHover(sourceViewer, contentType, stateMask);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (contentType == "jet_scriptlet") {
            JETTemplateScriptletHover hover = new JETTemplateScriptletHover(this.jetEditor);
            return hover;
        }
        return super.getTextHover(sourceViewer, contentType);
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getUndoManager(sourceViewer);
        }
        int undoHistorySize = Math.max(25, this.fPreferenceStore.getInt("undoHistorySize"));
        return new DefaultUndoManager(undoHistorySize);
    }
}

