/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.batch.application;

import org.eclipse.egf.batch.application.FactoryComponentRunnerWorkbenchAdvisor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class FactoryComponentRunnerApplication
implements IApplication {
    public static final String FACTORY_COMPONENT_ID = "-factoryComponentId";

    public Object start(IApplicationContext context_p) throws Exception {
        String[] args = (String[])context_p.getArguments().get("application.args");
        return this.run(args);
    }

    public Object run(String[] args_p) {
        String factoryComponentId = this.getFactoryComponentId(args_p);
        if (factoryComponentId == null || factoryComponentId.length() == 0) {
            return new Integer(-1);
        }
        Display display = PlatformUI.createDisplay();
        try {
            FactoryComponentRunnerWorkbenchAdvisor workbenchAdvisor = new FactoryComponentRunnerWorkbenchAdvisor();
            workbenchAdvisor.setExecutedFactoryComponentId(factoryComponentId);
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)workbenchAdvisor);
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    private String getFactoryComponentId(String[] args_p) {
        String result = null;
        int i = 0;
        while (i < args_p.length && result == null) {
            String argument = args_p[i];
            if (argument.equals(FACTORY_COMPONENT_ID)) {
                result = args_p[++i];
            }
            ++i;
        }
        return result;
    }
}

