/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ecore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.log4j.Logger;
import org.eclipse.egf.common.helper.IDGeneratorHelper;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ecore.grammar.PatternLanguageLexer;
import org.eclipse.egf.pattern.ecore.grammar.PatternLanguageParser;
import org.eclipse.egf.pattern.production.jet.JETConstants;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHandler {
    private static final Logger __logger = Logger.getLogger((String)AnnotationHandler.class.getPackage().getName());
    protected static final String JAVA_CODE_SUPER_CALL_PREFIX = "super.";
    protected static final String JAVA_CODE_READ_FILE_CALL_PREFIX = "org.eclipse.egf.pattern.production.template.TemplateHelper.readTemplateFile";
    protected static final String JAVA_CODE_CREATE_STRING_BUILDER = "StringBuilder builder = new StringBuilder();";
    protected static final String JAVA_CODE_APPEND_TO_STRING_BUILDER = "builder.append";
    protected static final String JAVA_CODE_GET_STRING_BUILDER_RESULT = "return builder.toString();";
    protected static final String OPERATION_ANNOTATION_BODY = "body";
    protected static final String UID_ANNOTATION_SOURCE = "http://www.eclipse.org/egf/1.0.0/uid";
    protected static final String JAVA_CODE_ANNOTATION_SOURCE = "http://www.eclipse.org/emf/2002/GenModel";
    public static final String PATTERN_CODE_ANNOTATION_SOURCE = "http://www.eclipse.org/egf/1.0.0/Pattern";
    public static final String PATTERN_PRODUCTION_ANNOTATION_SOURCE = "http://www.eclipse.org/egf/1.0.0/Pattern/production";
    public static final String PATTERN_PRODUCTION_ANNOTATION_BODY_PATH = "Path";
    public static final String PATTERN_PRODUCTION_ANNOTATION_BODY_COMPILATION = "Compilation";
    public static final String PATTERN_PRODUCTION_ANNOTATION_BODY_BUFFER_MODIFICATION = "BufferModification";
    protected static final String PATTERN_METHOD_ID_PREFIX = "PatternMethod";

    protected CommonTree getTree(String patternCode_p) {
        CommonTree result = null;
        PatternLanguageLexer lexer = new PatternLanguageLexer((CharStream)new ANTLRStringStream(patternCode_p));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PatternLanguageParser parser = new PatternLanguageParser((TokenStream)tokens);
        try {
            result = (CommonTree)parser.call().getTree();
        }
        catch (RecognitionException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("AnnotationHandler.getTree(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return result;
    }

    public List<Couple<String, String>> getOrderedActionsFor(EOperation operation_p) {
        ArrayList<Couple<String, String>> actions = new ArrayList<Couple<String, String>>(0);
        if (operation_p == null) {
            return actions;
        }
        String patternCode = this.getPatternCode(operation_p);
        if (patternCode == null) {
            return actions;
        }
        CommonTree tree = this.getTree(patternCode);
        this.explore((Tree)tree, actions);
        return actions;
    }

    public List<String> getCalledPatternIDs(EOperation operation_p) {
        if (operation_p == null) {
            return Collections.EMPTY_LIST;
        }
        List<Couple<String, String>> orderedActions = this.getOrderedActionsFor(operation_p);
        ArrayList<String> result = new ArrayList<String>(0);
        for (Couple<String, String> action : orderedActions) {
            if (!"PATTERN".equals(action.getKey())) continue;
            result.add((String)action.getValue());
        }
        return result;
    }

    public void replaceParameter(String oldParameterValue_p, String newParameterValue_p, List<Couple<String, String>> actions_p) {
        if (actions_p == null || oldParameterValue_p == null || newParameterValue_p == null) {
            return;
        }
        for (Couple<String, String> action : actions_p) {
            if (!oldParameterValue_p.equals(action.getValue())) continue;
            action.setValue((Object)newParameterValue_p);
        }
    }

    public List<Couple<String, String>> removeActionsFor(String parameterValue_p, List<Couple<String, String>> actions_p) {
        if (parameterValue_p == null || actions_p == null || actions_p.isEmpty()) {
            return null;
        }
        ArrayList<Couple<String, String>> clonedActions = new ArrayList<Couple<String, String>>(0);
        clonedActions.addAll(actions_p);
        for (Couple couple : clonedActions) {
            if (!parameterValue_p.equals(couple.getValue())) continue;
            actions_p.remove(couple);
        }
        clonedActions.removeAll(actions_p);
        return clonedActions;
    }

    public void recomputeAnnotationFromActions(EOperation operation_p, List<Couple<String, String>> actions_p) {
        if (operation_p == null || actions_p == null) {
            return;
        }
        List<EAnnotation> keptAnnotations = Collections.singletonList(operation_p.getEAnnotation(UID_ANNOTATION_SOURCE));
        operation_p.getEAnnotations().retainAll(keptAnnotations);
        for (Couple<String, String> action : actions_p) {
            String actionType = (String)action.getKey();
            String actionParameter = (String)action.getValue();
            if ("CALL".equals(actionType)) {
                this.addCallMethodPatternCode(operation_p, actionParameter);
                continue;
            }
            if ("PATTERN".equals(actionType)) {
                this.addGenerateOtherPatternPatternCode(operation_p, actionParameter);
                continue;
            }
            if ("READ".equals(actionType)) {
                this.addReadFilePatternCode(operation_p, actionParameter);
                continue;
            }
            if (!"SUPER".equals(actionType)) continue;
            this.addSuperMethodCallPatternCode(operation_p, actionParameter);
        }
    }

    public String addUidAnnotation(EOperation operation_p) {
        String result = null;
        if (operation_p == null) {
            return result;
        }
        EAnnotation annotation = operation_p.getEAnnotation(UID_ANNOTATION_SOURCE);
        if (annotation == null) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            operation_p.getEAnnotations().add((Object)annotation);
            annotation.setSource(UID_ANNOTATION_SOURCE);
        }
        result = IDGeneratorHelper.generatePrefixUID((String)PATTERN_METHOD_ID_PREFIX);
        annotation.getDetails().put((Object)OPERATION_ANNOTATION_BODY, (Object)result);
        return result;
    }

    public boolean addProductionAnnotation(Pattern pattern_p, PatternHandler.ProductionOptionsHandler productionHandler_p) {
        boolean result = false;
        if (pattern_p == null || productionHandler_p == null) {
            return result;
        }
        EAnnotation annotation = pattern_p.getEAnnotation(PATTERN_PRODUCTION_ANNOTATION_SOURCE);
        if (annotation == null) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource(PATTERN_PRODUCTION_ANNOTATION_SOURCE);
            pattern_p.getEAnnotations().add((Object)annotation);
        }
        EMap details = annotation.getDetails();
        details.put((Object)PATTERN_PRODUCTION_ANNOTATION_BODY_PATH, (Object)productionHandler_p.getPatternTemplatePath());
        details.put((Object)PATTERN_PRODUCTION_ANNOTATION_BODY_COMPILATION, (Object)Boolean.toString(productionHandler_p.shouldCompileTemplate()));
        details.put((Object)PATTERN_PRODUCTION_ANNOTATION_BODY_BUFFER_MODIFICATION, (Object)Boolean.toString(productionHandler_p.shouldModifyBuffer()));
        result = true;
        return result;
    }

    public EAnnotation removeProductionAnnotation(Pattern pattern_p) {
        EAnnotation result = null;
        if (pattern_p == null) {
            return result;
        }
        result = pattern_p.getEAnnotation(PATTERN_PRODUCTION_ANNOTATION_SOURCE);
        if (result != null) {
            pattern_p.getEAnnotations().remove((Object)result);
        }
        return result;
    }

    public String getUid(EOperation operation_p) {
        String result = null;
        if (operation_p == null) {
            return result;
        }
        EAnnotation uidAnnotation = operation_p.getEAnnotation(UID_ANNOTATION_SOURCE);
        if (uidAnnotation != null) {
            result = (String)uidAnnotation.getDetails().get((Object)OPERATION_ANNOTATION_BODY);
        }
        return result;
    }

    protected Couple<String, String> getActionAndParameter(Tree tree_p) {
        if (tree_p == null) {
            return null;
        }
        String actionType = tree_p.getText();
        String actionParameter = this.getFirstChild(tree_p);
        return new Couple((Object)actionType, (Object)actionParameter);
    }

    protected void explore(Tree tree_p, List<Couple<String, String>> actions_p) {
        Couple<String, String> currentAction = this.getActionAndParameter(tree_p);
        if (currentAction == null) {
            return;
        }
        String actionType = (String)currentAction.getKey();
        if ("CALL".equals(actionType) || "SUPER".equals(actionType) || "READ".equals(actionType) || "PATTERN".equals(actionType)) {
            actions_p.add(currentAction);
        } else {
            int childCount = tree_p.getChildCount();
            int i = 0;
            while (i < childCount) {
                this.explore(tree_p.getChild(i), actions_p);
                ++i;
            }
        }
    }

    public boolean translateAnnotations(List<EOperation> operations_p) {
        boolean result = true;
        if (operations_p == null || operations_p.isEmpty()) {
            return result;
        }
        for (EOperation operation : operations_p) {
            result &= this.doTranslateAnnotation(operation);
        }
        return result;
    }

    public boolean hasPatternCode(EOperation operation_p) {
        return this.getPatternCode(operation_p) != null;
    }

    protected boolean doTranslateAnnotation(EOperation operation_p) {
        boolean result = true;
        String patternCode = this.getPatternCode(operation_p);
        if (patternCode == null) {
            return result;
        }
        this.initializeJavaCode(operation_p);
        CommonTree tree = this.getTree(patternCode);
        if (tree != null) {
            this.exploreAndTranslate((Tree)tree, operation_p);
        }
        this.finalizeJavaCode(operation_p);
        return result;
    }

    protected void exploreAndTranslate(Tree tree_p, EOperation operation_p) {
        Couple<String, String> action = this.getActionAndParameter(tree_p);
        if (action == null) {
            return;
        }
        String actionType = (String)action.getKey();
        String actionParameter = (String)action.getValue();
        if ("CALL".equals(actionType)) {
            this.addCallMethodJavaCode(operation_p, actionParameter);
        } else if ("SUPER".equals(actionType)) {
            this.addSuperMethodCallJavaCode(operation_p, actionParameter);
        } else if ("READ".equals(actionType)) {
            this.addReadFileJavaCode(operation_p, actionParameter);
        } else if ("PATTERN".equals(actionType)) {
            this.addGenerateOtherPatternJavaCode(operation_p, actionParameter);
        } else {
            int childCount = tree_p.getChildCount();
            int i = 0;
            while (i < childCount) {
                this.exploreAndTranslate(tree_p.getChild(i), operation_p);
                ++i;
            }
        }
    }

    protected String getFirstChild(Tree tree_p) {
        String result = null;
        if (tree_p != null && tree_p.getChildCount() > 0) {
            result = tree_p.getChild(0).getText();
        }
        return result;
    }

    protected String getPatternCode(EOperation operation_p) {
        EAnnotation patternCodeAnnotation = this.getOrCreatePatternCodeAnnotation(operation_p, false);
        if (patternCodeAnnotation == null) {
            return null;
        }
        return (String)patternCodeAnnotation.getDetails().get((Object)OPERATION_ANNOTATION_BODY);
    }

    protected void initializeJavaCode(EOperation operation_p) {
        if (operation_p == null) {
            return;
        }
        new UnbufferedJavaCodeAppender(){

            protected EAnnotation getCodeAnnotation(EOperation operation) {
                EAnnotation javaCodeAnnotation = operation.getEAnnotation(AnnotationHandler.JAVA_CODE_ANNOTATION_SOURCE);
                operation.getEAnnotations().remove((Object)javaCodeAnnotation);
                return super.getCodeAnnotation(operation);
            }

            protected void appendNewOperation(StringBuilder existingCode_p) {
                existingCode_p.append(AnnotationHandler.JAVA_CODE_CREATE_STRING_BUILDER);
            }
        }.appendCode(operation_p);
    }

    protected void finalizeJavaCode(EOperation operation_p) {
        if (operation_p == null) {
            return;
        }
        new UnbufferedJavaCodeAppender(){

            protected void appendNewOperation(StringBuilder existingCode_p) {
                existingCode_p.append(AnnotationHandler.JAVA_CODE_GET_STRING_BUILDER_RESULT);
            }
        }.appendCode(operation_p);
    }

    public void addGenerateOtherPatternPatternCode(EOperation operation_p, final String patternFullId_p) {
        if (operation_p == null || patternFullId_p == null) {
            return;
        }
        new PatternCodeAppender(){

            protected String getOperationName() {
                return "PATTERN";
            }

            protected String getParameter() {
                return patternFullId_p;
            }
        }.appendCode(operation_p);
    }

    protected void addGenerateOtherPatternJavaCode(EOperation operation_p, final String patternFullId_p) {
        if (operation_p == null || patternFullId_p == null) {
            return;
        }
        new JavaCodeAppender(){

            protected void appendNewOperation(StringBuilder existingCode_p) {
                existingCode_p.append(JETConstants.EXTERNAL_USE_JET_MARKUP_START);
            }
        }.appendCode(operation_p);
        new JavaCodeAppender(){

            protected void appendNewOperation(StringBuilder existingCode_p) {
                existingCode_p.append('\"').append("stringBuffer.append").append('(');
                existingCode_p.append(AnnotationHandler.this.getCallOtherPatternTemplateCode(patternFullId_p)).append(')');
                existingCode_p.append(';').append('\"');
            }
        }.appendCode(operation_p);
        new JavaCodeAppender(){

            protected void appendNewOperation(StringBuilder existingCode_p) {
                existingCode_p.append(JETConstants.EXTERNAL_USE_JET_MARKUP_END);
            }
        }.appendCode(operation_p);
    }

    protected String getCallOtherPatternTemplateCode(String patternFullId_p) {
        return StringHelper.formatMessage((String)"org.eclipse.egf.pattern.execution.PatternExecutionHelper.invokePattern(\\\"{0}\\\", argument)", (Object[])new Object[]{patternFullId_p});
    }

    public void addReadFilePatternCode(EOperation operation_p, final String fileRelativePath_p) {
        if (operation_p == null || fileRelativePath_p == null) {
            return;
        }
        new PatternCodeAppender(){

            protected String getOperationName() {
                return "READ";
            }

            protected String getParameter() {
                return fileRelativePath_p;
            }
        }.appendCode(operation_p);
    }

    protected void addReadFileJavaCode(EOperation operation_p, final String fileRelativePath_p) {
        if (operation_p == null || fileRelativePath_p == null) {
            return;
        }
        new JavaCodeAppender(){

            protected void appendNewOperation(StringBuilder existingCode_p) {
                existingCode_p.append(AnnotationHandler.JAVA_CODE_READ_FILE_CALL_PREFIX).append('(');
                existingCode_p.append('\"').append(fileRelativePath_p).append('\"');
                existingCode_p.append(')');
            }
        }.appendCode(operation_p);
    }

    public void addCallMethodPatternCode(EOperation operation_p, final String methodName_p) {
        if (operation_p == null || methodName_p == null) {
            return;
        }
        new PatternCodeAppender(){

            protected String getOperationName() {
                return "CALL";
            }

            protected String getParameter() {
                return methodName_p;
            }
        }.appendCode(operation_p);
    }

    protected void addCallMethodJavaCode(EOperation operation_p, final String methodName_p) {
        if (operation_p == null || methodName_p == null) {
            return;
        }
        new JavaCodeAppender(){

            protected void appendNewOperation(StringBuilder existingCode_p) {
                existingCode_p.append(methodName_p).append('(').append(')');
            }
        }.appendCode(operation_p);
    }

    public void addSuperMethodCallPatternCode(EOperation operation_p, final String methodName_p) {
        if (operation_p == null) {
            return;
        }
        new PatternCodeAppender(){

            protected String getOperationName() {
                return "SUPER";
            }

            protected String getParameter() {
                return methodName_p;
            }
        }.appendCode(operation_p);
    }

    protected void addSuperMethodCallJavaCode(EOperation operation_p, String methodName_p) {
        if (operation_p == null) {
            return;
        }
        final String[] methodName = new String[]{methodName_p};
        final ArrayList parametersList = new ArrayList(0);
        if (methodName_p == null) {
            methodName[0] = operation_p.getName();
            parametersList.addAll(operation_p.getEParameters());
        }
        new JavaCodeAppender(){

            protected void appendNewOperation(StringBuilder existingCode_p) {
                existingCode_p.append(AnnotationHandler.JAVA_CODE_SUPER_CALL_PREFIX).append(methodName[0]).append('(');
                Iterator parameters = parametersList.iterator();
                while (parameters.hasNext()) {
                    existingCode_p.append(((EParameter)parameters.next()).getName());
                    if (!parameters.hasNext()) continue;
                    existingCode_p.append(',');
                }
                existingCode_p.append(')');
            }
        }.appendCode(operation_p);
    }

    protected EAnnotation getOrCreateJavaCodeAnnotation(EOperation operation_p) {
        return this.getOrCreateAnnotation(operation_p, JAVA_CODE_ANNOTATION_SOURCE, true);
    }

    protected EAnnotation getOrCreatePatternCodeAnnotation(EOperation operation_p, boolean forceCreation_p) {
        return this.getOrCreateAnnotation(operation_p, PATTERN_CODE_ANNOTATION_SOURCE, forceCreation_p);
    }

    protected EAnnotation getOrCreateAnnotation(EOperation operation_p, String sourceAnnotation_p, boolean forceCreation_p) {
        EAnnotation result = null;
        if (operation_p == null && sourceAnnotation_p == null) {
            return result;
        }
        result = operation_p.getEAnnotation(sourceAnnotation_p);
        if (result == null && forceCreation_p) {
            result = EcoreFactory.eINSTANCE.createEAnnotation();
            result.setSource(sourceAnnotation_p);
            operation_p.getEAnnotations().add((Object)result);
        }
        return result;
    }

    protected void doAppendPatternCode(String operationName_p, String parameter_p, StringBuilder existingCode_p) {
        if (operationName_p == null || existingCode_p == null) {
            return;
        }
        existingCode_p.append(operationName_p);
        existingCode_p.append('(');
        if (parameter_p != null) {
            existingCode_p.append(parameter_p);
        }
        existingCode_p.append(')').append(';');
    }

    protected abstract class AnnotationCodeAppender {
        protected AnnotationCodeAppender() {
        }

        public void appendCode(EOperation operation_p) {
            EAnnotation annotation = this.getCodeAnnotation(operation_p);
            String existingContent = (String)annotation.getDetails().get((Object)AnnotationHandler.OPERATION_ANNOTATION_BODY);
            StringBuilder resultingCode = null;
            resultingCode = existingContent != null ? new StringBuilder(existingContent) : new StringBuilder();
            this.doAppendCode(resultingCode);
            annotation.getDetails().put((Object)AnnotationHandler.OPERATION_ANNOTATION_BODY, (Object)resultingCode.toString());
        }

        protected abstract EAnnotation getCodeAnnotation(EOperation var1);

        protected abstract void doAppendCode(StringBuilder var1);
    }

    protected abstract class JavaCodeAppender
    extends AnnotationCodeAppender {
        protected JavaCodeAppender() {
        }

        protected void doAppendCode(StringBuilder existingCode_p) {
            existingCode_p.append(AnnotationHandler.JAVA_CODE_APPEND_TO_STRING_BUILDER).append('(');
            this.appendNewOperation(existingCode_p);
            existingCode_p.append(')').append(';').append('\n');
        }

        protected EAnnotation getCodeAnnotation(EOperation operation_p) {
            return AnnotationHandler.this.getOrCreateJavaCodeAnnotation(operation_p);
        }

        protected abstract void appendNewOperation(StringBuilder var1);
    }

    protected abstract class PatternCodeAppender
    extends AnnotationCodeAppender {
        protected PatternCodeAppender() {
        }

        protected void doAppendCode(StringBuilder existingCode_p) {
            AnnotationHandler.this.doAppendPatternCode(this.getOperationName(), this.getParameter(), existingCode_p);
        }

        protected EAnnotation getCodeAnnotation(EOperation operation_p) {
            return AnnotationHandler.this.getOrCreatePatternCodeAnnotation(operation_p, true);
        }

        protected abstract String getOperationName();

        protected abstract String getParameter();
    }

    protected abstract class UnbufferedJavaCodeAppender
    extends JavaCodeAppender {
        protected UnbufferedJavaCodeAppender() {
        }

        protected void doAppendCode(StringBuilder existingCode_p) {
            this.appendNewOperation(existingCode_p);
            existingCode_p.append('\n');
        }
    }
}

