/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ecore.condition;

import java.util.Iterator;
import java.util.List;
import org.eclipse.egf.common.helper.EcoreHelper;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ecore.condition.AbstractPatternCondition;
import org.eclipse.egf.pattern.production.GeneratedContentProducer;
import org.eclipse.egf.pattern.relations.ParameterRelation;
import org.eclipse.emf.ecore.EPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedConditionProducer {
    protected static final String CHECK_METHOD_IMPL_DEFAULT_IMPL = ") {\n// begin-user-code\nreturn true;\n// end-user-code\n}\n}";
    protected static final String CHECK_METHOD_IMPL_SIGNATURE_PREFIX = "protected boolean check(";
    protected static final String CHECK_METHOD_IMPL_DEFAULT_COMMENTS = "/**\n* Check method user implementation.<br>\n* User must implement and comment between delimiters only !\n* Public signature and comments are lost when a merge is performed.\n* @unmodifiable\n*/\n";
    protected static final String PARAMETER_N_PREFIX = "parameters_p[";
    protected static final String GENERIC_CHECK_METHOD_END = ");\n}\n\n";
    protected static final String CHECK_METHOD_CALL_PREFIX = "return check(";
    protected static final String GENERIC_CHECK_METHOD_COMMENTS = "/**\n* Generated check method.<br>\n* User should left this code untouched for it is lost when a merge is performed.\n* @unmodifiable\n*/\n";
    protected static final String GENERIC_CHECK_METHOD_SIGNATURE = "public boolean check(Object... parameters_p) {\n";
    protected static final String DEFAULT_CONDITION_IMPLEMENTATION = " extends " + AbstractPatternCondition.class.getSimpleName() + " {\n";
    protected static final String CLASS_COMMENTS = "/**\n*Condition class implementation.\n*A merge occurs each time the corresponding pattern parameters are changed.\n*Both check methods are subject to merge (see associated comments).\n*Any other method is left untouched as a result of the merging operation.\n*/\n";
    protected static final String CLASS_DECLARATION_PREFIX = "public class ";
    protected static final String DEFAULT_CONDITION_IMPORT = String.valueOf(AbstractPatternCondition.class.getName()) + ";\n\n";
    protected static final String IMPORT_DIRECTIVE_PREFIX = "import ";
    protected static final String IMPORT_DIRECTIVE_SUFFIX = ";\n";
    protected static final String PACKAGE_DECLARATION_PREFIX = "package ";
    protected static final char SQUARE_BRACKET_CLOSING_CHARACTER = ']';

    public static String getNewConditionClassDefaultContent(PatternHandler.PatternData patternData_p, List<ParameterRelation> parameters_p) {
        StringBuilder result = new StringBuilder();
        result.append(PACKAGE_DECLARATION_PREFIX).append("org.eclipse.egf.condition");
        result.append(';').append('\n').append('\n');
        for (ParameterRelation parameterRelation : parameters_p) {
            EPackage parameterPackage = parameterRelation.getType().getEPackage();
            String packageImportedName = EcoreHelper.getImportedPackageName((EPackage)parameterPackage);
            if (packageImportedName == null) continue;
            result.append(IMPORT_DIRECTIVE_PREFIX).append(packageImportedName).append('.').append(parameterRelation.getType().getName()).append(IMPORT_DIRECTIVE_SUFFIX);
        }
        result.append('\n');
        result.append(IMPORT_DIRECTIVE_PREFIX).append(DEFAULT_CONDITION_IMPORT);
        String className = GeneratedContentProducer.getConditionClassName(patternData_p);
        result.append(CLASS_COMMENTS);
        result.append(CLASS_DECLARATION_PREFIX).append(className).append(DEFAULT_CONDITION_IMPLEMENTATION);
        result.append(GENERIC_CHECK_METHOD_COMMENTS);
        result.append(GENERIC_CHECK_METHOD_SIGNATURE);
        result.append(CHECK_METHOD_CALL_PREFIX);
        int i = 0;
        StringBuilder realImplSignature = new StringBuilder();
        Iterator<ParameterRelation> parameters = parameters_p.iterator();
        while (parameters.hasNext()) {
            ParameterRelation param = parameters.next();
            String paramTypeName = param.getType().getName();
            result.append('(').append(paramTypeName).append(')');
            result.append(PARAMETER_N_PREFIX).append(i).append(']');
            realImplSignature.append(paramTypeName).append(' ').append(param.getName());
            if (parameters.hasNext()) {
                result.append(',');
                realImplSignature.append(',');
            }
            ++i;
        }
        result.append(GENERIC_CHECK_METHOD_END);
        result.append(CHECK_METHOD_IMPL_DEFAULT_COMMENTS);
        result.append(CHECK_METHOD_IMPL_SIGNATURE_PREFIX).append(realImplSignature.toString()).append(CHECK_METHOD_IMPL_DEFAULT_IMPL);
        return result.toString();
    }
}

