/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.fprod.producer.internal.invocation;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.fprod.producer.context.ITaskProductionContext;
import org.eclipse.egf.fprod.producer.invocation.ITaskProduction;
import org.eclipse.egf.fprod.producer.invocation.ITaskProductionInvocation;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ProductionTaskInvocation
implements ITaskProductionInvocation {
    private Bundle _bundle;
    private ITaskProductionContext _taskProductionContext;
    private String _value;

    public ProductionTaskInvocation(Bundle bundle, ITaskProductionContext taskProductionContext, String value) {
        Assert.isNotNull((Object)bundle);
        Assert.isNotNull((Object)taskProductionContext);
        this._bundle = bundle;
        this._taskProductionContext = taskProductionContext;
        this._value = value;
    }

    protected ITaskProduction createProductionInvocationInstance() throws CoreException {
        ITaskProduction productionTask = null;
        if (this._value == null) {
            return null;
        }
        try {
            productionTask = (ITaskProduction)BundleHelper.instantiate((String)this._value.trim(), (Bundle)this._bundle);
        }
        catch (ClassNotFoundException cnfe) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.AbstractTask_errorTaskInstance, (Object)this._value), (Throwable)cnfe));
        }
        catch (InstantiationException ie) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.AbstractTask_errorTaskInstance, (Object)this._value), (Throwable)ie));
        }
        catch (IllegalAccessException iae) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.AbstractTask_errorTaskInstance, (Object)this._value), (Throwable)iae));
        }
        return productionTask;
    }

    public void invoke(IProgressMonitor monitor) throws InvocationException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)EGFCoreMessages.Production_Invoke, (Object)this._taskProductionContext.getName()), (int)1000);
        try {
            ITaskProduction task = null;
            try {
                task = this.createProductionInvocationInstance();
            }
            catch (CoreException ce) {
                throw new InvocationException((Throwable)ce);
            }
            if (task == null) {
                return;
            }
            subMonitor.worked(100);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            task.preExecute(this._taskProductionContext, (IProgressMonitor)subMonitor.newChild(100, 0));
            subMonitor.worked(100);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            task.doExecute(this._taskProductionContext, (IProgressMonitor)subMonitor.newChild(700, 0));
            subMonitor.worked(700);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            task.postExecute(this._taskProductionContext, (IProgressMonitor)subMonitor.newChild(100, 0));
            subMonitor.worked(100);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        finally {
            subMonitor.done();
        }
    }
}

