/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.manager;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.helper.BundleSessionHelper;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.context.IModelElementProductionContext;
import org.eclipse.egf.producer.internal.context.ModelElementProductionContext;
import org.eclipse.egf.producer.l10n.ProducerMessages;
import org.eclipse.egf.producer.manager.IModelElementManager;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelElementManager
implements IModelElementManager {
    private ModelElement _element;
    protected IModelElementManager _parent;
    protected IModelElementProductionContext<?> _productionContext;
    private Bundle _bundle;
    private ProjectBundleSession _projectBundleSession;
    private IPlatformFcore _platformFcore;

    protected static BasicDiagnostic getDiagnostic(ModelElement element) {
        String message = null;
        message = element.getName() != null && element.getName().trim().length() != 0 ? NLS.bind((String)ProducerMessages._UI_CanInvoke_Diagnosis_message, (Object)element.getName()) : NLS.bind((String)ProducerMessages._UI_CanInvoke_Diagnosis_message, (Object)element.eClass().getName());
        return new BasicDiagnostic(EGFProducerPlugin.getDefault().getPluginID(), 0, message, new Object[]{element});
    }

    public ModelElementManager(ModelElement element) throws InvocationException {
        Assert.isNotNull((Object)element);
        this._element = element;
        this._platformFcore = EGFCorePlugin.getPlatformFcore((Resource)element.eResource());
        if (this._platformFcore == null) {
            throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)ProducerMessages.ActivityManager_fcore_activity, (Object)this.getName()), null)));
        }
    }

    public ModelElementManager(Bundle bundle, ModelElement element) {
        Assert.isNotNull((Object)bundle);
        Assert.isNotNull((Object)element);
        this._bundle = bundle;
        this._element = element;
    }

    public ModelElementManager(IModelElementManager parent, ModelElement element) throws InvocationException {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)element);
        this._parent = parent;
        this._element = element;
        this._platformFcore = EGFCorePlugin.getPlatformFcore((Resource)element.eResource());
        if (this._platformFcore == null) {
            throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)ProducerMessages.ActivityManager_fcore_activity, (Object)this.getName()), null)));
        }
    }

    @Override
    public ModelElement getElement() {
        return this._element;
    }

    @Override
    public IModelElementProductionContext<?> getProductionContext() throws InvocationException {
        return this.getInternalProductionContext();
    }

    @Override
    public IModelElementManager getParent() {
        return this._parent;
    }

    protected abstract ModelElementProductionContext<?> getInternalProductionContext() throws InvocationException;

    @Override
    public String getName() {
        return EMFHelper.getText((Object)this.getElement());
    }

    public Bundle getBundle() throws InvocationException {
        if (this._platformFcore != null) {
            try {
                return BundleSessionHelper.getBundle((ProjectBundleSession)this.getProjectBundleSession(), (IPlatformExtensionPoint)this._platformFcore);
            }
            catch (Throwable t) {
                throw new InvocationException(t);
            }
        }
        if (this.getParent() != null) {
            return this.getParent().getBundle();
        }
        return this._bundle;
    }

    public ProjectBundleSession getProjectBundleSession() {
        if (this.getParent() != null) {
            return this.getParent().getProjectBundleSession();
        }
        if (this._projectBundleSession == null) {
            this._projectBundleSession = new ProjectBundleSession(EGFProducerPlugin.getDefault().getBundle().getBundleContext());
        }
        return this._projectBundleSession;
    }

    protected BasicDiagnostic canInvokeElement() throws InvocationException {
        return ModelElementManager.getDiagnostic(this.getElement());
    }

    public Diagnostic canInvoke() throws InvocationException {
        return this.canInvokeElement();
    }

    public abstract void initializeContext() throws InvocationException;

    public void dispose() throws InvocationException {
        if (this._projectBundleSession != null) {
            try {
                this._projectBundleSession.dispose();
            }
            catch (Throwable t) {
                throw new InvocationException(t);
            }
        }
    }
}

