/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.pde;

import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginElement;

public abstract class PlatformExtensionPoint
implements IPlatformExtensionPoint {
    private IPluginElement _element;
    private IPlatformBundle _bundle;
    private String _id;

    public PlatformExtensionPoint(IPlatformBundle bundle, IPluginElement element, String id) {
        Assert.isNotNull((Object)bundle);
        Assert.isNotNull((Object)bundle.getPluginModelBase());
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)element.getPluginModel());
        Assert.isLegal((boolean)bundle.getPluginModelBase().equals(element.getPluginModel()));
        Assert.isNotNull((Object)id);
        Assert.isLegal((id.trim().length() > 0 ? 1 : 0) != 0);
        this._bundle = bundle;
        this._element = element;
        this._id = id.trim();
    }

    public String getId() {
        return this._id;
    }

    public IPluginElement getPluginElement() {
        return this._element;
    }

    public IPlatformBundle getPlatformBundle() {
        return this._bundle;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IPlatformExtensionPoint)) {
            return false;
        }
        IPlatformExtensionPoint platformExtensionPoint = (IPlatformExtensionPoint)object;
        if (platformExtensionPoint.getPlatformBundle().equals(this.getPlatformBundle())) {
            return this.toString().compareTo(platformExtensionPoint.toString()) == 0;
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }
}

