/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.test.context.task.memory;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.test.EGFCoreTestPlugin;
import org.eclipse.egf.fprod.producer.manager.ITaskManager;
import org.eclipse.egf.fprod.producer.manager.TaskManagerFactory;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.fprod.FprodFactory;
import org.eclipse.egf.model.fprod.FprodPackage;
import org.eclipse.egf.model.fprod.Task;
import org.eclipse.egf.model.fprod.TaskContract;
import org.eclipse.egf.model.fprod.TaskContractContainer;
import org.eclipse.egf.model.types.TypeCollection;
import org.eclipse.egf.model.types.TypeFloat;
import org.eclipse.egf.model.types.TypeGeneratorAdapterFactory;
import org.eclipse.egf.model.types.TypeInteger;
import org.eclipse.egf.model.types.TypesFactory;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.framework.Bundle;

public class ContextTaskMemory
extends TestCase {
    public static Test suite() {
        return new TestSuite(ContextTaskMemory.class);
    }

    public void testContractH1() throws Exception {
        Task task = FprodFactory.eINSTANCE.createTask();
        task.setValue("org.eclipse.egf.example.task.h1.H1");
        ActivityManagerProducer producer = EGFProducerPlugin.getActivityManagerProducer((Activity)task);
        IActivityManager manager = producer.createActivityManager(EGFCoreTestPlugin.getDefault().getBundle(), (Activity)task);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationException invocationException) {
                try {
                    manager.dispose();
                }
                catch (Exception e) {
                    EGFCoreTestPlugin.getDefault().logError(e);
                    ContextTaskMemory.fail((String)e.getMessage());
                    return;
                }
                return;
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextTaskMemory.fail((String)e.getMessage());
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    EGFCoreTestPlugin.getDefault().logError(e2);
                    ContextTaskMemory.fail((String)e2.getMessage());
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextTaskMemory.fail((String)e.getMessage());
                return;
            }
        }
        ContextTaskMemory.fail((String)"InvocationException is expected");
    }

    public void testOutputContractClassNotTheSameH1() throws Exception {
        Task task = FprodFactory.eINSTANCE.createTask();
        task.setValue("org.eclipse.egf.example.task.h1.H1");
        TaskContractContainer contracts = FprodFactory.eINSTANCE.createTaskContractContainer();
        task.eSet((EStructuralFeature)FprodPackage.Literals.TASK__ACTIVITY_CONTRACT_CONTAINER, (Object)contracts);
        TaskContract quantity = FprodFactory.eINSTANCE.createTaskContract();
        quantity.setName("quantity");
        quantity.setMode(ContractMode.IN);
        contracts.getActivityContracts().add((Object)quantity);
        TypeInteger quantityType = TypesFactory.eINSTANCE.createTypeInteger();
        quantityType.setValue(Integer.valueOf(100));
        quantity.eSet((EStructuralFeature)FcorePackage.Literals.ACTIVITY_CONTRACT__TYPE, (Object)quantityType);
        TaskContract price = FprodFactory.eINSTANCE.createTaskContract();
        price.setName("price");
        price.setMode(ContractMode.IN);
        contracts.getActivityContracts().add((Object)price);
        TypeFloat priceType = TypesFactory.eINSTANCE.createTypeFloat();
        priceType.setValue(new Float("10.5"));
        price.eSet((EStructuralFeature)FcorePackage.Literals.ACTIVITY_CONTRACT__TYPE, (Object)priceType);
        TaskContract parameters = FprodFactory.eINSTANCE.createTaskContract();
        parameters.setName("parameters");
        parameters.setMode(ContractMode.IN_OUT);
        contracts.getActivityContracts().add((Object)parameters);
        TypeCollection parametersType = TypesFactory.eINSTANCE.createTypeCollection();
        parametersType.setValue("java.util.ArrayList");
        parameters.eSet((EStructuralFeature)FcorePackage.Literals.ACTIVITY_CONTRACT__TYPE, (Object)parametersType);
        TaskContract amount = FprodFactory.eINSTANCE.createTaskContract();
        amount.setName("amount");
        amount.setMode(ContractMode.OUT);
        contracts.getActivityContracts().add((Object)amount);
        TypeFloat amountType = TypesFactory.eINSTANCE.createTypeFloat();
        amount.eSet((EStructuralFeature)FcorePackage.Literals.ACTIVITY_CONTRACT__TYPE, (Object)amountType);
        TaskContract generatorAdapterFactory = FprodFactory.eINSTANCE.createTaskContract();
        generatorAdapterFactory.setName("generatorAdapterFactory");
        generatorAdapterFactory.setMode(ContractMode.OUT);
        contracts.getActivityContracts().add((Object)generatorAdapterFactory);
        TypeGeneratorAdapterFactory generatorAdapterFactoryType = TypesFactory.eINSTANCE.createTypeGeneratorAdapterFactory();
        generatorAdapterFactoryType.setValue("org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory");
        generatorAdapterFactory.eSet((EStructuralFeature)FcorePackage.Literals.ACTIVITY_CONTRACT__TYPE, (Object)generatorAdapterFactoryType);
        ITaskManager manager = TaskManagerFactory.createProductionManager((Bundle)EGFCoreTestPlugin.getDefault().getBundle(), (Task)task);
        GeneratorAdapterFactory defaultValue = null;
        try {
            try {
                manager.initializeContext();
                defaultValue = (GeneratorAdapterFactory)manager.getProductionContext().getOutputValue((Object)"generatorAdapterFactory", GeneratorAdapterFactory.class);
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextTaskMemory.fail((String)e.getMessage());
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    EGFCoreTestPlugin.getDefault().logError(e2);
                    ContextTaskMemory.fail((String)e2.getMessage());
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextTaskMemory.fail((String)e.getMessage());
                return;
            }
        }
        ContextTaskMemory.assertNotSame((Object)manager.getProductionContext().getOutputValue((Object)"generatorAdapterFactory", GenModelGeneratorAdapterFactory.class), (Object)defaultValue);
    }
}

