/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ecore;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.core.helper.ResourceHelper;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.ProjectClassLoaderHelper;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class EPackageHelper {
    public static final String INSTANCE_FIELD_NAME = "eINSTANCE";
    public static final EPackage.Registry REGISTRY = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
    private static final Map<String, String> nsuri2basePackage = new HashMap<String, String>();

    public static String getBasePackage(EPackage ePackage) {
        String name = nsuri2basePackage.get(ePackage.getNsURI());
        if (name != null) {
            return name;
        }
        String nsURI = ePackage.getNsURI();
        URI uri = (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap().get(nsURI);
        Resource res = EPackageHelper.loadResource(uri);
        for (EObject obj : res.getContents()) {
            if (!(obj instanceof GenModel)) continue;
            GenModel genModel = (GenModel)obj;
            for (GenPackage gPack : genModel.getGenPackages()) {
                EPackage ecorePackage = gPack.getEcorePackage();
                if (!ePackage.getName().equals(ecorePackage.getName()) || !ePackage.getNsPrefix().equals(ecorePackage.getNsPrefix()) || !ePackage.getNsURI().equals(ecorePackage.getNsURI())) continue;
                nsuri2basePackage.put(ePackage.getNsURI(), gPack.getBasePackage());
                return gPack.getBasePackage();
            }
        }
        return null;
    }

    public static void unregisterPackage(IProject project, String classname) throws RegistrationException {
        try {
            Class<?> loadClass = ProjectClassLoaderHelper.getProjectClassLoader(project).loadClass(classname);
            Field declaredField = loadClass.getDeclaredField(INSTANCE_FIELD_NAME);
            EPackage ePackage = (EPackage)declaredField.get(null);
            String nsURI = ePackage.getNsURI();
            REGISTRY.remove((Object)nsURI);
            nsuri2basePackage.remove(nsURI);
        }
        catch (Exception e) {
            throw new RegistrationException(Messages.bind((String)Messages.registration_error2, (Object)classname, (Object)project.getName()), e);
        }
    }

    public static void registerPackage(IProject project, String classname) throws RegistrationException {
        try {
            Class<?> loadClass = ProjectClassLoaderHelper.getProjectClassLoader(project).loadClass(classname);
            Field declaredField = loadClass.getDeclaredField(INSTANCE_FIELD_NAME);
            EPackage ePackage = (EPackage)declaredField.get(null);
            String nsURI = ePackage.getNsURI();
            REGISTRY.put((Object)nsURI, (Object)new Descriptor(ePackage));
            int index = classname.lastIndexOf(ePackage.getName());
            if (index == -1) {
                throw new IllegalStateException();
            }
            if (index == 0) {
                nsuri2basePackage.put(nsURI, "");
            } else {
                nsuri2basePackage.put(nsURI, classname.substring(0, index - 1));
            }
        }
        catch (Exception e) {
            throw new RegistrationException(Messages.bind((String)Messages.registration_error2, (Object)classname, (Object)project.getName()), e);
        }
    }

    private static Resource loadResource(URI uri) {
        ResourceSetImpl set = new ResourceSetImpl();
        Resource res = ResourceHelper.loadResource((ResourceSet)set, (URI)uri);
        return res;
    }

    private static class Descriptor
    implements EPackage.Descriptor {
        private EPackage epackage;

        public Descriptor(EPackage ePackage) {
            this.epackage = ePackage;
        }

        public EFactory getEFactory() {
            return this.epackage.getEFactoryInstance();
        }

        public EPackage getEPackage() {
            return this.epackage;
        }
    }

    public static class RegistrationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private RegistrationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

