/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.adapter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.model.editor.EGFModelsEditorPlugin;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPartSite;

public class EGFAdapter
extends EContentAdapter {
    private IWorkbenchPartSite _site;

    public EGFAdapter(IWorkbenchPartSite site) {
        this._site = site;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getNewValue() != null && notification.getNewValue() instanceof Pattern) {
            this.handlePatternNotification(notification);
        }
    }

    private void handlePatternNotification(Notification notification) {
        if (notification.getEventType() == 3) {
            Pattern pattern = (Pattern)notification.getNewValue();
            IPlatformFcore fcore = EGFCorePlugin.getPlatformFcore((Resource)pattern.eResource());
            if (fcore == null || fcore.getPlatformBundle().getProject() == null) {
                return;
            }
            ConvertProjectOperation operation = new ConvertProjectOperation(fcore.getPlatformBundle().getProject(), true, true){

                public List<String> addDependencies() {
                    ArrayList<String> dependencies = new ArrayList<String>(1);
                    dependencies.add("org.eclipse.egf.pattern");
                    return dependencies;
                }

                public List<String> addSourceFolders() {
                    ArrayList<String> sourceFolders = new ArrayList<String>(1);
                    sourceFolders.add("generated");
                    return sourceFolders;
                }
            };
            try {
                new ProgressMonitorDialog(this._site.getShell()).run(false, true, (IRunnableWithProgress)operation);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                ThrowableHandler.handleThrowable((String)EGFModelsEditorPlugin.getPlugin().getSymbolicName(), (Throwable)e);
            }
        }
    }
}

