/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.model.edit.EGFModelEditPlugin;
import org.eclipse.egf.model.fcore.FcoreFactory;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.fcore.commands.resource.FcoreResourceAddCommand;
import org.eclipse.egf.model.fcore.commands.resource.ResourceFeatureAddCommand;
import org.eclipse.egf.model.fcore.commands.resource.ResourceMoveCommand;
import org.eclipse.egf.model.fcore.commands.resource.ResourceRemoveCommand;
import org.eclipse.egf.model.fcore.provider.ResourceChildCreationExtenderManager;
import org.eclipse.egf.model.fcore.util.FcoreResourceImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.provider.resource.ResourceItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcoreResourceItemProvider
extends ResourceItemProvider {
    protected ResourceChildCreationExtenderManager _resourceExtenderManager;
    protected Collection<EClass> _roots;

    public FcoreResourceItemProvider(AdapterFactory adapterFactory, ResourceChildCreationExtenderManager resourceExtenderManager) {
        super(adapterFactory);
        this._resourceExtenderManager = resourceExtenderManager;
    }

    public Collection<EClass> getRoots() {
        if (this._roots == null) {
            this._roots = new UniqueEList();
            this._roots.add(FcorePackage.Literals.FACTORY_COMPONENT);
            this._roots.addAll(this._resourceExtenderManager.getRoots());
        }
        return this._roots;
    }

    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        FcoreResourceImpl resource = (FcoreResourceImpl)object;
        ArrayList<Object> newChildDescriptors = new ArrayList<Object>();
        this.collectNewChildDescriptors(newChildDescriptors, object);
        if (this.adapterFactory instanceof IChildCreationExtender) {
            newChildDescriptors.addAll(((IChildCreationExtender)this.adapterFactory).getNewChildDescriptors(object, editingDomain));
        }
        if (sibling != null) {
            sibling = this.unwrap(sibling);
            EList children = resource.getContents();
            int i = 0;
            block0: for (Object e : newChildDescriptors) {
                if (!(e instanceof CommandParameter)) continue;
                CommandParameter parameter = (CommandParameter)e;
                i = 0;
                for (Object innerObject : children) {
                    if (this.isEquivalentValue(sibling, innerObject)) {
                        parameter.index = i + 1;
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        return newChildDescriptors;
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        newChildDescriptors.add(this.createChildParameter(FcorePackage.Literals.FACTORY_COMPONENT, FcoreFactory.eINSTANCE.createFactoryComponent()));
    }

    protected CommandParameter createChildParameter(Object feature, Object child) {
        return new CommandParameter(null, feature, child);
    }

    public String getText(Object object) {
        IPlatformFcore fcore;
        Resource resource = (Resource)object;
        StringBuffer buffer = new StringBuffer(resource.getURI() == null ? "" : URI.decode((String)resource.getURI().toString()));
        if (resource instanceof IPlatformFcoreProvider && (fcore = ((IPlatformFcoreProvider)resource).getIPlatformFcore()) != null) {
            if (fcore.getPlatformBundle().isTarget()) {
                buffer.append(" [Target]");
            } else {
                buffer.append(" [Workspace]");
            }
            buffer.append(" [");
            buffer.append(fcore.getPlatformBundle().getInstallLocation());
            buffer.append("]");
        }
        return buffer.toString();
    }

    public Object getImage(Object object) {
        return URI.createURI((String)EGFModelEditPlugin.INSTANCE.getPluginResourceLocator().getImage("full/obj16/Fcore").toString());
    }

    public ResourceLocator getResourceLocator() {
        return ((IChildCreationExtender)this.adapterFactory).getResourceLocator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Command createCommand(Object object, EditingDomain domain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        CommandParameter oldCommandParameter = commandParameter;
        commandParameter = this.unwrapCommandValues(commandParameter, commandClass);
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (!(commandParameter.owner instanceof FcoreResourceImpl)) return super.createCommand(object, domain, commandClass, commandParameter);
        if (commandClass == RemoveCommand.class) {
            result = this.createRemoveCommand(domain, (FcoreResourceImpl)commandParameter.owner, commandParameter.getCollection());
            return this.wrapCommand((Command)result, object, commandClass, commandParameter, oldCommandParameter);
        } else if (commandClass == AddCommand.class) {
            result = this.createAddCommand(domain, (FcoreResourceImpl)commandParameter.owner, commandParameter.getCollection(), commandParameter.getIndex());
            return this.wrapCommand((Command)result, object, commandClass, commandParameter, oldCommandParameter);
        } else if (commandClass == MoveCommand.class) {
            result = this.createMoveCommand(domain, (FcoreResourceImpl)commandParameter.owner, commandParameter.getValue(), commandParameter.getIndex());
            return this.wrapCommand((Command)result, object, commandClass, commandParameter, oldCommandParameter);
        } else {
            if (commandClass != CreateChildCommand.class) return super.createCommand(object, domain, commandClass, commandParameter);
            CommandParameter newChildParameter = (CommandParameter)commandParameter.getValue();
            result = this.createCreateChildCommand(domain, (FcoreResourceImpl)commandParameter.owner, newChildParameter.getEStructuralFeature(), newChildParameter.getValue(), newChildParameter.getIndex(), commandParameter.getCollection());
        }
        return this.wrapCommand((Command)result, object, commandClass, commandParameter, oldCommandParameter);
    }

    protected Command createRemoveCommand(EditingDomain domain, FcoreResourceImpl resource, Collection<?> collection) {
        CompoundCommand removeCommand = new CompoundCommand(Integer.MAX_VALUE);
        removeCommand.append((Command)new ResourceRemoveCommand(domain, resource, collection));
        for (Object object : collection) {
            EObject eObject = (EObject)object;
            if (eObject.eContents().isEmpty()) continue;
            removeCommand.append(domain.createCommand(RemoveCommand.class, new CommandParameter((Object)eObject, null, (Collection)eObject.eContents())));
        }
        return removeCommand;
    }

    protected Command createAddCommand(EditingDomain domain, FcoreResourceImpl resource, Collection<?> collection, int index) {
        Collection<EClass> roots = this.getRoots();
        if (collection != null) {
            for (Object object : collection) {
                EObject eObject;
                if (!(object instanceof EObject) || roots.contains(EMFHelper.solveAgainstStaticPackage((EClassifier)(eObject = (EObject)object).eClass()))) continue;
                return UnexecutableCommand.INSTANCE;
            }
            return new FcoreResourceAddCommand(domain, resource, collection, index);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createMoveCommand(EditingDomain domain, FcoreResourceImpl resource, Object value, int index) {
        EObject eObject;
        Collection<EClass> roots;
        if (value instanceof EObject && (roots = this.getRoots()).contains(EMFHelper.solveAgainstStaticPackage((EClassifier)(eObject = (EObject)value).eClass()))) {
            return new ResourceMoveCommand(domain, (Resource)resource, value, index);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createCreateChildCommand(EditingDomain domain, FcoreResourceImpl resource, EStructuralFeature feature, Object value, int index, Collection<?> collection) {
        EObject eObject;
        Collection<EClass> roots;
        Object object;
        if (collection != null && collection.size() == 1 && (object = collection.iterator().next()) instanceof EObject && (roots = this.getRoots()).contains(EMFHelper.solveAgainstStaticPackage((EClassifier)(eObject = (EObject)object).eClass()))) {
            return new ResourceFeatureAddCommand(domain, resource, feature, value, resource.getContents().indexOf((Object)eObject) == -1 ? -1 : resource.getContents().indexOf((Object)eObject) + 1);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void notifyChanged(Notification notification) {
        switch (notification.getFeatureID(Resource.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 2: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }
}

