/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.producer.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.helper.ClassHelper;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.helper.BundleSessionHelper;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.context.IProductionContext;
import org.eclipse.egf.core.producer.l10n.CoreProducerMessages;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProductionContext<P, T>
implements IProductionContext<P, T> {
    public static final String __inputMode = "Input";
    public static final String __outputMode = "Output";
    private String _name;
    private ProjectBundleSession _projectBundleSession;
    protected P _element;
    protected IProductionContext<?, ?> _parent;
    protected final Map<T, Data> _inputDatas = new HashMap<T, Data>();
    protected final Map<T, Data> _outputDatas = new HashMap<T, Data>();

    public ProductionContext(ProjectBundleSession projectBundleSession, P element, String name) {
        Assert.isNotNull((Object)projectBundleSession);
        Assert.isNotNull(element);
        Assert.isNotNull((Object)name);
        this._projectBundleSession = projectBundleSession;
        this._element = element;
        this._name = name;
    }

    public ProductionContext(IProductionContext<?, ?> parent, ProjectBundleSession projectBundleSession, P element, String name) {
        Assert.isNotNull((Object)projectBundleSession);
        Assert.isNotNull(element);
        Assert.isNotNull((Object)name);
        this._parent = parent;
        this._projectBundleSession = projectBundleSession;
        this._element = element;
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public P getElement() {
        return this._element;
    }

    @Override
    public IProductionContext<?, ?> getParent() {
        return this._parent;
    }

    @Override
    public Bundle getBundle(String id) throws InvocationException {
        try {
            return this._projectBundleSession.getBundle(id);
        }
        catch (CoreException ce) {
            throw new InvocationException(ce);
        }
    }

    @Override
    public Bundle getBundle(IProject project) throws InvocationException {
        try {
            return this._projectBundleSession.getBundle(project);
        }
        catch (CoreException ce) {
            throw new InvocationException(ce);
        }
    }

    @Override
    public Bundle getBundle(IPlatformExtensionPoint platformExtensionPoint) throws InvocationException {
        try {
            return BundleSessionHelper.getBundle((ProjectBundleSession)this._projectBundleSession, (IPlatformExtensionPoint)platformExtensionPoint);
        }
        catch (CoreException ce) {
            throw new InvocationException(ce);
        }
    }

    @Override
    public void clear() {
        this._inputDatas.clear();
        this._outputDatas.clear();
    }

    @Override
    public boolean isSetAtRuntime(Object key) throws InvocationException {
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)__inputMode, (Object)this.getName()));
        }
        if (this.getParent() != null) {
            return this.getParent().isSetAtRuntime(key);
        }
        return false;
    }

    public void addInputData(T key, Class<?> clazz, Object object, boolean check) throws InvocationException {
        if (this._inputDatas.put(key, new Data(key, clazz, object, __inputMode)) != null && check) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_non_unique_key, (Object[])new Object[]{__inputMode, EMFHelper.getText(key), this.getName()}));
        }
    }

    public void addOutputData(T key, Class<?> clazz, Object object, boolean check) throws InvocationException {
        if (this._outputDatas.put(key, new Data(key, clazz, object, __outputMode)) != null && check) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_non_unique_key, (Object[])new Object[]{__outputMode, EMFHelper.getText(key), this.getName()}));
        }
    }

    @Override
    public void setOutputValue(Object key, Object value) throws InvocationException {
        Data outputData;
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)__outputMode, (Object)this.getName()));
        }
        if (this.getParent() != null) {
            this.getParent().setOutputValue(key, value);
        }
        if ((outputData = this._outputDatas.get(key)) == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_key, (Object[])new Object[]{__outputMode, EMFHelper.getText((Object)key), this.getName()}));
        }
        if (!(value == null || ClassHelper.asSubClass(value.getClass(), outputData.getType()) && outputData.getType().isInstance(value))) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{outputData.getType().getName(), __outputMode, EMFHelper.getText((Object)key), value.getClass().getName(), this.getName()}));
        }
        outputData.setValue(value);
        Data inputData = this._inputDatas.get(key);
        if (inputData != null) {
            inputData.setValue(value);
        }
    }

    @Override
    public Class<?> getInputValueType(Object key) throws InvocationException {
        Data inputData;
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)__inputMode, (Object)this.getName()));
        }
        Class<?> valueType = null;
        if (this.getParent() != null) {
            valueType = this.getParent().getInputValueType(key);
        }
        if (valueType == null && (inputData = this._inputDatas.get(key)) != null) {
            valueType = inputData.getType();
        }
        return valueType;
    }

    @Override
    public <R> R getInputValue(Object key, Class<R> clazz) throws InvocationException {
        Data inputData;
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)__inputMode, (Object)this.getName()));
        }
        R value = null;
        if (this.getParent() != null) {
            value = this.getParent().getInputValue(key, clazz);
        }
        if (value == null && (inputData = this._inputDatas.get(key)) != null) {
            value = this.getValue(key, clazz, inputData, __inputMode);
        }
        return value;
    }

    @Override
    public Collection<T> getInputValueKeys() throws InvocationException {
        return this._inputDatas.keySet();
    }

    @Override
    public Class<?> getOutputValueType(Object key) throws InvocationException {
        Data outputData;
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)__outputMode, (Object)this.getName()));
        }
        Class<?> valueType = null;
        if (this.getParent() != null) {
            valueType = this.getParent().getOutputValueType(key);
        }
        if (valueType == null && (outputData = this._outputDatas.get(key)) != null) {
            valueType = outputData.getType();
        }
        return valueType;
    }

    @Override
    public <R> R getOutputValue(Object key, Class<R> clazz) throws InvocationException {
        Data outputData;
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)__outputMode, (Object)this.getName()));
        }
        R value = null;
        if (this.getParent() != null) {
            value = this.getParent().getOutputValue(key, clazz);
        }
        if (value == null && (outputData = this._outputDatas.get(key)) != null) {
            value = this.getValue(key, clazz, outputData, __outputMode);
        }
        return value;
    }

    @Override
    public Collection<T> getOutputValueKeys() throws InvocationException {
        return this._outputDatas.keySet();
    }

    protected <R> R getValue(Object key, Class<R> clazz, Data data, String mode) throws InvocationException {
        if (data == null || data.getValue() == null) {
            return null;
        }
        if (!ClassHelper.asSubClass(data.getValue().getClass(), clazz)) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{data.getType().getName(), mode, EMFHelper.getText((Object)key), clazz.getName(), this.getName()}));
        }
        try {
            return clazz.cast(data.getValue());
        }
        catch (ClassCastException cce) {
            throw new InvocationException(cce);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Data {
        private T _key;
        private Class<?> _clazz;
        private Object _value;
        private String _mode;

        public Data(T key, Class<?> clazz, Object value, String mode) throws InvocationException {
            if (key == null) {
                throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)mode, (Object)ProductionContext.this.getName()));
            }
            this._key = key;
            if (clazz == null) {
                throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_class, (Object[])new Object[]{mode, EMFHelper.getText(this._key), ProductionContext.this.getName()}));
            }
            this._clazz = clazz;
            if (value != null && !this._clazz.isInstance(value)) {
                throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{this._clazz.getName(), mode, EMFHelper.getText(this._key), value.getClass().getName(), ProductionContext.this.getName()}));
            }
            this._value = value;
            this._mode = mode;
        }

        public Class<?> getType() {
            return this._clazz;
        }

        public Object getValue() {
            return this._value;
        }

        public void setValue(Object value) throws InvocationException {
            if (value != null && !this._clazz.isInstance(value)) {
                throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{this._clazz.getName(), this._mode, EMFHelper.getText(this._key), value.getClass().getName(), ProductionContext.this.getName()}));
            }
            this._value = value;
        }
    }
}

