/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.ui.activator.EGFAbstractUIPlugin;
import org.eclipse.egf.core.fcore.IResourceFcoreListener;
import org.eclipse.egf.core.pde.extension.IFcoreExtensionFactory;
import org.eclipse.egf.core.pde.internal.FcoreGeneratorHelper;
import org.eclipse.egf.core.pde.internal.extension.FcoreExtensionFactory;
import org.eclipse.egf.core.pde.internal.resource.FcoreResourceListener;
import org.eclipse.egf.core.pde.l10n.EGFPDEMessages;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;

public class EGFPDEPlugin
extends EGFAbstractUIPlugin
implements ISaveParticipant {
    private static EGFPDEPlugin __plugin;
    private FcoreResourceListener _fcoreResourceListener;

    public static Display getDisplay() {
        Display display = null;
        display = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getDisplay() : Display.getDefault();
        return display;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return EGFPDEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = EGFPDEPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = EGFPDEPlugin.getDefault().getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __plugin = this;
        this._fcoreResourceListener = new FcoreResourceListener();
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Job processSavedState = new Job(EGFPDEMessages.savedState_jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    workspace.run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor progress) throws CoreException {
                            ISavedState savedState = workspace.addSaveParticipant((Plugin)EGFPDEPlugin.getDefault(), (ISaveParticipant)EGFPDEPlugin.this);
                            if (savedState != null) {
                                ((EGFPDEPlugin)(this).EGFPDEPlugin.this)._fcoreResourceListener._overridenEventType = 1;
                                savedState.processResourceChangeEvents((IResourceChangeListener)EGFPDEPlugin.this._fcoreResourceListener);
                            }
                        }
                    }, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        processSavedState.setSystem(true);
        processSavedState.setPriority(20);
        processSavedState.schedule();
    }

    public void doneSaving(ISaveContext saveContext) {
    }

    public void prepareToSave(ISaveContext saveContext) throws CoreException {
    }

    public void rollback(ISaveContext saveContext) {
    }

    public void saving(ISaveContext saveContext) throws CoreException {
        saveContext.needDelta();
    }

    public void stop(BundleContext context) throws Exception {
        this._fcoreResourceListener.dispose();
        this._fcoreResourceListener = null;
        __plugin = null;
        super.stop(context);
    }

    public static EGFPDEPlugin getDefault() {
        return __plugin;
    }

    public static IFcoreExtensionFactory getFcoreExtensionHelper() {
        return FcoreExtensionFactory.getInstance();
    }

    public void addResourceFcoreListener(IResourceFcoreListener listener) {
        this._fcoreResourceListener.addResourceFcoreListener(listener);
    }

    public void removeResourceFcoreListener(IResourceFcoreListener listener) {
        this._fcoreResourceListener.removeResourceFcoreListener(listener);
    }

    public IFile getFile(IPluginModelBase pluginModelBase) {
        return this.getFile(ProjectHelper.getProject((IPluginModelBase)pluginModelBase));
    }

    public IFile getFile(IProject project) {
        if (project == null) {
            return null;
        }
        IFile plugin = project.getFile("plugin.xml");
        return plugin.exists() ? plugin : null;
    }

    public boolean isPluginFile(IResource resource) {
        if (resource != null && resource instanceof IFile) {
            return ((IFile)resource).getName().equals("plugin.xml");
        }
        return false;
    }

    public void addEntryInBinaryBuild(IProject project, String entryName) throws CoreException {
        if (project == null || entryName == null) {
            return;
        }
        WorkspaceBuildModel buildModel = FcoreGeneratorHelper.getBuildModel(project);
        FcoreGeneratorHelper.addEntryInBinaryBuild((IBuildModel)buildModel, entryName);
        buildModel.save();
    }
}

