/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.egf.common.activator.EGFAbstractPlugin;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.core.platform.internal.pde.PlatformManager;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointFactory;
import org.eclipse.egf.core.platform.pde.IPlatformManager;
import org.eclipse.egf.core.platform.pde.PlatformURIConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EGFPlatformPlugin
extends EGFAbstractPlugin {
    private static EGFPlatformPlugin __plugin;
    private static Map<String, IConfigurationElement> __managers;

    public static PlatformURIConverter getPlatformURIConverter() {
        return PlatformURIConverter.getInstance();
    }

    public static IPlatformManager getPlatformManager() {
        return PlatformManager.getInstance();
    }

    public Map<String, IConfigurationElement> getPlatform() {
        if (__managers == null) {
            HashMap<String, IConfigurationElement> managers = new HashMap<String, IConfigurationElement>();
            HashMap<String, Class<? extends IPlatformExtensionPoint>> interfaces = new HashMap<String, Class<? extends IPlatformExtensionPoint>>();
            IConfigurationElement[] iConfigurationElementArray = ExtensionPointHelper.getConfigurationElements((String)EGFPlatformPlugin.getDefault().getBundle().getSymbolicName(), (String)"manager");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String extension = ExtensionPointHelper.getAttributeValue((IConfigurationElement)configurationElement, (String)"extension");
                if (extension != null && extension.trim().length() != 0) {
                    if (managers.containsKey(extension = extension.trim())) {
                        EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"Duplicate Extension {0}", (Object)extension));
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Extension-Point ''{0}''", (Object)configurationElement.getName()), 1);
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Bundle ''{0}''", (Object)ExtensionPointHelper.getNamespace((IConfigurationElement)configurationElement)), 1);
                    } else {
                        Object factory = null;
                        try {
                            factory = ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
                        }
                        catch (CoreException ce) {
                            EGFPlatformPlugin.getDefault().logError(ce);
                        }
                        if (factory != null) {
                            if (!(factory instanceof IPlatformExtensionPointFactory)) {
                                EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"Wrong Class {0}", (Object)factory.getClass().getName()));
                                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Class should be an implementation of ''{0}''.", (Object)IPlatformExtensionPointFactory.class.getName()), 1);
                                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Bundle ''{0}''", (Object)ExtensionPointHelper.getNamespace((IConfigurationElement)configurationElement)), 1);
                                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Extension-Point ''{0}''", (Object)configurationElement.getName()), 1);
                                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"extension ''{0}''", (Object)extension), 1);
                            } else {
                                Class<? extends IPlatformExtensionPoint> clazz = EGFPlatformPlugin.fetchReturnedTypeFromFactory(factory.getClass());
                                if (clazz == null) {
                                    EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"Wrong Class {0}", (Object)factory.getClass().getName()));
                                    EGFPlatformPlugin.getDefault().logInfo("Unable to find ''createExtensionPoint(IPlatformBundle platformBundle, IPluginElement pluginElement)'' method.");
                                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Extension-Point ''{0}''", (Object)configurationElement.getName()), 1);
                                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Bundle ''{0}''", (Object)ExtensionPointHelper.getNamespace((IConfigurationElement)configurationElement)), 1);
                                } else if (interfaces.get(factory.getClass().getName()) != null) {
                                    EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"Duplicate Factory {0}", (Object)factory.getClass().getName()));
                                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Extension-Point ''{0}''", (Object)configurationElement.getName()), 1);
                                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Bundle ''{0}''", (Object)ExtensionPointHelper.getNamespace((IConfigurationElement)configurationElement)), 1);
                                } else {
                                    managers.put(extension, configurationElement);
                                    interfaces.put(factory.getClass().getName(), clazz);
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
            __managers = managers;
        }
        return __managers;
    }

    public static Class<? extends IPlatformExtensionPoint> fetchReturnedTypeFromFactory(Class<?> factory) {
        Class clazz = null;
        Method method = null;
        try {
            method = factory.getDeclaredMethod("createExtensionPoint", IPlatformBundle.class, IPluginElement.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null) {
            Type type = null;
            try {
                type = method.getGenericReturnType();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (type != null) {
                try {
                    clazz = (Class)type;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return clazz;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __plugin = this;
        PlatformManager.getInstance();
        PlatformURIConverter.getInstance();
    }

    public void stop(BundleContext context) throws Exception {
        PlatformManager.getInstance().dispose();
        PlatformURIConverter.getInstance().dispose();
        __plugin = null;
        __managers = null;
        super.stop(context);
    }

    public static EGFPlatformPlugin getDefault() {
        return __plugin;
    }
}

