/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import org.eclipse.egf.model.fcore.NamedModelElement;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.pattern.java.engine.JavaNatureHelper;
import org.eclipse.egf.pattern.utils.JavaMethodGenerationHelper;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class JavaTranslationEnhancer {
    private final Pattern pattern;

    public JavaTranslationEnhancer(Pattern pattern) {
        this.pattern = pattern;
    }

    public String enhance(String source) throws PatternException {
        if (this.canEnhance(source)) {
            Document document = new Document(source);
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setKind(8);
            parser.setSource(document.get().toCharArray());
            CompilationUnit cu = (CompilationUnit)parser.createAST(null);
            cu.recordModifications();
            if ((cu.getFlags() & 1) != 0) {
                throw new PatternException("Translated class is malformed ");
            }
            TypeDeclaration type = (TypeDeclaration)cu.types().get(0);
            this.performEnhancement(type);
            TextEdit rewrite = cu.rewrite((IDocument)document, null);
            try {
                rewrite.apply((IDocument)document);
            }
            catch (BadLocationException e1) {
                throw new PatternException((Throwable)e1);
            }
            return document.get();
        }
        return source;
    }

    protected boolean canEnhance(String source) throws PatternException {
        return this.pattern.getSuperPattern() != null || !this.pattern.getParameters().isEmpty() || !this.pattern.getVariables().isEmpty();
    }

    protected void performEnhancement(TypeDeclaration type) throws PatternException {
        this.addSuperClass(type);
        this.addParameterFieldsAndSetter(type);
        this.addVariableFieldsAndSetter(type);
        this.addGetParametersMethod(type);
    }

    private void addGetParametersMethod(TypeDeclaration type) {
    }

    protected void addVariableFieldsAndSetter(TypeDeclaration type) {
        for (PatternVariable var : this.pattern.getVariables()) {
            String typeValue = ParameterTypeHelper.INSTANCE.getTypeLiteral(var.getType());
            this.addField(type, var.getName(), typeValue, 2);
            this.addSetter(type, (NamedModelElement)var, typeValue);
        }
    }

    protected void addParameterFieldsAndSetter(TypeDeclaration type) {
        for (PatternParameter param : this.pattern.getParameters()) {
            String typeValue = ParameterTypeHelper.INSTANCE.getTypeLiteral(param.getType());
            this.addField(type, param.getName(), typeValue, 4);
            this.addSetter(type, (NamedModelElement)param, typeValue);
        }
    }

    private void addSetter(TypeDeclaration typeDeclaration, NamedModelElement paramOrVariable, String type) {
        AST ast = typeDeclaration.getAST();
        MethodDeclaration setter = ast.newMethodDeclaration();
        setter.modifiers().addAll(ast.newModifiers(1));
        setter.setName(ast.newSimpleName(JavaMethodGenerationHelper.getSetterMethod((NamedModelElement)paramOrVariable)));
        SingleVariableDeclaration variableDeclaration = ast.newSingleVariableDeclaration();
        variableDeclaration.setType((Type)ast.newSimpleType(ast.newName(type)));
        variableDeclaration.setName(ast.newSimpleName(paramOrVariable.getName()));
        setter.parameters().add(variableDeclaration);
        Block body = ast.newBlock();
        Assignment assignment = ast.newAssignment();
        FieldAccess fieldAccess = ast.newFieldAccess();
        fieldAccess.setName(ast.newSimpleName(paramOrVariable.getName()));
        fieldAccess.setExpression((Expression)ast.newThisExpression());
        assignment.setLeftHandSide((Expression)fieldAccess);
        assignment.setOperator(Assignment.Operator.ASSIGN);
        assignment.setRightHandSide((Expression)ast.newSimpleName(paramOrVariable.getName()));
        body.statements().add(ast.newExpressionStatement((Expression)assignment));
        setter.setBody(body);
        typeDeclaration.bodyDeclarations().add(setter);
    }

    private void addField(TypeDeclaration typeDeclaration, String name, String type, int modifiers) {
        AST ast = typeDeclaration.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(name));
        FieldDeclaration field = ast.newFieldDeclaration(fragment);
        field.modifiers().addAll(ast.newModifiers(modifiers));
        field.setType((Type)ast.newSimpleType(ast.newName(type)));
        typeDeclaration.bodyDeclarations().add(field);
    }

    protected void addSuperClass(TypeDeclaration type) throws PatternException {
        if (this.pattern.getSuperPattern() != null) {
            String parentClassName = JavaNatureHelper.getClassName(this.pattern.getSuperPattern());
            AST ast = type.getAST();
            SimpleType newSimpleType = ast.newSimpleType(ast.newName(parentClassName));
            type.setSuperclassType((Type)newSimpleType);
        }
    }
}

