/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.jumper.dsf;

import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.debug.gdbjtag.dsf.GnuMcuGdbServerBackend;
import org.eclipse.embedcdt.debug.gdbjtag.jumper.Activator;
import org.eclipse.embedcdt.debug.gdbjtag.jumper.Configuration;
import org.osgi.framework.BundleContext;

public class GdbServerBackend
extends GnuMcuGdbServerBackend {
    protected int fGdbServerLaunchTimeout = 60;

    public GdbServerBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.GdbServerBackend(" + session + "," + lc.getName() + ")");
        }
    }

    public void initialize(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.GdbServerBackend.initialize()");
        }
        try {
            this.fDoStartGdbServer = Configuration.getDoStartGdbServer(this.fLaunchConfiguration);
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.jumper", -1, "Cannot get configuration", (Throwable)e));
            rm.done();
            return;
        }
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GdbServerBackend.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.GdbServerBackend.doInitialize()");
        }
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.GdbServerBackend.shutdown()");
        }
        super.shutdown(rm);
    }

    public void destroy() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.GdbServerBackend.destroy() " + Thread.currentThread());
        }
        super.destroy();
    }

    protected BundleContext getBundleContext() {
        return Activator.getInstance().getBundle().getBundleContext();
    }

    public String[] getServerCommandLineArray() {
        String[] commandLineArray = Configuration.getGdbServerCommandLineArray(this.fLaunchConfiguration);
        return commandLineArray;
    }

    public String getServerCommandName() {
        String[] commandLineArray = this.getServerCommandLineArray();
        if (commandLineArray == null) {
            return null;
        }
        String fullCommand = commandLineArray[0];
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public int getServerLaunchTimeoutSeconds() {
        return this.fGdbServerLaunchTimeout;
    }

    public String getServerName() {
        return "Jumper";
    }

    public boolean canMatchStdOut() {
        return true;
    }

    public boolean canMatchStdErr() {
        return false;
    }

    public boolean matchStdOutExpectedPattern(String line) {
        return line.indexOf("Virtual device is running") >= 0;
    }

    public String prepareMessageBoxText(int exitCode) {
        String body = "";
        String name = this.getServerCommandName();
        if (name == null) {
            name = "Jumper";
        }
        String tail = "\n\nFor more details, see the " + name + " console.";
        if (body.isEmpty()) {
            return String.valueOf(this.getServerName()) + " failed with code (" + exitCode + ")." + tail;
        }
        return String.valueOf(this.getServerName()) + " failed: \n" + body + tail;
    }
}

