/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral;

public class PeripheralPath {
    private String[] fSegments = null;

    public PeripheralPath() {
        this.fSegments = new String[0];
    }

    public PeripheralPath(PeripheralPath parentPath, PeripheralPath namePath) {
        String[] parentSegments = parentPath.getSegments();
        String[] nameSegments = namePath.getSegments();
        this.fSegments = new String[parentSegments.length + nameSegments.length];
        System.arraycopy(parentSegments, 0, this.fSegments, 0, parentSegments.length);
        System.arraycopy(nameSegments, 0, this.fSegments, parentSegments.length, nameSegments.length);
    }

    public PeripheralPath(String name) {
        this.fSegments = new String[]{name};
    }

    public PeripheralPath(String parent, String name) {
        this.fSegments = new String[]{parent, name};
    }

    private String[] getSegments() {
        return this.fSegments;
    }

    public String toPath() {
        return this.toStringBuilder().toString();
    }

    public String toPath(boolean addSlash) {
        StringBuilder sb = this.toStringBuilder();
        if (addSlash) {
            sb.append('/');
        }
        return sb.toString();
    }

    public String toString() {
        return this.toPath();
    }

    private StringBuilder toStringBuilder() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.fSegments.length) {
            if (this.fSegments[i] != null) {
                if (sb.length() != 0) {
                    sb.append('.');
                }
                sb.append(this.fSegments[i]);
            }
            ++i;
        }
        return sb;
    }
}

