/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.templates.core.processes;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.embedcdt.templates.core.Activator;
import org.eclipse.embedcdt.templates.core.Utils;

public class ConditionalCopyFolders
extends ProcessRunner {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        IProject projectHandle = null;
        ProcessArgument[][] folders = null;
        String startPattern = null;
        String endPattern = null;
        String condition = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            String argName = arg.getName();
            if (argName.equals("projectName")) {
                projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(arg.getSimpleValue());
            } else if (argName.equals("folders")) {
                folders = arg.getComplexArrayValue();
            } else if (argName.equals("condition")) {
                condition = arg.getSimpleValue();
            }
            ++n2;
        }
        if (projectHandle == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "projectName not specified"));
        }
        if (folders == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "No folders"));
        }
        if (!Utils.isConditionSatisfied(condition)) {
            return;
        }
        int i = 0;
        while (i < folders.length) {
            void folder = folders[i];
            String folderSourcePath = folder[0].getSimpleValue();
            String folderTargetPath = folder[1].getSimpleValue();
            String pattern = folder[2].getSimpleValue().trim();
            boolean replaceable = folder[3].getSimpleValue().equals("true");
            File dir = new File(folderSourcePath);
            try {
                if (!dir.isAbsolute()) {
                    URL folderURL = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate((TemplateCore)template, (String)folderSourcePath);
                    if (folderURL == null) {
                        throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString((String)"AddFiles.1")) + folderSourcePath));
                    }
                    dir = new File(folderURL.getFile());
                }
            }
            catch (IOException e) {
                Activator.log((Throwable)e);
            }
            if (dir.isDirectory()) {
                File[] fileArray = dir.listFiles();
                int n3 = fileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    File child = fileArray[n4];
                    String fileName = child.getName();
                    if (pattern.length() > 0 && !fileName.matches(pattern)) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println(String.valueOf(fileName) + " skipped");
                        }
                    } else if (child.isDirectory()) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println(String.valueOf(fileName) + " skipped");
                        }
                    } else {
                        URL sourceURL;
                        try {
                            sourceURL = child.toURL();
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.2")) + folderSourcePath);
                        }
                        InputStream contents = null;
                        if (replaceable) {
                            String fileContents;
                            try {
                                fileContents = ProcessHelper.readFromFile((URL)sourceURL);
                            }
                            catch (IOException iOException) {
                                throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.3")) + folderSourcePath);
                            }
                            fileContents = startPattern != null && endPattern != null ? ProcessHelper.getValueAfterExpandingMacros((String)fileContents, (Set)ProcessHelper.getReplaceKeys((String)fileContents, startPattern, endPattern), (Map)template.getValueStore(), startPattern, endPattern) : ProcessHelper.getValueAfterExpandingMacros((String)fileContents, (Set)ProcessHelper.getReplaceKeys((String)fileContents), (Map)template.getValueStore());
                            contents = new ByteArrayInputStream(fileContents.getBytes());
                        } else {
                            try {
                                contents = sourceURL.openStream();
                            }
                            catch (IOException iOException) {
                                throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString((String)"AddFiles.4")) + folderSourcePath));
                            }
                        }
                        try {
                            File concat;
                            IFile iFile;
                            IFolder iFolder = projectHandle.getFolder(folderTargetPath);
                            if (!iFolder.exists()) {
                                ProcessHelper.mkdirs((IProject)projectHandle, (IFolder)projectHandle.getFolder(iFolder.getProjectRelativePath()));
                            }
                            if ((iFile = projectHandle.getFile((concat = new File(folderTargetPath, fileName)).getPath())).exists()) {
                                if (!replaceable) throw new ProcessFailureException(Messages.getString((String)"AddFiles.5"));
                                iFile.setContents(contents, true, true, null);
                            } else {
                                iFile.create(contents, true, null);
                                iFile.refreshLocal(1, null);
                            }
                        }
                        catch (CoreException e) {
                            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.6")) + e.getMessage(), (Throwable)e);
                        }
                    }
                    ++n4;
                }
            }
            ++i;
        }
        try {
            projectHandle.refreshLocal(2, null);
            return;
        }
        catch (CoreException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.7")) + e.getMessage(), (Throwable)e);
        }
    }
}

