/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.pyocd.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.Activator;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.Configuration;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.PyOCD;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.preferences.DefaultPreferences;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.preferences.PersistentPreferences;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.ui.Messages;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.ui.TabStartup;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TabDebugger
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Debugger";
    private static final String TAB_ID = "org.eclipse.embedcdt.debug.gdbjtag.pyocd.ui.debuggertab";
    private ILaunchConfiguration fConfiguration;
    private List<PyOCD.Board> fBoards;
    private String fSelectedBoardId;
    private Map<String, PyOCD.Target> fTargetsByPartNumber;
    private Map<String, PyOCD.Target> fTargetsByName;
    private Text fGdbClientExecutable;
    private Text fGdbClientPathLabel;
    private Text fGdbClientOtherOptions;
    private Text fGdbClientOtherCommands;
    private Button fDoStartGdbServer;
    private Text fGdbServerPathLabel;
    private Link fLink;
    private Text fTargetIpAddress;
    private Text fTargetPortNumber;
    private Combo fGdbServerBoardId;
    private Button fGdbServerRefreshBoards;
    private Text fGdbServerGdbPort;
    private Text fGdbServerTelnetPort;
    private Button fGdbServerOverrideTarget;
    private Combo fGdbServerTargetName;
    private Combo fGdbServerBusSpeed;
    private Button fGdbServerHaltAtHardFault;
    private Button fGdbServerStepIntoInterrupts;
    private Combo fGdbServerFlashMode;
    private Button fGdbServerFlashFastVerify;
    private Button fGdbServerEnableSemihosting;
    private Button fGdbServerUseGdbSyscallsForSemihosting;
    private Text fGdbServerExecutable;
    private Button fGdbServerBrowseButton;
    private Button fGdbServerVariablesButton;
    private Text fGdbServerOtherOptions;
    private Button fDoGdbServerAllocateConsole;
    private Button fDoGdbServerAllocateSemihostingConsole;
    protected Button fUpdateThreadlistOnSuspend;
    private Set<String> fErrors = new LinkedHashSet<String>();
    private DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
    private PersistentPreferences fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
    private static final int COLUMN_PAD = 30;

    protected TabDebugger(TabStartup tabStartup) {
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    private Composite createHorizontalLayout(Composite comp, int columns, int spanSub) {
        Composite local = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        if (spanSub > 0) {
            gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - spanSub;
        }
        local.setLayoutData((Object)gd);
        return local;
    }

    public void createControl(Composite parent) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.createControl() ");
        }
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createGdbServerGroup(comp);
        this.createGdbClientControls(comp);
        this.createRemoteControl(comp);
        this.fUpdateThreadlistOnSuspend = new Button(comp, 32);
        this.fUpdateThreadlistOnSuspend.setText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_Text"));
        this.fUpdateThreadlistOnSuspend.setToolTipText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_ToolTipText"));
        Link restoreDefaults = new Link(comp, 0);
        restoreDefaults.setText(Messages.getString("DebuggerTab.restoreDefaults_Link"));
        restoreDefaults.setToolTipText(Messages.getString("DebuggerTab.restoreDefaults_ToolTipText"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        restoreDefaults.setLayoutData((Object)gd);
        this.fUpdateThreadlistOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
            }
        });
        restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabDebugger.this.initializeFromDefaults();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    private void createGdbServerGroup(final Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("DebuggerTab.gdbServerGroup_Text"));
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        this.fDoStartGdbServer = new Button(comp, 32);
        this.fDoStartGdbServer.setText(Messages.getString("DebuggerTab.doStartGdbServer_Text"));
        this.fDoStartGdbServer.setToolTipText(Messages.getString("DebuggerTab.doStartGdbServer_ToolTipText"));
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        this.fDoStartGdbServer.setLayoutData((Object)gd);
        Composite subcomp = new Composite(comp, 0);
        gd2 = new GridData(4, 128, true, false);
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        subcomp.setLayoutData((Object)gd2);
        GridLayout layout3 = new GridLayout(2, false);
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        subcomp.setLayout((Layout)layout3);
        Label label = new Label(subcomp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerExecutable_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerExecutable_ToolTipText"));
        Composite local = this.createHorizontalLayout(subcomp, 3, 1);
        this.fGdbServerExecutable = new Text(local, 2052);
        GridData gd3 = new GridData(768);
        this.fGdbServerExecutable.setLayoutData((Object)gd3);
        this.fGdbServerBrowseButton = new Button(local, 0);
        this.fGdbServerBrowseButton.setText(Messages.getString("DebuggerTab.gdbServerExecutableBrowse"));
        this.fGdbServerVariablesButton = new Button(local, 0);
        this.fGdbServerVariablesButton.setText(Messages.getString("DebuggerTab.gdbServerExecutableVariable"));
        label = new Label(subcomp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerActualPath_Label"));
        this.fGdbServerPathLabel = new Text(subcomp, 2052);
        GridData gd4 = new GridData(4, 0, true, false);
        gd4.horizontalSpan = 1;
        this.fGdbServerPathLabel.setLayoutData((Object)gd4);
        this.fGdbServerPathLabel.setEnabled(true);
        this.fGdbServerPathLabel.setEditable(false);
        label = new Label(subcomp, 0);
        label.setText("");
        this.fLink = new Link(subcomp, 0);
        this.fLink.setText(Messages.getString("DebuggerTab.gdbServerActualPath_link"));
        gd4 = new GridData();
        gd4.horizontalSpan = 1;
        this.fLink.setLayoutData((Object)gd4);
        label = new Label(subcomp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerGdbPort_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerGdbPort_ToolTipText"));
        Composite subcomp2 = new Composite(subcomp, 0);
        gd3 = new GridData(4, 128, true, false);
        subcomp2.setLayoutData((Object)gd3);
        GridLayout layout4 = new GridLayout(2, false);
        layout4.horizontalSpacing = 30;
        layout4.marginHeight = 0;
        layout4.marginWidth = 0;
        subcomp2.setLayout((Layout)layout4);
        this.fGdbServerGdbPort = new Text(subcomp2, 2052);
        gd3 = new GridData();
        gd3.widthHint = 60;
        this.fGdbServerGdbPort.setLayoutData((Object)gd3);
        this.fDoGdbServerAllocateConsole = new Button(subcomp2, 32);
        this.fDoGdbServerAllocateConsole.setLayoutData((Object)new GridData());
        this.fDoGdbServerAllocateConsole.setText(Messages.getString("DebuggerTab.gdbServerAllocateConsole_Label"));
        this.fDoGdbServerAllocateConsole.setToolTipText(Messages.getString("DebuggerTab.gdbServerAllocateConsole_ToolTipText"));
        label = new Label(subcomp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerTelnetPort_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerTelnetPort_ToolTipText"));
        subcomp2 = new Composite(subcomp, 0);
        gd3 = new GridData(4, 128, true, false);
        subcomp2.setLayoutData((Object)gd3);
        layout4 = new GridLayout(2, false);
        layout4.horizontalSpacing = 30;
        layout4.marginHeight = 0;
        layout4.marginWidth = 0;
        subcomp2.setLayout((Layout)layout4);
        this.fGdbServerTelnetPort = new Text(subcomp2, 2052);
        gd3 = new GridData();
        gd3.widthHint = 60;
        this.fGdbServerTelnetPort.setLayoutData((Object)gd3);
        this.fDoGdbServerAllocateSemihostingConsole = new Button(subcomp2, 32);
        this.fDoGdbServerAllocateSemihostingConsole.setLayoutData((Object)new GridData());
        this.fDoGdbServerAllocateSemihostingConsole.setText(Messages.getString("DebuggerTab.gdbServerAllocateTelnetConsole_Label"));
        this.fDoGdbServerAllocateSemihostingConsole.setToolTipText(Messages.getString("DebuggerTab.gdbServerAllocateTelnetConsole_ToolTipText"));
        this.fDoGdbServerAllocateSemihostingConsole.setLayoutData((Object)new GridData());
        this.createSeparator(comp, ((GridLayout)comp.getLayout()).numColumns);
        Label label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerBoardId_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.gdbServerBoardId_ToolTipText"));
        Composite local2 = this.createHorizontalLayout(comp, 2, 1);
        this.fGdbServerBoardId = new Combo(local2, 12);
        gd4 = new GridData(768);
        this.fGdbServerBoardId.setLayoutData((Object)gd4);
        this.fGdbServerBoardId.setItems(new String[0]);
        this.fGdbServerBoardId.select(0);
        this.fGdbServerRefreshBoards = new Button(local2, 0);
        this.fGdbServerRefreshBoards.setText(Messages.getString("DebuggerTab.gdbServerRefreshBoards_Label"));
        this.fGdbServerOverrideTarget = new Button(comp, 32);
        this.fGdbServerOverrideTarget.setText(Messages.getString("DebuggerTab.gdbServerOverrideTarget_Label"));
        this.fGdbServerOverrideTarget.setToolTipText(Messages.getString("DebuggerTab.gdbServerOverrideTarget_ToolTipText"));
        gd = new GridData();
        this.fGdbServerOverrideTarget.setLayoutData((Object)gd);
        this.fGdbServerTargetName = new Combo(comp, 4);
        gd = new GridData();
        gd.widthHint = 360;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerTargetName.setLayoutData((Object)gd);
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerBusSpeed_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.gdbServerBusSpeed_ToolTipText"));
        this.fGdbServerBusSpeed = new Combo(comp, 4);
        gd2 = new GridData();
        gd2.widthHint = 120;
        this.fGdbServerBusSpeed.setLayoutData((Object)gd2);
        this.fGdbServerBusSpeed.setItems(new String[]{"1000000", "2000000", "8000000", "12000000"});
        this.fGdbServerBusSpeed.select(0);
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerBusSpeedUnits_Label"));
        gd2 = new GridData();
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 2;
        label2.setLayoutData((Object)gd2);
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerFlashMode_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.gdbServerFlashMode_ToolTipText"));
        gd2 = new GridData();
        label2.setLayoutData((Object)gd2);
        this.fGdbServerFlashMode = new Combo(comp, 12);
        gd2 = new GridData();
        gd2.widthHint = 120;
        this.fGdbServerFlashMode.setLayoutData((Object)gd2);
        this.fGdbServerFlashMode.setItems(new String[]{Messages.getString("DebuggerTab.gdbServerFlashMode.AutoErase"), Messages.getString("DebuggerTab.gdbServerFlashMode.ChipErase"), Messages.getString("DebuggerTab.gdbServerFlashMode.SectorErase")});
        this.fGdbServerFlashMode.select(0);
        this.fGdbServerFlashFastVerify = new Button(comp, 32);
        this.fGdbServerFlashFastVerify.setText(Messages.getString("DebuggerTab.gdbServerFlashFastVerify_Label"));
        this.fGdbServerFlashFastVerify.setToolTipText(Messages.getString("DebuggerTab.gdbServerFlashFastVerify_ToolTipText"));
        gd2 = new GridData();
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 2;
        gd2.horizontalIndent = 30;
        this.fGdbServerFlashFastVerify.setLayoutData((Object)gd2);
        subcomp = new Composite(comp, 0);
        gd2 = new GridData();
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        subcomp.setLayoutData((Object)gd2);
        layout3 = new GridLayout(2, false);
        layout3.horizontalSpacing = 30;
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        subcomp.setLayout((Layout)layout3);
        this.fGdbServerHaltAtHardFault = new Button(subcomp, 32);
        this.fGdbServerHaltAtHardFault.setLayoutData((Object)new GridData());
        this.fGdbServerHaltAtHardFault.setText(Messages.getString("DebuggerTab.gdbServerHaltAtHardFault_Label"));
        this.fGdbServerHaltAtHardFault.setToolTipText(Messages.getString("DebuggerTab.gdbServerHaltAtHardFault_ToolTipText"));
        this.fGdbServerStepIntoInterrupts = new Button(subcomp, 32);
        this.fGdbServerStepIntoInterrupts.setLayoutData((Object)new GridData());
        this.fGdbServerStepIntoInterrupts.setText(Messages.getString("DebuggerTab.gdbServerStepIntoInterrupts_Label"));
        this.fGdbServerStepIntoInterrupts.setToolTipText(Messages.getString("DebuggerTab.gdbServerStepIntoInterrupts_ToolTipText"));
        this.fGdbServerEnableSemihosting = new Button(subcomp, 32);
        this.fGdbServerEnableSemihosting.setLayoutData((Object)new GridData());
        this.fGdbServerEnableSemihosting.setText(Messages.getString("DebuggerTab.gdbServerEnableSemihosting_Label"));
        this.fGdbServerEnableSemihosting.setToolTipText(Messages.getString("DebuggerTab.gdbServerEnableSemihosting_ToolTipText"));
        this.fGdbServerUseGdbSyscallsForSemihosting = new Button(subcomp, 32);
        this.fGdbServerUseGdbSyscallsForSemihosting.setLayoutData((Object)new GridData());
        this.fGdbServerUseGdbSyscallsForSemihosting.setText(Messages.getString("DebuggerTab.gdbServerUseGdbSyscallsForSemihosting_Label"));
        this.fGdbServerUseGdbSyscallsForSemihosting.setToolTipText(Messages.getString("DebuggerTab.gdbServerUseGdbSyscallsForSemihosting_ToolTipText"));
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerOther_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.gdbServerOther_ToolTipText"));
        gd2 = new GridData();
        gd2.verticalAlignment = 128;
        label2.setLayoutData((Object)gd2);
        this.fGdbServerOtherOptions = new Text(comp, 2626);
        gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = 60;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerOtherOptions.setLayoutData((Object)gd2);
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        SelectionAdapter scheduleUpdateJobSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        this.fDoStartGdbServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.doStartGdbServerChanged();
                if (TabDebugger.this.fDoStartGdbServer.getSelection()) {
                    TabDebugger.this.fTargetIpAddress.setText("localhost");
                }
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TabDebugger.this.fConfiguration != null) {
                    TabDebugger.this.updateBoards();
                    TabDebugger.this.updateTargets();
                }
                TabDebugger.this.scheduleUpdateJob();
                TabDebugger.this.updateGdbServerActualPath();
            }
        });
        this.fGdbServerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbServerExecutableBrowse_Title"), TabDebugger.this.fGdbServerExecutable);
            }
        });
        this.fGdbServerVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.fGdbServerExecutable);
            }
        });
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = e.text;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println(text);
                }
                int ret = -1;
                if ("global".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.debug.gdbjtag.pyocd.globalPreferencePage", null, null).open();
                } else if ("workspace".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.debug.gdbjtag.pyocd.workspacePreferencePage", null, null).open();
                } else if ("project".equals(text)) {
                    if (!$assertionsDisabled && TabDebugger.this.fConfiguration == null) {
                        throw new AssertionError();
                    }
                    IProject project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)TabDebugger.this.fConfiguration);
                    ret = PreferencesUtil.createPropertyDialogOn((Shell)parent.getShell(), (IAdaptable)project, (String)"org.eclipse.embedcdt.debug.gdbjtag.pyocd.projectPropertiesPage", null, null, (int)0).open();
                }
                if (ret == 0) {
                    TabDebugger.this.updateGdbServerActualPath();
                }
            }
        });
        this.fGdbServerGdbPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.fTargetPortNumber.setText(TabDebugger.this.fGdbServerGdbPort.getText());
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerBoardId.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.boardSelected(((Combo)e.widget).getSelectionIndex());
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerRefreshBoards.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateBoards();
            }
        });
        this.fGdbServerOverrideTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.overrideTargetChanged();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerTelnetPort.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerBusSpeed.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerTargetName.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerHaltAtHardFault.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerStepIntoInterrupts.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerFlashMode.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerFlashFastVerify.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerEnableSemihosting.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerUseGdbSyscallsForSemihosting.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerOtherOptions.addModifyListener(scheduleUpdateJobModifyListener);
        this.fDoGdbServerAllocateConsole.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fDoGdbServerAllocateSemihostingConsole.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
    }

    private void createGdbClientControls(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.gdbSetupGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbCommand_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbCommand_ToolTipText"));
        Composite local = this.createHorizontalLayout(comp, 3, 1);
        this.fGdbClientExecutable = new Text(local, 2052);
        GridData gd3 = new GridData(768);
        this.fGdbClientExecutable.setLayoutData((Object)gd3);
        Button browseButton = new Button(local, 0);
        browseButton.setText(Messages.getString("DebuggerTab.gdbCommandBrowse"));
        Button variableButton = new Button(local, 0);
        variableButton.setText(Messages.getString("DebuggerTab.gdbCommandVariable"));
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbCommandActualPath_Label"));
        this.fGdbClientPathLabel = new Text(comp, 2052);
        GridData gd4 = new GridData(4, 0, true, false);
        gd4.horizontalSpan = 4;
        this.fGdbClientPathLabel.setLayoutData((Object)gd4);
        this.fGdbClientPathLabel.setEnabled(true);
        this.fGdbClientPathLabel.setEditable(false);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbOtherOptions_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbOtherOptions_ToolTipText"));
        gd4 = new GridData();
        label.setLayoutData((Object)gd4);
        this.fGdbClientOtherOptions = new Text(comp, 2052);
        gd4 = new GridData(768);
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbClientOtherOptions.setLayoutData((Object)gd4);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbOtherCommands_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbOtherCommands_ToolTipText"));
        gd4 = new GridData();
        gd4.verticalAlignment = 128;
        label.setLayoutData((Object)gd4);
        this.fGdbClientOtherCommands = new Text(comp, 2626);
        gd4 = new GridData(4, 4, true, true);
        gd4.heightHint = 60;
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbClientOtherCommands.setLayoutData((Object)gd4);
        this.fGdbClientExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
                TabDebugger.this.updateGdbClientActualPath();
            }
        });
        this.fGdbClientOtherOptions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbClientOtherCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbCommandBrowse_Title"), TabDebugger.this.fGdbClientExecutable);
            }
        });
        variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.fGdbClientExecutable);
            }
        });
    }

    private void createRemoteControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.remoteGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = this.createHorizontalLayout((Composite)group, 2, -1);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.ipAddressLabel"));
        this.fTargetIpAddress = new Text(comp, 2048);
        GridData gd2 = new GridData();
        gd2.widthHint = 125;
        this.fTargetIpAddress.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.portNumberLabel"));
        this.fTargetPortNumber = new Text(comp, 2048);
        gd2 = new GridData();
        gd2.widthHint = 125;
        this.fTargetPortNumber.setLayoutData((Object)gd2);
        this.fTargetIpAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fTargetPortNumber.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        this.fTargetPortNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void updateGdbServerActualPath() {
        assert (this.fConfiguration != null);
        String fullCommand = Configuration.getGdbServerCommand(this.fConfiguration, this.fGdbServerExecutable.getText());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.updateActualpath() \"" + fullCommand + "\"");
        }
        this.fGdbServerPathLabel.setText(fullCommand);
    }

    private void updateGdbClientActualPath() {
        assert (this.fConfiguration != null);
        String fullCommand = Configuration.getGdbClientCommand(this.fConfiguration, this.fGdbClientExecutable.getText());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.updateGdbClientActualPath() \"" + fullCommand + "\"");
        }
        this.fGdbClientPathLabel.setText(fullCommand);
    }

    private void doStartGdbServerChanged() {
        boolean enabled = this.fDoStartGdbServer.getSelection();
        this.fGdbServerExecutable.setEnabled(enabled);
        this.fGdbServerBrowseButton.setEnabled(enabled);
        this.fGdbServerVariablesButton.setEnabled(enabled);
        this.fGdbServerOtherOptions.setEnabled(enabled);
        this.fGdbServerGdbPort.setEnabled(enabled);
        this.fGdbServerTelnetPort.setEnabled(enabled);
        this.fGdbServerBusSpeed.setEnabled(enabled);
        this.fGdbServerOverrideTarget.setEnabled(enabled);
        this.fGdbServerTargetName.setEnabled(enabled && this.fGdbServerOverrideTarget.getSelection());
        this.fGdbServerHaltAtHardFault.setEnabled(enabled);
        this.fGdbServerStepIntoInterrupts.setEnabled(enabled);
        this.fGdbServerFlashMode.setEnabled(enabled);
        this.fGdbServerFlashFastVerify.setEnabled(enabled);
        this.fDoGdbServerAllocateConsole.setEnabled(enabled);
        this.fDoGdbServerAllocateSemihostingConsole.setEnabled(enabled);
        this.fTargetIpAddress.setEnabled(!enabled);
        this.fTargetPortNumber.setEnabled(!enabled);
        this.fGdbServerPathLabel.setEnabled(enabled);
        this.fLink.setEnabled(enabled);
    }

    private void overrideTargetChanged() {
        boolean enabled = this.fGdbServerOverrideTarget.getSelection();
        this.fGdbServerTargetName.setEnabled(enabled);
    }

    private String getPyOCDExecutablePath() {
        File file;
        String path = Configuration.getGdbServerCommand(this.fConfiguration, this.fGdbServerExecutable.getText());
        if (path.isEmpty()) {
            return null;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.printf("pyOCD resolved path = %s\n", path);
        }
        if (!(file = new File(path)).exists()) {
            try {
                Process process = Runtime.getRuntime().exec(String.valueOf(path) + " --version");
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.printf("pyOCD path is invalid\n", new Object[0]);
                }
                return null;
            }
        } else if (file.isDirectory()) {
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("pyOCD path is invalid\n", new Object[0]);
            }
            return null;
        }
        return path;
    }

    private int indexForBoardId(String boardId) {
        if (this.fBoards != null) {
            int index = 0;
            for (PyOCD.Board b : this.fBoards) {
                if (b.fUniqueId.equals(boardId)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    private void boardSelected(int index) {
        PyOCD.Board selectedBoard = this.fBoards.get(index);
        this.fSelectedBoardId = selectedBoard.fUniqueId;
    }

    private void selectActiveBoard() {
        int index = this.indexForBoardId(this.fSelectedBoardId);
        if (index != -1) {
            this.fGdbServerBoardId.select(index);
        }
    }

    private void selectActiveTarget() {
        if (this.fConfiguration != null) {
            try {
                String configTargetName = this.fConfiguration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTargetName", "");
                PyOCD.Target target = this.fTargetsByName.get(configTargetName);
                if (target != null) {
                    this.fGdbServerTargetName.setText(target.fPartNumber);
                } else {
                    this.fGdbServerTargetName.setText(configTargetName);
                }
            }
            catch (CoreException e) {
                Activator.log((IStatus)e.getStatus());
            }
        }
    }

    private void updateBoards() {
        String path = this.getPyOCDExecutablePath();
        if (path != null) {
            this.deregisterError("pyOCD gdbserver not found where specified");
            List<PyOCD.Board> boards = PyOCD.getBoards(path);
            if (boards == null) {
                boards = new ArrayList<PyOCD.Board>();
            }
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("board = %s\n", boards);
            }
            Collections.sort(boards, PyOCD.Board.COMPARATOR);
            this.fBoards = boards;
            ArrayList<String> itemList = new ArrayList<String>();
            for (PyOCD.Board board : boards) {
                String desc = board.fProductName;
                if (!board.fProductName.startsWith(board.fVendorName)) {
                    desc = String.valueOf(board.fVendorName) + " " + board.fProductName;
                }
                itemList.add(String.format("%s - %s (%s)", board.fName, desc, board.fUniqueId));
            }
            String[] items = itemList.toArray(new String[itemList.size()]);
            this.fGdbServerBoardId.setItems(items);
            this.selectActiveBoard();
        } else {
            this.fGdbServerBoardId.setItems(new String[0]);
            this.registerError("pyOCD gdbserver not found where specified");
        }
    }

    private void updateTargets() {
        String path = this.getPyOCDExecutablePath();
        if (path != null) {
            this.deregisterError("pyOCD gdbserver not found where specified");
            List<PyOCD.Target> targets = PyOCD.getTargets(path);
            if (targets == null) {
                targets = new ArrayList<PyOCD.Target>();
            }
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("target = %s\n", targets);
            }
            Collections.sort(targets, PyOCD.Target.COMPARATOR);
            this.fTargetsByPartNumber = new HashMap<String, PyOCD.Target>();
            this.fTargetsByName = new HashMap<String, PyOCD.Target>();
            ArrayList<String> itemList = new ArrayList<String>();
            for (PyOCD.Target target : targets) {
                itemList.add(String.format("%s", target.fPartNumber));
                this.fTargetsByPartNumber.put(target.fPartNumber, target);
                this.fTargetsByName.put(target.fName, target);
            }
            String[] items = itemList.toArray(new String[itemList.size()]);
            this.fGdbServerTargetName.setItems(items);
            this.selectActiveTarget();
        } else {
            this.fGdbServerTargetName.setItems(new String[0]);
            this.registerError("pyOCD gdbserver not found where specified");
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.initializeFrom() " + configuration.getName());
        }
        this.fConfiguration = configuration;
        try {
            Boolean booleanDefault = this.fPersistentPreferences.getGdbServerDoStart();
            this.fDoStartGdbServer.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", booleanDefault.booleanValue()));
            String stringDefault = this.fPersistentPreferences.getGdbServerExecutable();
            this.fGdbServerExecutable.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerExecutable", stringDefault));
            this.fGdbServerGdbPort.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerGdbPortNumber", 3333)));
            this.fGdbServerTelnetPort.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTelnetPortNumber", 4444)));
            this.fSelectedBoardId = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBoardId", "");
            this.selectActiveBoard();
            this.fGdbServerOverrideTarget.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOverrideTarget", false));
            this.fGdbServerTargetName.setText("");
            this.fGdbServerHaltAtHardFault.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerHaltAtHardFault", true));
            this.fGdbServerStepIntoInterrupts.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerStepIntoInterrutps", false));
            this.fGdbServerFlashMode.select(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashMode", 0));
            this.fGdbServerFlashFastVerify.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashFastVerify", false));
            this.fGdbServerEnableSemihosting.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerEnableSemihosting", true));
            this.fGdbServerUseGdbSyscallsForSemihosting.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerUseGdbSyscalls", false));
            this.fGdbServerBusSpeed.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBusSpeed", 1000000)));
            stringDefault = this.fPersistentPreferences.getGdbServerOtherOptions();
            this.fGdbServerOtherOptions.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOther", stringDefault));
            if (EclipseUtils.isWindows()) {
                this.fDoGdbServerAllocateConsole.setSelection(true);
            } else {
                this.fDoGdbServerAllocateConsole.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateConsole", true));
            }
            this.fDoGdbServerAllocateSemihostingConsole.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateSemihostingConsole", true));
            stringDefault = this.fPersistentPreferences.getGdbClientExecutable();
            String gdbCommandAttr = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringDefault);
            this.fGdbClientExecutable.setText(gdbCommandAttr);
            stringDefault = this.fPersistentPreferences.getGdbClientOtherOptions();
            this.fGdbClientOtherOptions.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherOptions", stringDefault));
            stringDefault = this.fPersistentPreferences.getGdbClientCommands();
            this.fGdbClientOtherCommands.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherCommands", stringDefault));
            this.fTargetIpAddress.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost"));
            int storedPort = 0;
            storedPort = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 0);
            if (storedPort <= 0 || 65535 < storedPort) {
                storedPort = 3333;
            }
            String portString = Integer.toString(storedPort);
            this.fTargetPortNumber.setText(portString);
            this.doStartGdbServerChanged();
            this.overrideTargetChanged();
            this.updateBoards();
            this.updateTargets();
            boolean updateThreadsOnSuspend = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
            this.fUpdateThreadlistOnSuspend.setSelection(updateThreadsOnSuspend);
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.initializeFrom() completed " + configuration.getName());
        }
    }

    public void initializeFromDefaults() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.initializeFromDefaults()");
        }
        this.fDoStartGdbServer.setSelection(true);
        String stringDefault = this.fDefaultPreferences.getGdbServerExecutable();
        this.fGdbServerExecutable.setText(stringDefault);
        this.fGdbServerGdbPort.setText(Integer.toString(3333));
        this.fGdbServerTelnetPort.setText(Integer.toString(4444));
        this.fGdbServerOverrideTarget.setSelection(false);
        this.fGdbServerTargetName.setText("");
        this.fGdbServerHaltAtHardFault.setSelection(true);
        this.fGdbServerStepIntoInterrupts.setSelection(false);
        this.fGdbServerFlashMode.select(0);
        this.fGdbServerFlashFastVerify.setSelection(false);
        this.fGdbServerEnableSemihosting.setSelection(true);
        this.fGdbServerUseGdbSyscallsForSemihosting.setSelection(false);
        this.fGdbServerBusSpeed.setText(Integer.toString(1000000));
        stringDefault = this.fDefaultPreferences.getPyocdConfig();
        this.fGdbServerOtherOptions.setText(stringDefault);
        if (EclipseUtils.isWindows()) {
            this.fDoGdbServerAllocateConsole.setSelection(true);
        } else {
            this.fDoGdbServerAllocateConsole.setSelection(true);
        }
        this.fDoGdbServerAllocateSemihostingConsole.setSelection(true);
        stringDefault = this.fDefaultPreferences.getGdbClientExecutable();
        this.fGdbClientExecutable.setText(stringDefault);
        this.fGdbClientOtherOptions.setText("");
        this.fGdbClientOtherCommands.setText("set mem inaccessible-by-default off\n");
        this.fTargetIpAddress.setText("localhost");
        String portString = Integer.toString(3333);
        this.fTargetPortNumber.setText(portString);
        this.doStartGdbServerChanged();
        this.overrideTargetChanged();
        this.updateBoards();
        this.updateTargets();
        this.fUpdateThreadlistOnSuspend.setSelection(false);
    }

    public String getId() {
        return TAB_ID;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.activated() " + workingCopy.getName());
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.deactivated() " + workingCopy.getName());
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.isValid() " + launchConfig.getName());
        }
        this.setMessage(null);
        boolean result = true;
        if (this.fDoStartGdbServer != null && this.fDoStartGdbServer.getSelection()) {
            String path = this.getPyOCDExecutablePath();
            if (path == null) {
                this.registerError("pyOCD gdbserver not found where specified");
            } else {
                this.deregisterError("pyOCD gdbserver not found where specified");
            }
            if (this.fGdbServerGdbPort != null && this.fGdbServerGdbPort.getText().trim().isEmpty()) {
                this.registerError("pyOCD gdbserver port not specified");
                result = false;
            } else {
                this.deregisterError("pyOCD gdbserver port not specified");
            }
            if (this.fGdbServerTelnetPort != null && this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
                this.registerError("pyOCD telnet port not specified");
                result = false;
            } else {
                this.deregisterError("pyOCD telnet port not specified");
            }
        }
        if (this.fGdbClientExecutable != null && this.fGdbClientExecutable.getText().trim().isEmpty()) {
            this.registerError("gdb client path is not valid");
            result = false;
        } else {
            this.deregisterError("gdb client path is not valid");
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.isValid() " + launchConfig.getName() + " = " + result);
        }
        return result;
    }

    public boolean canSave() {
        if (this.fDoStartGdbServer != null && this.fDoStartGdbServer.getSelection()) {
            if (this.fGdbServerExecutable != null && this.fGdbServerExecutable.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbServerGdbPort != null && this.fGdbServerGdbPort.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbServerTelnetPort != null && this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int port;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.performApply() " + configuration.getName() + ", dirty=" + this.isDirty());
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU MCU PyOCD");
        boolean booleanValue = this.fDoStartGdbServer.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", booleanValue);
        this.fPersistentPreferences.putGdbServerDoStart(booleanValue);
        String stringValue = this.fGdbServerExecutable.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerExecutable", stringValue);
        this.fPersistentPreferences.putGdbServerExecutable(stringValue);
        if (!this.fGdbServerGdbPort.getText().trim().isEmpty()) {
            port = Integer.parseInt(this.fGdbServerGdbPort.getText().trim());
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerGdbPortNumber", port);
        } else {
            Activator.log((String)"empty fGdbServerGdbPort");
        }
        if (!this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
            port = Integer.parseInt(this.fGdbServerTelnetPort.getText().trim());
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTelnetPortNumber", port);
        } else {
            Activator.log((String)"empty fGdbServerTelnetPort");
        }
        if (this.fSelectedBoardId != null) {
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBoardId", this.fSelectedBoardId);
        }
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOverrideTarget", this.fGdbServerOverrideTarget.getSelection());
        String targetPartNumber = this.fGdbServerTargetName.getText().trim();
        String targetName = "";
        if (!targetPartNumber.isEmpty()) {
            PyOCD.Target target = this.fTargetsByPartNumber.get(targetPartNumber);
            targetName = target != null ? target.fName : targetPartNumber;
        }
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTargetName", targetName);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerHaltAtHardFault", this.fGdbServerHaltAtHardFault.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerStepIntoInterrutps", this.fGdbServerStepIntoInterrupts.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashMode", this.fGdbServerFlashMode.getSelectionIndex());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashFastVerify", this.fGdbServerFlashFastVerify.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerEnableSemihosting", this.fGdbServerEnableSemihosting.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerUseGdbSyscalls", this.fGdbServerUseGdbSyscallsForSemihosting.getSelection());
        int freq = Integer.parseInt(this.fGdbServerBusSpeed.getText().trim());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBusSpeed", freq);
        stringValue = this.fGdbServerOtherOptions.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOther", stringValue);
        this.fPersistentPreferences.putGdbServerOtherOptions(stringValue);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateConsole", this.fDoGdbServerAllocateConsole.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateSemihostingConsole", this.fDoGdbServerAllocateSemihostingConsole.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        stringValue = this.fGdbClientExecutable.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringValue);
        this.fPersistentPreferences.putGdbClientExecutable(stringValue);
        stringValue = this.fGdbClientOtherOptions.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherOptions", stringValue);
        this.fPersistentPreferences.putGdbClientOtherOptions(stringValue);
        stringValue = this.fGdbClientOtherCommands.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherCommands", stringValue);
        this.fPersistentPreferences.putGdbClientCommands(stringValue);
        if (this.fDoStartGdbServer.getSelection()) {
            configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost");
            String str = this.fGdbServerGdbPort.getText().trim();
            if (!str.isEmpty()) {
                try {
                    int port2 = Integer.parseInt(str);
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port2);
                }
                catch (NumberFormatException e) {
                    Activator.log((Throwable)e);
                }
            }
        } else {
            String ip = this.fTargetIpAddress.getText().trim();
            configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", ip);
            String str = this.fTargetPortNumber.getText().trim();
            if (!str.isEmpty()) {
                try {
                    int port3 = Integer.valueOf(str);
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port3);
                }
                catch (NumberFormatException e) {
                    Activator.log((Throwable)e);
                }
            }
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
        this.fPersistentPreferences.flush();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.performApply() completed " + configuration.getName() + ", dirty=" + this.isDirty());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU MCU PyOCD");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.setDefaults() " + configuration.getName());
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        boolean defaultBoolean = this.fPersistentPreferences.getGdbServerDoStart();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", defaultBoolean);
        String defaultString = this.fPersistentPreferences.getGdbServerExecutable();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerExecutable", defaultString);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerConnectionAddress", "");
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerGdbPortNumber", 3333);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTelnetPortNumber", 4444);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBoardId", "");
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBoardName", "");
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBusSpeed", 1000000);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOverrideTarget", false);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTargetName", "");
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerHaltAtHardFault", true);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerStepIntoInterrutps", false);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashMode", 0);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashFastVerify", false);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerEnableSemihosting", true);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerUseGdbSyscalls", false);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerLog", "");
        defaultString = this.fPersistentPreferences.getGdbServerOtherOptions();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOther", defaultString);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateConsole", true);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateSemihostingConsole", true);
        defaultString = this.fPersistentPreferences.getGdbClientExecutable();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultString);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        defaultString = this.fPersistentPreferences.getGdbClientOtherOptions();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherOptions", defaultString);
        defaultString = this.fPersistentPreferences.getGdbClientCommands();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherCommands", defaultString);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
    }

    private void registerError(String msg) {
        if (this.fErrors.isEmpty()) {
            this.setErrorMessage(msg);
        }
        this.fErrors.add(msg);
    }

    private void deregisterError(String msg) {
        if (this.fErrors.remove(msg)) {
            if (this.fErrors.isEmpty()) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.fErrors.iterator().next());
            }
        }
    }

    private static class Msgs {
        public static final String INVALID_PYOCD_EXECUTABLE = "pyOCD gdbserver not found where specified";
        public static final String INVALID_GDBSERVER_PORT = "pyOCD gdbserver port not specified";
        public static final String INVALID_TELNET_PORT = "pyOCD telnet port not specified";
        public static final String INVALID_GDBCLIENT_EXECUTABLE = "gdb client path is not valid";

        private Msgs() {
        }
    }
}

