/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.memory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.embedcdt.debug.gdbjtag.Activator;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.PeripheralDMContext;
import org.eclipse.embedcdt.debug.gdbjtag.memory.PeripheralMemoryBlockExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PeripheralMemoryBlockRetrieval
extends DsfMemoryBlockRetrieval {
    private static final String PERIPHERALS_MEMENTO_ID = "org.eclipse.embedcdt.debug.gdbjtag.PERIPHERALS";
    private static final String PERIPHERALS_MEMENTO_COMPAT_ID = "ilg.gnumcueclipse.debug.gdbjtag.PERIPHERALS";
    private static final String DSF_LAUNCH_ID = "org.eclipse.dsf.launch";
    private static final String ATTR_DEBUGGER_MEMORY_BLOCKS = "org.eclipse.dsf.launch.MEMORY_BLOCKS";
    private static final String MEMORY_BLOCK_EXPRESSION_LIST = "memoryBlockExpressionList";
    private static final String ATTR_EXPRESSION_LIST_CONTEXT = "context";
    private static final String MEMORY_BLOCK_EXPRESSION = "memoryBlockExpression";
    private static final String ATTR_MEMORY_BLOCK_EXPR_LABEL = "label";
    private static final String ATTR_MEMORY_BLOCK_EXPR_ADDRESS = "address";
    private static final String CONTEXT_STRING = "Context string";
    private final ILaunchConfiguration fLaunchConfig;
    private List<String> fPersistentPeripherals;

    public PeripheralMemoryBlockRetrieval(String modelId, ILaunchConfiguration config, DsfSession session) throws DebugException {
        super(modelId, config, session);
        this.fLaunchConfig = config;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryBlockRetrieval()");
        }
    }

    public void initialize(IMemory.IMemoryDMContext memoryCtx) {
        super.initialize(memoryCtx);
    }

    public List<String> getPersistentPeripherals() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryBlockRetrieval.getPersistentPeripherals()");
        }
        if (this.fPersistentPeripherals == null) {
            try {
                String memento = this.fLaunchConfig.getAttribute(PERIPHERALS_MEMENTO_ID, "");
                if (memento == null || memento.trim().isEmpty()) {
                    memento = this.fLaunchConfig.getAttribute(PERIPHERALS_MEMENTO_COMPAT_ID, "");
                }
                if (memento != null && !memento.trim().isEmpty()) {
                    this.fPersistentPeripherals = this.parsePeripheralsMemento(memento);
                }
            }
            catch (CoreException coreException) {}
            if (this.fPersistentPeripherals == null) {
                this.fPersistentPeripherals = new ArrayList<String>();
            }
        }
        return this.fPersistentPeripherals;
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String addr, Object context) throws DebugException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryBlockRetrieval.getExtendedMemoryBlock(" + addr + "," + context + ")");
        }
        IMemoryBlockExtension memoryBlockExtension = null;
        if (context instanceof PeripheralDMContext) {
            PeripheralDMContext peripheralDMContext = (PeripheralDMContext)context;
            IMemory.IMemoryDMContext memoryDMContext = null;
            IDMContext dmContext = null;
            if (context instanceof IAdaptable && (dmContext = (IDMContext)((IAdaptable)context).getAdapter(IDMContext.class)) != null) {
                memoryDMContext = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmContext, IMemory.IMemoryDMContext.class);
            }
            if (memoryDMContext == null) {
                return null;
            }
            memoryBlockExtension = new PeripheralMemoryBlockExtension(this, memoryDMContext, this.getModelId(), peripheralDMContext);
        }
        if (memoryBlockExtension != null) {
            return memoryBlockExtension;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryBlockRetrieval.getExtendedMemoryBlock(" + addr + ") super.getExtendedMemoryBlock()");
        }
        memoryBlockExtension = super.getExtendedMemoryBlock(addr, context);
        return memoryBlockExtension;
    }

    public IMemoryBlock getMemoryBlock(long addr, long length) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent event) {
    }

    public void saveMemoryBlocks() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryBlockRetrieval.saveMemoryBlocks()");
        }
        try {
            ILaunchConfigurationWorkingCopy wc = this.fLaunchConfig.getWorkingCopy();
            if (this.fPersistentPeripherals != null) {
                wc.setAttribute(PERIPHERALS_MEMENTO_ID, this.getPeripheralsMemento());
            }
            wc.setAttribute(ATTR_DEBUGGER_MEMORY_BLOCKS, this.getMemoryMemento());
            wc.doSave();
        }
        catch (CoreException e) {
            DsfPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    public String getPeripheralsMemento() throws CoreException {
        IMemoryBlock[] blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IMemoryBlockRetrieval)this);
        Document document = DebugPlugin.newDocument();
        Element expressionList = document.createElement("peripherals");
        IMemoryBlock[] iMemoryBlockArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryBlock block = iMemoryBlockArray[n2];
            if (block instanceof PeripheralMemoryBlockExtension) {
                PeripheralMemoryBlockExtension memoryBlock = (PeripheralMemoryBlockExtension)block;
                Element expression = document.createElement("peripheral");
                expression.setAttribute("name", memoryBlock.getExpression());
                expressionList.appendChild(expression);
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("Remember " + memoryBlock.getExpression());
                }
            }
            ++n2;
        }
        document.appendChild(expressionList);
        return DebugPlugin.serializeDocument((Document)document);
    }

    public String getMemoryMemento() throws CoreException {
        IMemoryBlock[] blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IMemoryBlockRetrieval)this);
        Document document = DebugPlugin.newDocument();
        Element expressionList = document.createElement(MEMORY_BLOCK_EXPRESSION_LIST);
        expressionList.setAttribute(ATTR_EXPRESSION_LIST_CONTEXT, CONTEXT_STRING);
        IMemoryBlock[] iMemoryBlockArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryBlock block = iMemoryBlockArray[n2];
            if (!(block instanceof PeripheralMemoryBlockExtension) && block instanceof IMemoryBlockExtension) {
                IMemoryBlockExtension memoryBlock = (IMemoryBlockExtension)block;
                Element expression = document.createElement(MEMORY_BLOCK_EXPRESSION);
                expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL, memoryBlock.getExpression());
                expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_ADDRESS, memoryBlock.getBigBaseAddress().toString());
                expressionList.appendChild(expression);
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("Remember " + memoryBlock.getExpression());
                }
            }
            ++n2;
        }
        document.appendChild(expressionList);
        return DebugPlugin.serializeDocument((Document)document);
    }

    public List<String> parsePeripheralsMemento(String memento) throws CoreException {
        Element root = DebugPlugin.parseDocument((String)memento);
        if (!root.getNodeName().equalsIgnoreCase("peripherals")) {
            Status status = new Status(4, "org.eclipse.cdt.dsf.gdb", 120, "Memory monitor initialization: invalid memento", null);
            throw new CoreException((IStatus)status);
        }
        ArrayList<String> peripherals = new ArrayList<String>();
        NodeList expressionList = root.getChildNodes();
        int length = expressionList.getLength();
        int i = 0;
        while (i < length) {
            Element entry;
            Node node = expressionList.item(i);
            if (node.getNodeType() == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase("peripheral")) {
                String name = entry.getAttribute("name");
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("Restore " + name);
                }
                peripherals.add(name);
            }
            ++i;
        }
        return peripherals;
    }
}

