/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.datamodel;

import java.math.BigInteger;
import java.util.LinkedList;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdDerivedFromPath;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdFieldDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdObjectDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdUtils;
import org.eclipse.embedcdt.internal.debug.gdbjtag.core.Activator;
import org.eclipse.embedcdt.packs.core.tree.AbstractTreePreOrderIterator;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;

public class SvdRegisterDMNode
extends SvdDMNode {
    private String fDisplayName = null;
    private BigInteger fAddressOffset = null;
    private Integer fSize = null;
    private BigInteger fBigSizeBytes = null;
    private BigInteger fBigRepeatIncrement = null;
    private String fReadAction = null;
    private String fResetValue = null;
    private String fResetMask = null;

    public SvdRegisterDMNode(Leaf node) {
        super(node);
    }

    public SvdRegisterDMNode(Leaf node, String displayName, BigInteger addressOffset) {
        this(node);
        this.fDisplayName = displayName;
        this.fAddressOffset = addressOffset;
    }

    @Override
    public void dispose() {
        this.fDisplayName = null;
        this.fAddressOffset = null;
        this.fSize = null;
        this.fBigSizeBytes = null;
        this.fBigRepeatIncrement = null;
        this.fReadAction = null;
        this.fResetValue = null;
        this.fResetMask = null;
        super.dispose();
    }

    @Override
    protected SvdObjectDMNode[] prepareChildren(Leaf node) {
        if (node == null || !node.hasChildren()) {
            return null;
        }
        Leaf group = ((Node)node).findChild("fields");
        if (!group.hasChildren()) {
            return null;
        }
        LinkedList<SvdFieldDMNode> list = new LinkedList<SvdFieldDMNode>();
        for (Leaf child : ((Node)group).getChildren()) {
            if (!child.isType("field")) continue;
            list.add(new SvdFieldDMNode(child));
        }
        SvdObjectDMNode[] array = list.toArray(new SvdObjectDMNode[list.size()]);
        return array;
    }

    @Override
    protected Leaf findDerivedFromNode() {
        String derivedFromName = this.getNode().getPropertyOrNull("derivedFrom");
        final SvdDerivedFromPath path = SvdDerivedFromPath.createRegisterPath(derivedFromName);
        if (path == null) {
            return null;
        }
        Node root = this.getNode().getParent();
        while (!root.isType("device")) {
            root = root.getParent();
        }
        AbstractTreePreOrderIterator peripheralNodes = new AbstractTreePreOrderIterator(){

            public boolean isIterable(Leaf node) {
                String clustersElement = "";
                if (node.getPackType() == Node.PACK_TYPE_CMSIS) {
                    clustersElement = "cluster";
                } else if (node.getPackType() == Node.PACK_TYPE_XPACK) {
                    clustersElement = "clusters";
                }
                if (node.isType("peripherals")) {
                    return true;
                }
                if (node.isType("peripheral")) {
                    if (path.peripheralName == null) {
                        return true;
                    }
                    return path.peripheralName.equals(node.getName());
                }
                if (node.isType("registers")) {
                    return true;
                }
                if (node.isType(clustersElement)) {
                    return true;
                }
                if (node.isType("register")) {
                    if (path.registerName == null) {
                        return true;
                    }
                    return path.registerName.equals(node.getName());
                }
                return false;
            }

            public boolean isLeaf(Leaf node) {
                return node.isType("register");
            }
        };
        peripheralNodes.setTreeNode((Leaf)root);
        Leaf ret = null;
        for (Leaf node : peripheralNodes) {
            if (!node.isType("register")) continue;
            if (ret == null) {
                ret = node;
                continue;
            }
            Activator.log((String)("Non unique SVD path " + path));
        }
        return ret;
    }

    @Override
    public BigInteger getBigAddressOffset() {
        if (this.fAddressOffset == null) {
            try {
                String offset = this.getNode().getProperty("addressOffset");
                if (!offset.isEmpty()) {
                    this.fAddressOffset = SvdUtils.parseScaledNonNegativeBigInteger(offset);
                } else {
                    Activator.log((String)("Missing addressOffset, node " + this.getNode()));
                    this.fAddressOffset = BigInteger.ZERO;
                }
            }
            catch (NumberFormatException e) {
                Activator.log((String)("Bad offset, node " + this.getNode()));
                this.fAddressOffset = BigInteger.ZERO;
            }
        }
        return this.fAddressOffset;
    }

    @Override
    public String getDisplayName() {
        if (this.fDisplayName == null) {
            this.fDisplayName = this.getPropertyWithDerived("displayName", this.getName());
        }
        return this.fDisplayName;
    }

    @Override
    public int getWidthBits() {
        if (this.fSize == null) {
            String size = "32";
            assert (this.getNode() != null) : "getWidthBits() of " + this;
            if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
                size = this.getPropertyWithDerivedWithParent("size", "32");
            } else if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
                size = this.getPropertyWithDerivedWithParent("regWidth", "32");
            }
            try {
                this.fSize = SvdUtils.parseScaledNonNegativeBigInteger(size).intValue();
            }
            catch (NumberFormatException e) {
                Activator.log((String)("Bad size, node " + this.getNode()));
                this.fSize = 32;
            }
        }
        return this.fSize;
    }

    @Override
    public BigInteger getBigSizeBytes() {
        if (this.fBigSizeBytes == null) {
            String sizeBytes = String.valueOf((this.getWidthBits() + 7) / 8);
            this.fBigSizeBytes = new BigInteger(sizeBytes);
        }
        return this.fBigSizeBytes;
    }

    @Override
    public BigInteger getBigRepeatIncrement() {
        if (this.fBigRepeatIncrement == null) {
            this.fBigRepeatIncrement = this.getBigSizeBytes();
            BigInteger arrayAddressIncrement = this.getBigArrayAddressIncrement();
            if (arrayAddressIncrement != BigInteger.ZERO && arrayAddressIncrement.compareTo(this.fBigRepeatIncrement) > 0) {
                this.fBigRepeatIncrement = arrayAddressIncrement;
            }
        }
        return this.fBigRepeatIncrement;
    }

    @Override
    public String getReadAction() {
        if (this.fReadAction == null) {
            this.fReadAction = this.getPropertyWithDerivedWithParent("readAction");
        }
        return this.fReadAction;
    }

    public String getResetValue() {
        if (this.fResetValue == null) {
            this.fResetValue = this.getPropertyWithDerivedWithParent("resetValue");
        }
        return this.fResetValue;
    }

    public String getResetMask() {
        if (this.fResetMask == null) {
            this.fResetMask = this.getPropertyWithDerivedWithParent("resetMask");
        }
        return this.fResetMask;
    }

    @Override
    public String toString() {
        String hexAddr = String.format("0x%08X", this.getBigAddressOffset().longValue());
        return "[" + this.getClass().getSimpleName() + ": " + this.getDisplayName() + ", " + hexAddr + ", " + this.getAccess() + ", \"" + this.getDescription() + "\"]";
    }
}

