/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;

public class Shell
extends Decorations {
    boolean showWithParent;
    boolean fullScreen;
    boolean wasMaximized;
    boolean modified;
    boolean center;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0L, false);
    }

    public Shell(Shell parent) {
    }

    public Shell(Shell parent, int style) {
    }

    public static Shell win32_new(Display display, long handle) {
        return new Shell(display, null, 8, handle, true);
    }

    public static Shell internal_new(Display display, long handle) {
        return new Shell(display, null, 8, handle, false);
    }

    Shell(Display display, Shell parent, int style, long handle, boolean embedded) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        this.center = parent != null && (style & 0x10000000) != 0;
        this.style = Shell.checkStyle(parent, style);
        this.parent = parent;
        this.display = display;
        this.handle = handle;
        if (handle != 0L && !embedded) {
            this.state |= 0x4000;
        }
        this.reskinWidget();
        this.createWidget();
    }

    static int checkStyle(Shell parent, int style) {
        style = Decorations.checkStyle(style);
        int mask = 229376;
        if (((style &= 0xBFFFFFFF) & 0x10000000) != 0) {
            style &= 0xEFFFFFFF;
            if (((style |= parent == null ? 1264 : 2144) & mask) == 0) {
                style |= parent == null ? 65536 : 32768;
            }
        }
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }
}

