/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.runtime.ui;

import com.google.inject.Injector;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.parsley.runtime.ui.PluginUtil;
import org.osgi.framework.Bundle;

public abstract class AbstractGuiceAwareExecutableExtensionFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    public static final String GUICEKEY = "guicekey";
    protected Logger log = Logger.getLogger(this.getClass());
    protected String clazzName;
    protected IConfigurationElement config;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.clazzName = (String)data;
        } else if (data instanceof Map) {
            this.clazzName = (String)((Map)data).get(GUICEKEY);
        }
        if (this.clazzName == null) {
            throw new IllegalArgumentException("couldn't handle passed data : " + String.valueOf(data));
        }
        this.config = config;
    }

    public Object create() throws CoreException {
        try {
            Class clazz = this.getBundle().loadClass(this.clazzName);
            Injector injector = this.getInjector();
            Object result = injector.getInstance(clazz);
            if (result instanceof IExecutableExtension) {
                ((IExecutableExtension)result).setInitializationData(this.config, null, null);
            }
            return result;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), e.getMessage() + " ExtensionFactory: " + this.getClass().getName(), (Throwable)e));
        }
    }

    protected Bundle getBundle() {
        return PluginUtil.getBundle(this.getClass());
    }

    protected abstract Injector getInjector() throws Exception;
}

