/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind;

import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntries;
import org.eclipse.emfcloud.jackson.databind.type.EcoreTypeFactory;
import org.eclipse.emfcloud.jackson.handlers.URIHandler;

public final class EMFContext {
    private EMFContext() {
    }

    public static void init(Resource resource, DatabindContext context) {
        if (context.getAttribute((Object)Internals.INIT) != null) {
            return;
        }
        ReferenceEntries entries = new ReferenceEntries();
        EcoreTypeFactory ecoreType = new EcoreTypeFactory();
        ResourceSet resourceSet = resource.getResourceSet();
        context.setAttribute((Object)Attributes.RESOURCE, (Object)resource);
        context.setAttribute((Object)Attributes.RESOURCE_SET, (Object)resourceSet);
        context.setAttribute((Object)Internals.REFERENCE_ENTRIES, (Object)entries);
        context.setAttribute((Object)Internals.TYPE_FACTORY, (Object)ecoreType);
        context.setAttribute((Object)Internals.INIT, (Object)true);
    }

    public static void prepare(DatabindContext ctxt) {
        if (ctxt.getAttribute((Object)Internals.INIT) != null) {
            return;
        }
        if (EMFContext.getResourceSet(ctxt) == null) {
            ctxt.setAttribute((Object)Attributes.RESOURCE_SET, (Object)new ResourceSetImpl());
        }
        if (EMFContext.getEntries(ctxt) == null) {
            ctxt.setAttribute((Object)Internals.REFERENCE_ENTRIES, (Object)new ReferenceEntries());
        }
    }

    public static ContextAttributes from(Map<?, ?> options) {
        return ContextAttributes.getEmpty().withSharedAttributes(options == null ? new HashMap() : new HashMap(options));
    }

    public static void resolve(DeserializationContext ctxt, URIHandler handler) {
        ReferenceEntries entries = EMFContext.getEntries((DatabindContext)ctxt);
        if (entries != null) {
            entries.resolve((DatabindContext)ctxt, handler);
        }
    }

    public static URI getURI(DatabindContext ctxt, EObject object) {
        URI uri;
        if (object == null) {
            return null;
        }
        HashMap<EObject, URI> objects = (HashMap<EObject, URI>)ctxt.getAttribute((Object)Internals.MAP_OF_OBJECTS);
        if (objects == null) {
            objects = new HashMap<EObject, URI>();
            ctxt.setAttribute((Object)Internals.MAP_OF_OBJECTS, objects);
        }
        if ((uri = (URI)objects.get(object)) == null) {
            uri = EcoreUtil.getURI((EObject)object);
            objects.put(object, uri);
        }
        return uri;
    }

    public static EClass findEClass(DatabindContext ctxt, String uri) {
        EObject object;
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        HashMap<String, EObject> uris = (HashMap<String, EObject>)ctxt.getAttribute((Object)Internals.MAP_OF_URIS);
        if (uris == null) {
            uris = new HashMap<String, EObject>();
            ctxt.setAttribute((Object)Internals.MAP_OF_URIS, uris);
        }
        if ((object = (EObject)uris.get(uri)) instanceof EClass) {
            return (EClass)object;
        }
        ResourceSet resourceSet = EMFContext.getResourceSet(ctxt);
        if (resourceSet == null) {
            return null;
        }
        object = resourceSet.getEObject(URI.createURI((String)uri), true);
        if (object instanceof EClass) {
            uris.put(uri, object);
            return (EClass)object;
        }
        return null;
    }

    public static EClass findEClassByName(DatabindContext ctxt, String name) {
        Set<EClass> types = (Set<EClass>)ctxt.getAttribute((Object)Internals.ALL_TYPES);
        if (types == null) {
            types = EMFContext.initAllTypes(ctxt);
        }
        return types.stream().filter(EMFContext.findByName(name)).findFirst().orElse(null);
    }

    public static EClass findEClassByQualifiedName(DatabindContext ctxt, String name) {
        Set<EClass> types = (Set<EClass>)ctxt.getAttribute((Object)Internals.ALL_TYPES);
        if (types == null) {
            types = EMFContext.initAllTypes(ctxt);
        }
        return types.stream().filter(EMFContext.findByQualifiedName(name)).findFirst().orElse(null);
    }

    private static Set<EClass> initAllTypes(DatabindContext ctxt) {
        EPackage.Registry global = EPackage.Registry.INSTANCE;
        ResourceSet resourceSet = EMFContext.getResourceSet(ctxt);
        EPackage.Registry local = resourceSet.getPackageRegistry();
        HashMap registry = new HashMap();
        registry.putAll(global);
        registry.putAll(local);
        Set<EClass> types = registry.values().stream().map(e -> {
            if (e instanceof EPackage.Descriptor) {
                return ((EPackage.Descriptor)e).getEPackage();
            }
            if (e instanceof EPackage) {
                return (EPackage)e;
            }
            return null;
        }).filter(Objects::nonNull).flatMap(e -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(e.eAllContents(), 16), false)).filter(e -> e instanceof EClass).map(e -> (EClass)e).collect(Collectors.toSet());
        ctxt.setAttribute((Object)Internals.ALL_TYPES, types);
        return types;
    }

    public static EClass findEClassByName(String value, EPackage ePackage) {
        return EMFContext.iterateAndFind(Collections.singleton(ePackage), EMFContext.findByName(value));
    }

    public static EClass findEClassByQualifiedName(String value, EPackage ePackage) {
        return EMFContext.iterateAndFind(Collections.singleton(ePackage), EMFContext.findByQualifiedName(value));
    }

    private static Predicate<EObject> findByName(String value) {
        return e -> value != null && e instanceof EClass && value.equals(((EClass)e).getName());
    }

    private static Predicate<EObject> findByQualifiedName(String value) {
        return e -> value != null && e instanceof EClass && value.equals(((EClass)e).getInstanceClassName());
    }

    private static EClass iterateAndFind(Collection<Object> packages, Predicate<EObject> predicate) {
        return packages.stream().flatMap(e -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(((EPackage)e).eAllContents(), 16), false)).filter(e -> e instanceof EClass).filter(predicate).findFirst().orElse(null);
    }

    public static Resource getResource(DatabindContext ctxt, EObject object) {
        Resource resource;
        HashMap<EObject, Resource> resources = (HashMap<EObject, Resource>)ctxt.getAttribute((Object)Internals.MAP_OF_RESOURCES);
        if (resources == null) {
            resources = new HashMap<EObject, Resource>();
            ctxt.setAttribute((Object)Internals.MAP_OF_RESOURCES, resources);
        }
        if ((resource = (Resource)resources.get(object)) == null) {
            if (object instanceof InternalEObject) {
                resource = ((InternalEObject)object).eDirectResource();
            }
            if (resource == null) {
                resource = object.eResource();
            }
            resources.put(object, resource);
        }
        return resource;
    }

    public static ResourceSet getResourceSet(DatabindContext context) {
        ResourceSet resourceSet;
        try {
            resourceSet = (ResourceSet)context.getAttribute((Object)Attributes.RESOURCE_SET);
        }
        catch (ClassCastException e) {
            resourceSet = null;
        }
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
            context.setAttribute((Object)Attributes.RESOURCE_SET, (Object)resourceSet);
        }
        return resourceSet;
    }

    public static Resource getResource(DatabindContext context) {
        try {
            return (Resource)context.getAttribute((Object)Attributes.RESOURCE);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static URI getURI(DatabindContext context) {
        try {
            return (URI)context.getAttribute((Object)Attributes.RESOURCE_URI);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static EClass getRoot(DatabindContext context) {
        try {
            return (EClass)context.getAttribute((Object)Attributes.ROOT_ELEMENT);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static EObject getParent(DatabindContext ctxt) {
        try {
            return (EObject)ctxt.getAttribute((Object)Internals.CURRENT_PARENT);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static EReference getReference(DatabindContext ctxt) {
        try {
            return (EReference)ctxt.getAttribute((Object)Internals.CURRENT_FEATURE);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static EStructuralFeature getFeature(DatabindContext ctxt) {
        try {
            return (EStructuralFeature)ctxt.getAttribute((Object)Internals.CURRENT_FEATURE);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static EDataType getDataType(DatabindContext ctxt) {
        try {
            return (EDataType)ctxt.getAttribute((Object)Internals.CURRENT_DATATYPE);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static ReferenceEntries getEntries(DatabindContext ctxt) {
        try {
            return (ReferenceEntries)ctxt.getAttribute((Object)Internals.REFERENCE_ENTRIES);
        }
        catch (ClassCastException e) {
            ReferenceEntries entries = new ReferenceEntries();
            ctxt.setAttribute((Object)Internals.REFERENCE_ENTRIES, (Object)entries);
            return entries;
        }
    }

    public static void setParent(DatabindContext ctxt, EObject parent) {
        ctxt.setAttribute((Object)Internals.CURRENT_PARENT, (Object)parent);
    }

    public static void setFeature(DatabindContext ctxt, EStructuralFeature feature) {
        ctxt.setAttribute((Object)Internals.CURRENT_FEATURE, (Object)feature);
    }

    public static void setDataType(DatabindContext ctxt, EClassifier type) {
        ctxt.setAttribute((Object)Internals.CURRENT_DATATYPE, (Object)type);
    }

    public static EcoreTypeFactory getTypeFactory(DatabindContext ctxt) {
        EcoreTypeFactory factory = (EcoreTypeFactory)ctxt.getAttribute((Object)Internals.TYPE_FACTORY);
        if (factory == null) {
            factory = new EcoreTypeFactory();
            ctxt.setAttribute((Object)Internals.TYPE_FACTORY, (Object)factory);
        }
        return factory;
    }

    public static List<EClass> allSubTypes(DatabindContext ctxt, EClass eClass) {
        ArrayList<EClass> subTypes;
        if (eClass == null) {
            return Collections.emptyList();
        }
        HashMap subTypeMap = (HashMap)ctxt.getAttribute((Object)Internals.MAP_OF_SUB_TYPES);
        if (subTypeMap == null) {
            subTypeMap = new HashMap();
            ctxt.setAttribute((Object)Internals.MAP_OF_SUB_TYPES, subTypeMap);
        }
        if ((subTypes = (ArrayList<EClass>)subTypeMap.get(eClass)) == null) {
            subTypes = new ArrayList<EClass>();
            Set<EClass> allTypes = (Set<EClass>)ctxt.getAttribute((Object)Internals.ALL_TYPES);
            if (allTypes == null) {
                allTypes = EMFContext.initAllTypes(ctxt);
            }
            for (EClass type : allTypes) {
                if (type.isAbstract() || !eClass.isSuperTypeOf(type)) continue;
                subTypes.add(type);
            }
            subTypeMap.put(eClass, subTypes);
        }
        return subTypes;
    }

    static enum Internals {
        INIT,
        TYPE_FACTORY,
        REFERENCE_ENTRIES,
        CURRENT_DATATYPE,
        CURRENT_FEATURE,
        CURRENT_PARENT,
        MAP_OF_OBJECTS,
        MAP_OF_URIS,
        MAP_OF_RESOURCES,
        MAP_OF_SUB_TYPES,
        ALL_TYPES;

    }

    public static enum Attributes {
        RESOURCE_SET,
        RESOURCE_URI,
        RESOURCE,
        ROOT_ELEMENT;

    }
}

