/**
 */
package org.eclipse.emfcloud.jackson.junit.caravan;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Document Root</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getMixed <em>Mixed</em>}</li>
 *   <li>{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}</li>
 *   <li>{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getXSISchemaLocation <em>XSI Schema Location</em>}</li>
 *   <li>{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getCaravan <em>Caravan</em>}</li>
 *   <li>{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getLonePerson <em>Lone Person</em>}</li>
 * </ul>
 *
 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanPackage#getDocumentRoot()
 * @model extendedMetaData="name='' kind='mixed'"
 * @generated
 */
public interface DocumentRoot extends EObject {
	/**
	 * Returns the value of the '<em><b>Mixed</b></em>' attribute list.
	 * The list contents are of type {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mixed</em>' attribute list.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanPackage#getDocumentRoot_Mixed()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry" many="true"
	 *        extendedMetaData="kind='elementWildcard' name=':mixed'"
	 * @generated
	 */
	FeatureMap getMixed();

	/**
	 * Returns the value of the '<em><b>XMLNS Prefix Map</b></em>' map.
	 * The key is of type {@link java.lang.String},
	 * and the value is of type {@link java.lang.String},
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>XMLNS Prefix Map</em>' map.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanPackage#getDocumentRoot_XMLNSPrefixMap()
	 * @model mapType="org.eclipse.emf.ecore.EStringToStringMapEntry&lt;org.eclipse.emf.ecore.EString, org.eclipse.emf.ecore.EString&gt;" transient="true"
	 *        extendedMetaData="kind='attribute' name='xmlns:prefix'"
	 * @generated
	 */
	EMap<String, String> getXMLNSPrefixMap();

	/**
	 * Returns the value of the '<em><b>XSI Schema Location</b></em>' map.
	 * The key is of type {@link java.lang.String},
	 * and the value is of type {@link java.lang.String},
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>XSI Schema Location</em>' map.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanPackage#getDocumentRoot_XSISchemaLocation()
	 * @model mapType="org.eclipse.emf.ecore.EStringToStringMapEntry&lt;org.eclipse.emf.ecore.EString, org.eclipse.emf.ecore.EString&gt;" transient="true"
	 *        extendedMetaData="kind='attribute' name='xsi:schemaLocation'"
	 * @generated
	 */
	EMap<String, String> getXSISchemaLocation();

	/**
	 * Returns the value of the '<em><b>Caravan</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Caravan</em>' containment reference.
	 * @see #setCaravan(CaravanType)
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanPackage#getDocumentRoot_Caravan()
	 * @model containment="true" upper="-2" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='Caravan' namespace='##targetNamespace'"
	 * @generated
	 */
	CaravanType getCaravan();

	/**
	 * Sets the value of the '{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getCaravan <em>Caravan</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Caravan</em>' containment reference.
	 * @see #getCaravan()
	 * @generated
	 */
	void setCaravan(CaravanType value);

	/**
	 * Returns the value of the '<em><b>Lone Person</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Lone Person</em>' containment reference.
	 * @see #setLonePerson(Person)
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanPackage#getDocumentRoot_LonePerson()
	 * @model containment="true" upper="-2" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='LonePerson' namespace='##targetNamespace'"
	 * @generated
	 */
	Person getLonePerson();

	/**
	 * Sets the value of the '{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getLonePerson <em>Lone Person</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Lone Person</em>' containment reference.
	 * @see #getLonePerson()
	 * @generated
	 */
	void setLonePerson(Person value);

} // DocumentRoot
