/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.controller;

import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.callbacks.ESCommitCallback;
import org.eclipse.emf.emfstore.client.exceptions.ESProjectNotSharedException;
import org.eclipse.emf.emfstore.client.observer.ESCommitObserver;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.common.model.ESModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.client.common.UnknownEMFStoreWorkloadCommand;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ModelElementIdToEObjectMappingImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.exceptions.ESUpdateRequiredException;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitController
extends ServerCall<PrimaryVersionSpec> {
    private final String logMessage;
    private final ESCommitCallback callback;
    private final BranchVersionSpec branch;

    public CommitController(ProjectSpaceBase projectSpace, String logMessage, ESCommitCallback callback, IProgressMonitor monitor) {
        this(projectSpace, null, logMessage, callback, monitor);
    }

    public CommitController(ProjectSpaceBase projectSpace, BranchVersionSpec branch, String logMessage, ESCommitCallback callback, IProgressMonitor monitor) {
        super(projectSpace);
        this.branch = branch;
        this.logMessage = logMessage == null ? Messages.CommitController_NoMessage : logMessage;
        this.callback = callback == null ? ESCommitCallback.NOCALLBACK : callback;
        this.setProgressMonitor(monitor);
    }

    @Override
    protected PrimaryVersionSpec run() throws ESException {
        return this.commit(this.logMessage, this.branch);
    }

    private PrimaryVersionSpec commit(String logMessage, BranchVersionSpec branch) throws InvalidVersionSpecException, ESUpdateRequiredException, ESException {
        if (!this.getProjectSpace().isShared()) {
            throw new ESProjectNotSharedException();
        }
        this.getProgressMonitor().beginTask(Messages.CommitController_CommitingChanges, 100);
        this.getProgressMonitor().worked(1);
        this.getProgressMonitor().subTask(Messages.CommitController_CheckingChanges);
        if (!this.getProjectSpace().isDirty() && branch == null) {
            this.callback.noLocalChanges(this.getProjectSpace().toAPI());
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProjectSpace().cleanCutElements();
        this.getProgressMonitor().subTask(Messages.CommitController_ResolvingNewVersion);
        this.checkForCommitPreconditions(branch, this.getProgressMonitor());
        this.getProgressMonitor().worked(10);
        this.getProgressMonitor().subTask(Messages.CommitController_GatheringChanges);
        ChangePackage changePackage = this.getProjectSpace().getLocalChangePackage();
        this.setLogMessage(logMessage, changePackage);
        ((ESCommitObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESCommitObserver.class)).inspectChanges(this.getProjectSpace().toAPI(), (ESChangePackage)changePackage.toAPI(), this.getProgressMonitor());
        ModelElementIdToEObjectMappingImpl idToEObjectMapping = new ModelElementIdToEObjectMappingImpl(this.getProjectSpace().getProject(), changePackage);
        this.getProgressMonitor().subTask(Messages.CommitController_PresentingChanges);
        if (!this.callback.inspectChanges(this.getProjectSpace().toAPI(), (ESChangePackage)changePackage.toAPI(), (ESModelElementIdToEObjectMapping)idToEObjectMapping.toAPI()) || this.getProgressMonitor().isCanceled()) {
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProgressMonitor().subTask(Messages.CommitController_SendingFilesToServer);
        this.getProjectSpace().getFileTransferManager().uploadQueuedFiles(this.getProgressMonitor());
        this.getProgressMonitor().worked(30);
        this.getProgressMonitor().subTask(Messages.CommitController_SendingChangesToServer);
        boolean updatePerformed = this.checkForCommitPreconditions(branch, this.getProgressMonitor());
        if (updatePerformed) {
            this.getProgressMonitor().subTask("Presenting Changes");
            if (!this.callback.inspectChanges(this.getProjectSpace().toAPI(), (ESChangePackage)changePackage.toAPI(), (ESModelElementIdToEObjectMapping)idToEObjectMapping.toAPI()) || this.getProgressMonitor().isCanceled()) {
                return this.getProjectSpace().getBaseVersion();
            }
        }
        final PrimaryVersionSpec newBaseVersion = this.performCommit(branch, changePackage);
        this.getProgressMonitor().worked(35);
        this.getProgressMonitor().subTask("Sending files to server");
        this.getProjectSpace().getFileTransferManager().uploadQueuedFiles(this.getProgressMonitor());
        this.getProgressMonitor().worked(30);
        this.getProgressMonitor().subTask(Messages.CommitController_ComputingChecksum);
        this.handleChecksumProcessing(newBaseVersion);
        this.getProgressMonitor().subTask(Messages.CommitController_FinalizingCommit);
        RunESCommand.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CommitController.this.getProjectSpace().setBaseVersion(newBaseVersion);
                CommitController.this.getProjectSpace().getOperations().clear();
                CommitController.this.getProjectSpace().setMergedVersion(null);
                CommitController.this.getProjectSpace().updateDirtyState();
                return null;
            }
        });
        ((ESCommitObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESCommitObserver.class)).commitCompleted(this.getProjectSpace().toAPI(), (ESPrimaryVersionSpec)newBaseVersion.toAPI(), this.getProgressMonitor());
        return newBaseVersion;
    }

    private void handleChecksumProcessing(PrimaryVersionSpec newBaseVersion) throws ESException {
        boolean validChecksum = true;
        try {
            validChecksum = this.performChecksumCheck(newBaseVersion, this.getProjectSpace().getProject());
        }
        catch (SerializationException exception) {
            WorkspaceUtil.logWarning(MessageFormat.format(Messages.CommitController_ChecksumComputationFailed, this.getProjectSpace().getProjectName()), (Exception)((Object)exception));
        }
        if (!validChecksum) {
            this.getProgressMonitor().subTask(Messages.CommitController_InvalidChecksum);
            boolean errorHandled = Configuration.getClientBehavior().getChecksumErrorHandler().execute(this.getProjectSpace().toAPI(), (ESPrimaryVersionSpec)newBaseVersion.toAPI(), this.getProgressMonitor());
            if (!errorHandled) {
                throw new ESException(Messages.CommitController_CommitCancelled_InvalidChecksum);
            }
        }
    }

    private PrimaryVersionSpec performCommit(final BranchVersionSpec branch, final ChangePackage changePackage) throws ESException {
        PrimaryVersionSpec newBaseVersion = (PrimaryVersionSpec)new UnknownEMFStoreWorkloadCommand<PrimaryVersionSpec>(this.getProgressMonitor()){

            @Override
            public PrimaryVersionSpec run(IProgressMonitor monitor) throws ESException {
                return CommitController.this.getConnectionManager().createVersion(CommitController.this.getUsersession().getSessionId(), CommitController.this.getProjectSpace().getProjectId(), CommitController.this.getProjectSpace().getBaseVersion(), changePackage, branch, CommitController.this.getProjectSpace().getMergedVersion(), changePackage.getLogMessage());
            }
        }.execute();
        return newBaseVersion;
    }

    private void setLogMessage(final String logMessage, final ChangePackage changePackage) {
        RunESCommand.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LogMessage logMessageObject = VersioningFactory.eINSTANCE.createLogMessage();
                logMessageObject.setMessage(logMessage);
                logMessageObject.setClientDate(new Date());
                logMessageObject.setAuthor(CommitController.this.getProjectSpace().getUsersession().getUsername());
                changePackage.setLogMessage(logMessageObject);
                return null;
            }
        });
    }

    private boolean performChecksumCheck(PrimaryVersionSpec newBaseVersion, Project project) throws SerializationException {
        if (Configuration.getClientBehavior().isChecksumCheckActive()) {
            long computedChecksum = ModelUtil.computeChecksum((IdEObjectCollection)project);
            return computedChecksum == newBaseVersion.getProjectStateChecksum();
        }
        return true;
    }

    private boolean checkForCommitPreconditions(BranchVersionSpec branch, IProgressMonitor monitor) throws InvalidVersionSpecException, ESException, ESUpdateRequiredException {
        if (branch != null) {
            if (StringUtils.isEmpty((String)branch.getBranch())) {
                throw new InvalidVersionSpecException(Messages.CommitController_EmptyBranchName);
            }
            PrimaryVersionSpec potentialBranch = null;
            try {
                potentialBranch = this.getProjectSpace().resolveVersionSpec((VersionSpec)branch, monitor);
            }
            catch (InvalidVersionSpecException invalidVersionSpecException) {}
            if (potentialBranch != null) {
                throw new InvalidVersionSpecException(Messages.CommitController_BranchAlreadyExists);
            }
        } else {
            PrimaryVersionSpec resolvedVersion = this.getProjectSpace().resolveVersionSpec((VersionSpec)Versions.createHEAD((VersionSpec)this.getProjectSpace().getBaseVersion()), monitor);
            if (!this.getProjectSpace().getBaseVersion().equals(resolvedVersion)) {
                if (!this.callback.baseVersionOutOfDate(this.getProjectSpace().toAPI(), this.getProgressMonitor())) {
                    throw new ESUpdateRequiredException();
                }
                return true;
            }
        }
        return false;
    }
}

