/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.handlers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.ui.handlers.AbstractEMFStoreHandler;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.HistoryBrowserView;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadChangePackagesHandler
extends AbstractEMFStoreHandler {
    public static <T> List<T> getSelection(ExecutionEvent event, Class<T> clazz) {
        ArrayList result = new ArrayList();
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel == null) {
            sel = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        }
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)sel;
            for (Object selectedElement : structuredSelection) {
                if (!clazz.isInstance(selectedElement)) continue;
                result.add(selectedElement);
            }
        }
        return result;
    }

    @Override
    public void handle() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        if (!(activePage.getActivePart() instanceof HistoryBrowserView)) {
            return;
        }
        HistoryBrowserView view = (HistoryBrowserView)activePage.getActivePart();
        ProjectSpace projectSpace = view.getProjectSpace();
        ESWorkspaceProviderImpl esWorkspaceProviderImpl = ESWorkspaceProviderImpl.getInstance();
        ConnectionManager connectionManager = esWorkspaceProviderImpl.getConnectionManager();
        ProjectId projectId = projectSpace.getProjectId();
        SessionId sessionId = projectSpace.getUsersession().getSessionId();
        List<HistoryInfo> historyInfos = LoadChangePackagesHandler.getSelection(this.getEvent(), HistoryInfo.class);
        for (HistoryInfo historyInfo : historyInfos) {
            PrimaryVersionSpec fromSpec = (PrimaryVersionSpec)ModelUtil.clone((EObject)historyInfo.getPreviousSpec());
            PrimaryVersionSpec toSpec = (PrimaryVersionSpec)ModelUtil.clone((EObject)historyInfo.getPrimarySpec());
            if (!this.isValid(fromSpec) || !this.isValid(toSpec)) continue;
            try {
                List changes = connectionManager.getChanges(sessionId, projectId, (VersionSpec)fromSpec, (VersionSpec)toSpec);
                if (changes.size() != 1) {
                    ModelUtil.log((String)MessageFormat.format("Expected to retrieve one change package but got {0}", changes.size()), null, (int)4);
                } else {
                    historyInfo.setChangePackage((AbstractChangePackage)changes.get(0));
                }
            }
            catch (ESException ex) {
                ModelUtil.log((String)MessageFormat.format("Could not load changes for history info {0}", historyInfo), (Throwable)ex, (int)4);
            }
            view.refresh(historyInfo);
        }
    }

    private boolean isValid(PrimaryVersionSpec spec) {
        return spec != null && spec.getIdentifier() > -1;
    }
}

