/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.options.MergeTextOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AttributeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.UnkownFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeConflict
extends VisualConflict {
    public AttributeConflict(ConflictBucket conflictBucket, DecisionManager decisionManager) {
        super(conflictBucket, decisionManager);
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        description.setDescription(DecisionUtil.getDescription("attributeconflict", this.getDecisionManager().isBranchMerge()));
        description.add("myvalue", this.getMyOperation(AttributeOperation.class).getNewValue());
        description.add("oldvalue", this.getMyOperation(AttributeOperation.class).getOldValue());
        description.add("theirvalue", this.getTheirOperation(AttributeOperation.class).getNewValue());
        description.setImage("attribute.gif");
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        this.initOptionsWithOutMerge(options, true);
    }

    protected void initOptionsWithOutMerge(List<ConflictOption> options, boolean withMerge) {
        AttributeOperation attributeOperation = this.getMyOperation(AttributeOperation.class);
        ConflictOption myOption = new ConflictOption(attributeOperation.getNewValue(), ConflictOption.OptionType.MyOperation);
        myOption.setDetailProvider("org.eclipse.emf.emfstore.client.ui.merge.widget.multiline");
        myOption.addOperations(this.getMyOperations());
        options.add(myOption);
        ConflictOption theirOption = new ConflictOption(this.getTheirOperation(AttributeOperation.class).getNewValue(), ConflictOption.OptionType.TheirOperation);
        theirOption.setDetailProvider("org.eclipse.emf.emfstore.client.ui.merge.widget.multiline");
        theirOption.addOperations(this.getTheirOperations());
        options.add(theirOption);
        EObject eObject = this.getDecisionManager().getModelElement(attributeOperation.getModelElementId());
        boolean isMultiline = false;
        try {
            EStructuralFeature feature = attributeOperation.getFeature(eObject);
            isMultiline = this.isMultiline(eObject, feature);
        }
        catch (UnkownFeatureException unkownFeatureException) {}
        if (withMerge && DecisionUtil.detailsNeeded(this) && isMultiline) {
            MergeTextOption mergeOption = new MergeTextOption();
            mergeOption.add(myOption);
            mergeOption.add(theirOption);
            options.add(mergeOption);
        }
    }

    private boolean isMultiline(EObject eObject, EStructuralFeature attribute) {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        IItemPropertyDescriptor propertyDescriptor = adapterFactoryItemDelegator.getPropertyDescriptor((Object)eObject, (Object)attribute);
        boolean isMultiLine = false;
        if (propertyDescriptor != null) {
            isMultiLine = propertyDescriptor.isMultiLine((Object)eObject);
        }
        composedAdapterFactory.dispose();
        return isMultiLine;
    }
}

